/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tiered.storage.specs;

import java.util.Objects;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.server.log.remote.storage.LocalTieredStorageEvent;

public final class RemoteDeleteSegmentSpec {
    private final int sourceBrokerId;
    private final TopicPartition topicPartition;
    private final LocalTieredStorageEvent.EventType eventType;
    private final int eventCount;

    public RemoteDeleteSegmentSpec(int sourceBrokerId, TopicPartition topicPartition, LocalTieredStorageEvent.EventType eventType, int eventCount) {
        this.sourceBrokerId = sourceBrokerId;
        this.topicPartition = topicPartition;
        this.eventType = eventType;
        this.eventCount = eventCount;
    }

    public int getSourceBrokerId() {
        return this.sourceBrokerId;
    }

    public TopicPartition getTopicPartition() {
        return this.topicPartition;
    }

    public LocalTieredStorageEvent.EventType getEventType() {
        return this.eventType;
    }

    public int getEventCount() {
        return this.eventCount;
    }

    public String toString() {
        return String.format("RemoteDeleteSegment[source-broker-id=%d topic-partition=%s event-type=%s event-count=%d]", new Object[]{this.sourceBrokerId, this.topicPartition, this.eventType, this.eventCount});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteDeleteSegmentSpec that = (RemoteDeleteSegmentSpec)o;
        return this.sourceBrokerId == that.sourceBrokerId && this.eventCount == that.eventCount && Objects.equals(this.topicPartition, that.topicPartition) && this.eventType == that.eventType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sourceBrokerId, this.topicPartition, this.eventType, this.eventCount});
    }
}

