/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tiered.storage.actions;

import java.io.PrintStream;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.test.TestUtils;
import org.apache.kafka.tiered.storage.TieredStorageTestAction;
import org.apache.kafka.tiered.storage.TieredStorageTestContext;
import org.apache.kafka.tiered.storage.utils.TieredStorageTestUtils;

public final class ExpectBrokerInISRAction
implements TieredStorageTestAction {
    private final TopicPartition topicPartition;
    private final Integer replicaId;

    public ExpectBrokerInISRAction(TopicPartition topicPartition, Integer replicaId) {
        this.topicPartition = topicPartition;
        this.replicaId = replicaId;
    }

    @Override
    public void doExecute(TieredStorageTestContext context) throws InterruptedException {
        TestUtils.waitForCondition(() -> {
            TopicDescription description = TieredStorageTestUtils.describeTopic(context, this.topicPartition.topic());
            TopicPartitionInfo partitionInfo = (TopicPartitionInfo)description.partitions().get(this.topicPartition.partition());
            if (partitionInfo != null) {
                return partitionInfo.isr().stream().anyMatch(node -> node.id() == this.replicaId.intValue());
            }
            return false;
        }, (String)("Expected broker " + this.replicaId + " to be in ISR for " + this.topicPartition));
    }

    @Override
    public void describe(PrintStream output) {
        output.printf("expect-broker-in-isr topic-partition: %s broker-id: %d%n", this.topicPartition, this.replicaId);
    }
}

