/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.storage;

import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.server.log.remote.storage.RemoteTopicPartitionDirectory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RemoteTopicPartitionDirectoryTest {
    @Test
    public void testSubStr() {
        List<String> topics = Arrays.asList("abcd", "-abcd-10-", "abcd-0-xyz", "abcd.ef-gh-0", "abcd_10_xyz_0");
        for (String topic : topics) {
            for (int i = 0; i < 100; ++i) {
                Uuid uuid = Uuid.randomUuid();
                int partition = (int)(Math.random() * 100.0);
                String filename = String.format("%s-%d-%s", topic, partition, uuid.toString());
                Assertions.assertEquals((Object)topic, (Object)RemoteTopicPartitionDirectory.substr(filename, 1));
                Assertions.assertEquals((int)partition, (int)Integer.parseInt(RemoteTopicPartitionDirectory.substr(filename, 2)));
                Assertions.assertEquals((Object)uuid.toString(), (Object)RemoteTopicPartitionDirectory.substr(filename, 3));
            }
        }
    }
}

