/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tiered.storage.specs;

import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class TopicSpec {
    private final String topicName;
    private final int partitionCount;
    private final int replicationFactor;
    private final int maxBatchCountPerSegment;
    private final Map<Integer, List<Integer>> assignment;
    private final Map<String, String> properties;

    public TopicSpec(String topicName, int partitionCount, int replicationFactor, int maxBatchCountPerSegment, Map<Integer, List<Integer>> assignment, Map<String, String> properties) {
        this.topicName = topicName;
        this.partitionCount = partitionCount;
        this.replicationFactor = replicationFactor;
        this.maxBatchCountPerSegment = maxBatchCountPerSegment;
        this.assignment = assignment;
        this.properties = properties;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public int getPartitionCount() {
        return this.partitionCount;
    }

    public int getReplicationFactor() {
        return this.replicationFactor;
    }

    public int getMaxBatchCountPerSegment() {
        return this.maxBatchCountPerSegment;
    }

    public Map<Integer, List<Integer>> getAssignment() {
        return this.assignment;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String toString() {
        return String.format("Topic[name=%s partition-count=%d replication-factor=%d segment-size=%d assignment=%s properties=%s]", this.topicName, this.partitionCount, this.replicationFactor, this.maxBatchCountPerSegment, this.assignment, this.properties);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicSpec topicSpec = (TopicSpec)o;
        return this.partitionCount == topicSpec.partitionCount && this.replicationFactor == topicSpec.replicationFactor && this.maxBatchCountPerSegment == topicSpec.maxBatchCountPerSegment && Objects.equals(this.topicName, topicSpec.topicName) && Objects.equals(this.assignment, topicSpec.assignment) && Objects.equals(this.properties, topicSpec.properties);
    }

    public int hashCode() {
        return Objects.hash(this.topicName, this.partitionCount, this.replicationFactor, this.maxBatchCountPerSegment, this.assignment, this.properties);
    }
}

