/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tiered.storage.integration;

import java.util.Arrays;
import java.util.Map;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.log.remote.storage.LocalTieredStorageEvent;
import org.apache.kafka.tiered.storage.TieredStorageTestBuilder;
import org.apache.kafka.tiered.storage.TieredStorageTestHarness;
import org.apache.kafka.tiered.storage.specs.KeyValueSpec;

public final class DeleteSegmentsDueToLogStartOffsetBreachTest
extends TieredStorageTestHarness {
    public int brokerCount() {
        return 2;
    }

    @Override
    protected void writeTestSpecifications(TieredStorageTestBuilder builder) {
        Integer broker0 = 0;
        Integer broker1 = 1;
        String topicA = "topicA";
        Integer p0 = 0;
        Integer partitionCount = 1;
        Integer replicationFactor = 2;
        Integer maxBatchCountPerSegment = 2;
        Map replicaAssignment = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)p0, Arrays.asList(broker0, broker1))});
        boolean enableRemoteLogStorage = true;
        boolean beginEpoch = false;
        long startOffset = 3L;
        long beforeOffset = 3L;
        long beforeOffset1 = 7L;
        builder.createTopic("topicA", partitionCount, replicationFactor, maxBatchCountPerSegment, replicaAssignment, true).expectSegmentToBeOffloaded(broker0, "topicA", p0, 0, new KeyValueSpec("k0", "v0"), new KeyValueSpec("k1", "v1")).expectSegmentToBeOffloaded(broker0, "topicA", p0, 2, new KeyValueSpec("k2", "v2"), new KeyValueSpec("k3", "v3")).expectEarliestLocalOffsetInLogDirectory("topicA", p0, 4L).produce("topicA", p0, new KeyValueSpec("k0", "v0"), new KeyValueSpec("k1", "v1"), new KeyValueSpec("k2", "v2"), new KeyValueSpec("k3", "v3"), new KeyValueSpec("k4", "v4")).expectDeletionInRemoteStorage(broker0, "topicA", p0, LocalTieredStorageEvent.EventType.DELETE_SEGMENT, 1).deleteRecords("topicA", p0, 3L).expectLeaderEpochCheckpoint(broker0, "topicA", p0, 0, 3L).expectFetchFromTieredStorage(broker0, "topicA", p0, 1).consume("topicA", p0, 3L, 2, 1).expectLeader("topicA", p0, broker1, true).expectSegmentToBeOffloaded(broker1, "topicA", p0, 4, new KeyValueSpec("k4", "v4"), new KeyValueSpec("k5", "v5")).expectSegmentToBeOffloaded(broker1, "topicA", p0, 6, new KeyValueSpec("k6", "v6"), new KeyValueSpec("k7", "v7")).expectEarliestLocalOffsetInLogDirectory("topicA", p0, 8L).produce("topicA", p0, new KeyValueSpec("k5", "v5"), new KeyValueSpec("k6", "v6"), new KeyValueSpec("k7", "v7"), new KeyValueSpec("k8", "v8"), new KeyValueSpec("k9", "v9")).expectDeletionInRemoteStorage(broker1, "topicA", p0, LocalTieredStorageEvent.EventType.DELETE_SEGMENT, 2).deleteRecords("topicA", p0, 7L).expectFetchFromTieredStorage(broker1, "topicA", p0, 1).consume("topicA", p0, 7L, 3, 1);
    }
}

