/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tiered.storage.integration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.tiered.storage.TieredStorageTestBuilder;
import org.apache.kafka.tiered.storage.TieredStorageTestHarness;
import org.apache.kafka.tiered.storage.specs.KeyValueSpec;

public abstract class BaseReassignReplicaTest
extends TieredStorageTestHarness {
    protected final Integer broker0 = 0;
    protected final Integer broker1 = 1;

    public int brokerCount() {
        return 2;
    }

    @Override
    public int numRemoteLogMetadataPartitions() {
        return 2;
    }

    @Override
    protected void writeTestSpecifications(TieredStorageTestBuilder builder) {
        String topicA = "topicA";
        String topicB = "topicB";
        Integer p0 = 0;
        Integer partitionCount = 1;
        Integer replicationFactor = 1;
        Integer maxBatchCountPerSegment = 1;
        Map<Integer, List<Integer>> replicaAssignment = null;
        boolean enableRemoteLogStorage = true;
        ArrayList<Integer> metadataPartitions = new ArrayList<Integer>();
        for (int i = 0; i < this.numRemoteLogMetadataPartitions(); ++i) {
            metadataPartitions.add(i);
        }
        builder.createTopic("topicA", 50, 2, maxBatchCountPerSegment, replicaAssignment, true).expectUserTopicMappedToMetadataPartitions("topicA", metadataPartitions).createTopic("topicB", partitionCount, replicationFactor, maxBatchCountPerSegment, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)p0, Collections.singletonList(this.broker0))}), true).expectSegmentToBeOffloaded(this.broker0, "topicB", p0, 0, new KeyValueSpec("k0", "v0")).expectSegmentToBeOffloaded(this.broker0, "topicB", p0, 1, new KeyValueSpec("k1", "v1")).expectEarliestLocalOffsetInLogDirectory("topicB", p0, 2L).produce("topicB", p0, new KeyValueSpec("k0", "v0"), new KeyValueSpec("k1", "v1"), new KeyValueSpec("k2", "v2")).reassignReplica("topicB", p0, this.replicaIds()).expectLeader("topicB", p0, this.broker1, true).expectEarliestLocalOffsetInLogDirectory("topicB", p0, 3L).produce("topicB", p0, new KeyValueSpec("k3", "v3")).expectFetchFromTieredStorage(this.broker1, "topicB", p0, 3).consume("topicB", p0, 0L, 4, 3);
    }

    protected abstract List<Integer> replicaIds();
}

