/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tiered.storage.actions;

import java.io.PrintStream;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.storage.internals.log.EpochEntry;
import org.apache.kafka.tiered.storage.TieredStorageTestAction;
import org.apache.kafka.tiered.storage.TieredStorageTestContext;
import org.junit.jupiter.api.Assertions;

public final class ExpectListOffsetsAction
implements TieredStorageTestAction {
    private final TopicPartition partition;
    private final OffsetSpec spec;
    private final EpochEntry expected;

    public ExpectListOffsetsAction(TopicPartition partition, OffsetSpec spec, EpochEntry expected) {
        this.partition = partition;
        this.spec = spec;
        this.expected = expected;
    }

    @Override
    public void doExecute(TieredStorageTestContext context) throws InterruptedException, ExecutionException {
        ListOffsetsResult.ListOffsetsResultInfo listOffsetsResult = (ListOffsetsResult.ListOffsetsResultInfo)((Map)context.admin().listOffsets(Collections.singletonMap(this.partition, this.spec)).all().get()).get(this.partition);
        Assertions.assertEquals((long)this.expected.startOffset, (long)listOffsetsResult.offset());
        if (this.expected.epoch != -1) {
            Assertions.assertTrue((boolean)listOffsetsResult.leaderEpoch().isPresent());
            Assertions.assertEquals((int)this.expected.epoch, (Integer)((Integer)listOffsetsResult.leaderEpoch().get()));
        }
    }

    @Override
    public void describe(PrintStream output) {
        output.printf("expect-list-offsets partition: %s, spec: %s, expected-epoch-and-offset: %s%n", this.partition, this.spec, this.expected);
    }
}

