/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tiered.storage.actions;

import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.RecordsToDelete;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.server.log.remote.storage.LocalTieredStorage;
import org.apache.kafka.server.log.remote.storage.LocalTieredStorageCondition;
import org.apache.kafka.server.log.remote.storage.LocalTieredStorageEvent;
import org.apache.kafka.tiered.storage.TieredStorageTestAction;
import org.apache.kafka.tiered.storage.TieredStorageTestContext;
import org.apache.kafka.tiered.storage.specs.RemoteDeleteSegmentSpec;

public final class DeleteRecordsAction
implements TieredStorageTestAction {
    private static final int DELETE_WAIT_TIMEOUT_SEC = 10;
    private final TopicPartition partition;
    private final Long beforeOffset;
    private final List<RemoteDeleteSegmentSpec> deleteSegmentSpecs;

    public DeleteRecordsAction(TopicPartition partition, Long beforeOffset, List<RemoteDeleteSegmentSpec> deleteSegmentSpecs) {
        this.partition = partition;
        this.beforeOffset = beforeOffset;
        this.deleteSegmentSpecs = deleteSegmentSpecs;
    }

    @Override
    public void doExecute(TieredStorageTestContext context) throws InterruptedException, ExecutionException, TimeoutException {
        List<LocalTieredStorage> tieredStorages = context.remoteStorageManagers();
        List tieredStorageConditions = this.deleteSegmentSpecs.stream().filter(spec -> spec.getEventType() == LocalTieredStorageEvent.EventType.DELETE_SEGMENT).map(spec -> LocalTieredStorageCondition.expectEvent((Iterable<LocalTieredStorage>)tieredStorages, spec.getEventType(), spec.getSourceBrokerId(), spec.getTopicPartition(), false, spec.getEventCount())).collect(Collectors.toList());
        Map<TopicPartition, RecordsToDelete> recordsToDeleteMap = Collections.singletonMap(this.partition, RecordsToDelete.beforeOffset((long)this.beforeOffset));
        context.admin().deleteRecords(recordsToDeleteMap).all().get();
        if (!tieredStorageConditions.isEmpty()) {
            ((LocalTieredStorageCondition)tieredStorageConditions.stream().reduce(LocalTieredStorageCondition::and).get()).waitUntilTrue(10L, TimeUnit.SECONDS);
        }
    }

    @Override
    public void describe(PrintStream output) {
        output.printf("delete-records partition: %s, before-offset: %d%n", this.partition, this.beforeOffset);
        this.deleteSegmentSpecs.forEach(spec -> output.println("    " + spec));
    }
}

