/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.storage;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.kafka.server.log.remote.storage.LocalTieredStorageEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface LocalTieredStorageListener {
    public void onStorageEvent(LocalTieredStorageEvent var1);

    public static final class LocalTieredStorageListeners
    implements LocalTieredStorageListener {
        private static final Logger LOGGER = LoggerFactory.getLogger(LocalTieredStorageListener.class);
        private final List<LocalTieredStorageListener> listeners = new CopyOnWriteArrayList<LocalTieredStorageListener>();

        public void add(LocalTieredStorageListener listener) {
            this.listeners.add(Objects.requireNonNull(listener));
        }

        @Override
        public void onStorageEvent(LocalTieredStorageEvent event) {
            for (LocalTieredStorageListener listener : this.listeners) {
                try {
                    listener.onStorageEvent(event);
                }
                catch (Exception e) {
                    LOGGER.error("Caught failure from listener: {}", (Object)listener, (Object)e);
                }
            }
        }
    }
}

