/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.snapshot;

import java.nio.ByteBuffer;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.UnalignedMemoryRecords;
import org.apache.kafka.common.record.UnalignedRecords;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.snapshot.RawSnapshotReader;

public final class MockRawSnapshotReader
implements RawSnapshotReader {
    private final OffsetAndEpoch snapshotId;
    private final MemoryRecords data;

    public MockRawSnapshotReader(OffsetAndEpoch snapshotId, ByteBuffer data) {
        this.snapshotId = snapshotId;
        this.data = MemoryRecords.readableRecords((ByteBuffer)data);
    }

    public OffsetAndEpoch snapshotId() {
        return this.snapshotId;
    }

    public long sizeInBytes() {
        return this.data.sizeInBytes();
    }

    public UnalignedRecords slice(long position, int size) {
        ByteBuffer buffer = this.data.buffer();
        buffer.position(Math.toIntExact(position));
        buffer.limit(Math.min(buffer.limit(), Math.toIntExact(position + (long)size)));
        return new UnalignedMemoryRecords(buffer.slice());
    }

    public Records records() {
        return this.data;
    }

    public String toString() {
        return String.format("MockRawSnapshotReader(snapshotId=%s, data=%s)", this.snapshotId, this.data);
    }
}

