/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.io.File;
import java.io.IOException;
import java.util.OptionalInt;
import java.util.Set;
import org.apache.kafka.common.protocol.types.TaggedFields;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.raft.ElectionState;
import org.apache.kafka.raft.FileBasedStateStore;
import org.apache.kafka.raft.generated.QuorumStateData;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileBasedStateStoreTest {
    private FileBasedStateStore stateStore;

    @Test
    public void testReadElectionState() throws IOException {
        File stateFile = TestUtils.tempFile();
        this.stateStore = new FileBasedStateStore(stateFile);
        boolean leaderId = true;
        int epoch = 2;
        Set voters = Utils.mkSet((Object[])new Integer[]{1});
        this.stateStore.writeElectionState(ElectionState.withElectedLeader((int)2, (int)1, (Set)voters));
        Assertions.assertTrue((boolean)stateFile.exists());
        Assertions.assertEquals((Object)ElectionState.withElectedLeader((int)2, (int)1, (Set)voters), (Object)this.stateStore.readElectionState());
        FileBasedStateStore secondStateStore = new FileBasedStateStore(stateFile);
        Assertions.assertEquals((Object)ElectionState.withElectedLeader((int)2, (int)1, (Set)voters), (Object)secondStateStore.readElectionState());
    }

    @Test
    public void testWriteElectionState() throws IOException {
        File stateFile = TestUtils.tempFile();
        this.stateStore = new FileBasedStateStore(stateFile);
        Assertions.assertTrue((boolean)stateFile.exists());
        File createdTempFile = new File(stateFile.getAbsolutePath() + ".tmp");
        Assertions.assertFalse((boolean)createdTempFile.exists());
        int epoch = 2;
        boolean leaderId = true;
        int votedId = 5;
        Set voters = Utils.mkSet((Object[])new Integer[]{1, 5});
        this.stateStore.writeElectionState(ElectionState.withElectedLeader((int)2, (int)1, (Set)voters));
        Assertions.assertEquals((Object)this.stateStore.readElectionState(), (Object)new ElectionState(2, OptionalInt.of(1), OptionalInt.empty(), voters));
        this.stateStore.writeElectionState(ElectionState.withVotedCandidate((int)2, (int)5, (Set)voters));
        Assertions.assertEquals((Object)this.stateStore.readElectionState(), (Object)new ElectionState(2, OptionalInt.empty(), OptionalInt.of(5), voters));
        FileBasedStateStore rebootStateStore = new FileBasedStateStore(stateFile);
        Assertions.assertEquals((Object)rebootStateStore.readElectionState(), (Object)new ElectionState(2, OptionalInt.empty(), OptionalInt.of(5), voters));
        this.stateStore.clear();
        Assertions.assertFalse((boolean)stateFile.exists());
    }

    @Test
    public void testSupportedVersion() {
        Assertions.assertEquals((short)0, (short)0);
        Assertions.assertEquals((int)0, (int)0);
        Assertions.assertEquals((int)0, (int)0);
        TaggedFields taggedFields = (TaggedFields)QuorumStateData.SCHEMA_0.get((int)6).def.type;
        Assertions.assertEquals((int)0, (int)taggedFields.numFields());
    }

    @AfterEach
    public void cleanup() throws IOException {
        if (this.stateStore != null) {
            this.stateStore.clear();
        }
    }
}

