/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.snapshot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import org.apache.kafka.common.message.SnapshotFooterRecord;
import org.apache.kafka.common.message.SnapshotHeaderRecord;
import org.apache.kafka.common.record.ControlRecordUtils;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.CloseableIterator;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.raft.Batch;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.RaftClientTestContext;
import org.apache.kafka.raft.internals.StringSerde;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.kafka.snapshot.RecordsSnapshotReader;
import org.apache.kafka.snapshot.SnapshotReader;
import org.apache.kafka.snapshot.SnapshotWriter;
import org.apache.kafka.snapshot.Snapshots;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class SnapshotWriterReaderTest {
    private final int localId = 0;
    private final Set<Integer> voters = Collections.singleton(0);

    @Test
    public void testSnapshotDelimiters() throws Exception {
        int recordsPerBatch = 1;
        int batches = 0;
        int delimiterCount = 2;
        long magicTimestamp = -559038737L;
        OffsetAndEpoch id = new OffsetAndEpoch((long)(recordsPerBatch * batches), 3);
        RaftClientTestContext.Builder contextBuilder = new RaftClientTestContext.Builder(0, this.voters);
        RaftClientTestContext context = contextBuilder.build();
        context.pollUntil(() -> context.currentLeader().equals(OptionalInt.of(0)));
        context.advanceLocalLeaderHighWatermarkToLogEndOffset();
        try (SnapshotWriter snapshot = (SnapshotWriter)context.client.createSnapshot(id, magicTimestamp).get();){
            Assertions.assertEquals((Object)id, (Object)snapshot.snapshotId());
            snapshot.freeze();
        }
        try (SnapshotReader<String> reader = this.readSnapshot(context, id, Integer.MAX_VALUE);){
            Assertions.assertEquals((long)magicTimestamp, (long)reader.lastContainedLogTimestamp());
            RawSnapshotReader snapshot = context.log.readSnapshot(id).get();
            int recordCount = this.validateDelimiters(snapshot, magicTimestamp);
            Assertions.assertEquals((int)(recordsPerBatch * batches + delimiterCount), (int)recordCount);
        }
    }

    @Test
    public void testWritingSnapshot() throws Exception {
        int recordsPerBatch = 3;
        int batches = 3;
        int delimiterCount = 2;
        long magicTimestamp = -559038737L;
        OffsetAndEpoch id = new OffsetAndEpoch((long)(recordsPerBatch * batches), 3);
        List<List<String>> expected = this.buildRecords(recordsPerBatch, batches);
        RaftClientTestContext.Builder contextBuilder = new RaftClientTestContext.Builder(0, this.voters);
        for (List<String> batch2 : expected) {
            contextBuilder.appendToLog(id.epoch(), batch2);
        }
        RaftClientTestContext context = contextBuilder.build();
        context.pollUntil(() -> context.currentLeader().equals(OptionalInt.of(0)));
        context.advanceLocalLeaderHighWatermarkToLogEndOffset();
        try (SnapshotWriter snapshot = (SnapshotWriter)context.client.createSnapshot(id, magicTimestamp).get();){
            Assertions.assertEquals((Object)id, (Object)snapshot.snapshotId());
            expected.forEach(batch -> Assertions.assertDoesNotThrow(() -> snapshot.append(batch)));
            snapshot.freeze();
        }
        try (SnapshotReader<String> reader = this.readSnapshot(context, id, Integer.MAX_VALUE);){
            RawSnapshotReader snapshot = context.log.readSnapshot(id).get();
            int recordCount = this.validateDelimiters(snapshot, magicTimestamp);
            Assertions.assertEquals((int)(recordsPerBatch * batches + delimiterCount), (int)recordCount);
            SnapshotWriterReaderTest.assertSnapshot(expected, reader);
            Assertions.assertEquals((long)magicTimestamp, (long)Snapshots.lastContainedLogTimestamp((RawSnapshotReader)snapshot));
        }
    }

    @Test
    public void testAbortedSnapshot() throws Exception {
        int recordsPerBatch = 3;
        int batches = 3;
        OffsetAndEpoch id = new OffsetAndEpoch((long)(recordsPerBatch * batches), 3);
        List<List<String>> expected = this.buildRecords(recordsPerBatch, batches);
        RaftClientTestContext.Builder contextBuilder = new RaftClientTestContext.Builder(0, this.voters);
        for (List<String> batch2 : expected) {
            contextBuilder.appendToLog(id.epoch(), batch2);
        }
        RaftClientTestContext context = contextBuilder.build();
        context.pollUntil(() -> context.currentLeader().equals(OptionalInt.of(0)));
        context.advanceLocalLeaderHighWatermarkToLogEndOffset();
        try (SnapshotWriter snapshot = (SnapshotWriter)context.client.createSnapshot(id, 0L).get();){
            Assertions.assertEquals((Object)id, (Object)snapshot.snapshotId());
            expected.forEach(batch -> Assertions.assertDoesNotThrow(() -> snapshot.append(batch)));
        }
        Assertions.assertEquals(Optional.empty(), context.log.readSnapshot(id));
    }

    @Test
    public void testAppendToFrozenSnapshot() throws Exception {
        int recordsPerBatch = 3;
        int batches = 3;
        OffsetAndEpoch id = new OffsetAndEpoch((long)(recordsPerBatch * batches), 3);
        List<List<String>> expected = this.buildRecords(recordsPerBatch, batches);
        RaftClientTestContext.Builder contextBuilder = new RaftClientTestContext.Builder(0, this.voters);
        for (List<String> batch2 : expected) {
            contextBuilder.appendToLog(id.epoch(), batch2);
        }
        RaftClientTestContext context = contextBuilder.build();
        context.pollUntil(() -> context.currentLeader().equals(OptionalInt.of(0)));
        context.advanceLocalLeaderHighWatermarkToLogEndOffset();
        try (SnapshotWriter snapshot = (SnapshotWriter)context.client.createSnapshot(id, 0L).get();){
            Assertions.assertEquals((Object)id, (Object)snapshot.snapshotId());
            expected.forEach(batch -> Assertions.assertDoesNotThrow(() -> snapshot.append(batch)));
            snapshot.freeze();
            Assertions.assertThrows(RuntimeException.class, () -> snapshot.append((List)expected.get(0)));
        }
    }

    private List<List<String>> buildRecords(int recordsPerBatch, int batches) {
        Random random = new Random(0L);
        ArrayList<List<String>> result = new ArrayList<List<String>>(batches);
        for (int i = 0; i < batches; ++i) {
            ArrayList<String> batch = new ArrayList<String>(recordsPerBatch);
            for (int j = 0; j < recordsPerBatch; ++j) {
                batch.add(String.valueOf(random.nextInt()));
            }
            result.add(batch);
        }
        return result;
    }

    private SnapshotReader<String> readSnapshot(RaftClientTestContext context, OffsetAndEpoch snapshotId, int maxBatchSize) {
        return RecordsSnapshotReader.of((RawSnapshotReader)context.log.readSnapshot(snapshotId).get(), context.serde, (BufferSupplier)BufferSupplier.create(), (int)maxBatchSize, (boolean)true);
    }

    private int validateDelimiters(RawSnapshotReader snapshot, long lastContainedLogTime) {
        Assertions.assertNotEquals((long)0L, (long)snapshot.sizeInBytes());
        int countRecords = 0;
        Iterator recordBatches = Utils.covariantCast((Iterator)snapshot.records().batchIterator());
        Assertions.assertTrue((boolean)recordBatches.hasNext());
        RecordBatch batch = (RecordBatch)recordBatches.next();
        CloseableIterator records = batch.streamingIterator((BufferSupplier)new BufferSupplier.GrowableBufferSupplier());
        Assertions.assertTrue((boolean)batch.isControlBatch());
        Assertions.assertTrue((boolean)records.hasNext());
        Record record = (Record)records.next();
        ++countRecords;
        SnapshotHeaderRecord headerRecord = ControlRecordUtils.deserializeSnapshotHeaderRecord((Record)record);
        Assertions.assertEquals((short)headerRecord.version(), (short)0);
        Assertions.assertEquals((long)headerRecord.lastContainedLogTimestamp(), (long)lastContainedLogTime);
        Assertions.assertFalse((boolean)records.hasNext());
        while (recordBatches.hasNext()) {
            batch = (RecordBatch)recordBatches.next();
            records = batch.streamingIterator((BufferSupplier)new BufferSupplier.GrowableBufferSupplier());
            while (records.hasNext()) {
                ++countRecords;
                record = (Record)records.next();
            }
        }
        Assertions.assertTrue((boolean)batch.isControlBatch());
        SnapshotFooterRecord footerRecord = ControlRecordUtils.deserializeSnapshotFooterRecord((Record)record);
        Assertions.assertEquals((short)footerRecord.version(), (short)0);
        return countRecords;
    }

    public static void assertSnapshot(List<List<String>> batches, RawSnapshotReader reader) {
        SnapshotWriterReaderTest.assertSnapshot(batches, (SnapshotReader<String>)RecordsSnapshotReader.of((RawSnapshotReader)reader, (RecordSerde)new StringSerde(), (BufferSupplier)BufferSupplier.create(), (int)Integer.MAX_VALUE, (boolean)true));
    }

    public static void assertSnapshot(List<List<String>> batches, SnapshotReader<String> reader) {
        ArrayList expected = new ArrayList();
        batches.forEach(expected::addAll);
        ArrayList<String> actual = new ArrayList<String>(expected.size());
        while (reader.hasNext()) {
            Batch batch = (Batch)reader.next();
            for (String value : batch) {
                actual.add(value);
            }
        }
        Assertions.assertEquals(expected, actual);
    }
}

