/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.snapshot;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.UnalignedMemoryRecords;
import org.apache.kafka.common.utils.ByteBufferOutputStream;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.snapshot.RawSnapshotWriter;

public final class MockRawSnapshotWriter
implements RawSnapshotWriter {
    private final ByteBufferOutputStream data = new ByteBufferOutputStream(0);
    private final OffsetAndEpoch snapshotId;
    private final Consumer<ByteBuffer> frozenHandler;
    private boolean frozen = false;
    private boolean closed = false;

    public MockRawSnapshotWriter(OffsetAndEpoch snapshotId, Consumer<ByteBuffer> frozenHandler) {
        this.snapshotId = snapshotId;
        this.frozenHandler = frozenHandler;
    }

    public OffsetAndEpoch snapshotId() {
        return this.snapshotId;
    }

    public long sizeInBytes() {
        this.ensureOpen();
        return this.data.position();
    }

    public void append(UnalignedMemoryRecords records) {
        this.ensureNotFrozenOrClosed();
        this.data.write(records.buffer());
    }

    public void append(MemoryRecords records) {
        this.ensureNotFrozenOrClosed();
        this.data.write(records.buffer());
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void freeze() {
        this.ensureNotFrozenOrClosed();
        this.frozen = true;
        ByteBuffer buffer = this.data.buffer();
        buffer.flip();
        this.frozenHandler.accept(buffer);
    }

    public void close() {
        this.ensureOpen();
        this.closed = true;
    }

    public String toString() {
        return String.format("MockRawSnapshotWriter(snapshotId=%s, data=%s)", this.snapshotId, this.data.buffer());
    }

    private void ensureNotFrozenOrClosed() {
        if (this.frozen) {
            throw new IllegalStateException("Snapshot is already frozen " + this.snapshotId);
        }
        this.ensureOpen();
    }

    private void ensureOpen() {
        if (this.closed) {
            throw new IllegalStateException("Snapshot is already closed " + this.snapshotId);
        }
    }
}

