/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft.internals;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.raft.ExpirationService;
import org.apache.kafka.raft.MockExpirationService;
import org.apache.kafka.raft.internals.ThresholdPurgatory;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ThresholdPurgatoryTest {
    private final MockTime time = new MockTime();
    private final MockExpirationService expirationService = new MockExpirationService(this.time);
    private final ThresholdPurgatory<Long> purgatory = new ThresholdPurgatory((ExpirationService)this.expirationService);

    ThresholdPurgatoryTest() {
    }

    @Test
    public void testThresholdCompletion() throws Exception {
        CompletableFuture future1 = this.purgatory.await((Comparable)Long.valueOf(3L), 500L);
        CompletableFuture future2 = this.purgatory.await((Comparable)Long.valueOf(1L), 500L);
        CompletableFuture future3 = this.purgatory.await((Comparable)Long.valueOf(5L), 500L);
        Assertions.assertEquals((int)3, (int)this.purgatory.numWaiting());
        long completionTime1 = this.time.milliseconds();
        this.purgatory.maybeComplete((Comparable)Long.valueOf(1L), completionTime1);
        Assertions.assertTrue((boolean)future2.isDone());
        Assertions.assertFalse((boolean)future1.isDone());
        Assertions.assertFalse((boolean)future3.isDone());
        Assertions.assertEquals((long)completionTime1, (Long)((Long)future2.get()));
        Assertions.assertEquals((int)2, (int)this.purgatory.numWaiting());
        this.time.sleep(100L);
        this.purgatory.maybeComplete((Comparable)Long.valueOf(2L), this.time.milliseconds());
        Assertions.assertFalse((boolean)future1.isDone());
        Assertions.assertFalse((boolean)future3.isDone());
        this.time.sleep(100L);
        long completionTime2 = this.time.milliseconds();
        this.purgatory.maybeComplete((Comparable)Long.valueOf(3L), completionTime2);
        Assertions.assertTrue((boolean)future1.isDone());
        Assertions.assertFalse((boolean)future3.isDone());
        Assertions.assertEquals((long)completionTime2, (Long)((Long)future1.get()));
        Assertions.assertEquals((int)1, (int)this.purgatory.numWaiting());
        this.time.sleep(100L);
        this.purgatory.maybeComplete((Comparable)Long.valueOf(4L), this.time.milliseconds());
        Assertions.assertFalse((boolean)future3.isDone());
        this.time.sleep(100L);
        long completionTime3 = this.time.milliseconds();
        this.purgatory.maybeComplete((Comparable)Long.valueOf(5L), completionTime3);
        Assertions.assertTrue((boolean)future3.isDone());
        Assertions.assertEquals((long)completionTime3, (Long)((Long)future3.get()));
        Assertions.assertEquals((int)0, (int)this.purgatory.numWaiting());
    }

    @Test
    public void testExpiration() {
        CompletableFuture future1 = this.purgatory.await((Comparable)Long.valueOf(1L), 200L);
        CompletableFuture future2 = this.purgatory.await((Comparable)Long.valueOf(1L), 200L);
        Assertions.assertEquals((int)2, (int)this.purgatory.numWaiting());
        this.time.sleep(100L);
        CompletableFuture future3 = this.purgatory.await((Comparable)Long.valueOf(5L), 50L);
        CompletableFuture future4 = this.purgatory.await((Comparable)Long.valueOf(5L), 200L);
        CompletableFuture future5 = this.purgatory.await((Comparable)Long.valueOf(5L), 100L);
        Assertions.assertEquals((int)5, (int)this.purgatory.numWaiting());
        this.time.sleep(50L);
        TestUtils.assertFutureThrows((Future)future3, TimeoutException.class);
        Assertions.assertFalse((boolean)future1.isDone());
        Assertions.assertFalse((boolean)future2.isDone());
        Assertions.assertFalse((boolean)future4.isDone());
        Assertions.assertFalse((boolean)future5.isDone());
        Assertions.assertEquals((int)4, (int)this.purgatory.numWaiting());
        this.time.sleep(50L);
        TestUtils.assertFutureThrows((Future)future1, TimeoutException.class);
        TestUtils.assertFutureThrows((Future)future2, TimeoutException.class);
        TestUtils.assertFutureThrows((Future)future5, TimeoutException.class);
        Assertions.assertFalse((boolean)future4.isDone());
        Assertions.assertEquals((int)1, (int)this.purgatory.numWaiting());
        this.time.sleep(50L);
        Assertions.assertFalse((boolean)future4.isDone());
        Assertions.assertEquals((int)1, (int)this.purgatory.numWaiting());
        this.time.sleep(50L);
        TestUtils.assertFutureThrows((Future)future4, TimeoutException.class);
        Assertions.assertEquals((int)0, (int)this.purgatory.numWaiting());
    }

    @Test
    public void testCompleteAll() throws Exception {
        CompletableFuture future1 = this.purgatory.await((Comparable)Long.valueOf(3L), 500L);
        CompletableFuture future2 = this.purgatory.await((Comparable)Long.valueOf(1L), 500L);
        CompletableFuture future3 = this.purgatory.await((Comparable)Long.valueOf(5L), 500L);
        Assertions.assertEquals((int)3, (int)this.purgatory.numWaiting());
        long completionTime = this.time.milliseconds();
        this.purgatory.completeAll(completionTime);
        Assertions.assertEquals((long)completionTime, (Long)((Long)future1.get()));
        Assertions.assertEquals((long)completionTime, (Long)((Long)future2.get()));
        Assertions.assertEquals((long)completionTime, (Long)((Long)future3.get()));
        Assertions.assertEquals((int)0, (int)this.purgatory.numWaiting());
    }

    @Test
    public void testCompleteAllExceptionally() {
        CompletableFuture future1 = this.purgatory.await((Comparable)Long.valueOf(3L), 500L);
        CompletableFuture future2 = this.purgatory.await((Comparable)Long.valueOf(1L), 500L);
        CompletableFuture future3 = this.purgatory.await((Comparable)Long.valueOf(5L), 500L);
        Assertions.assertEquals((int)3, (int)this.purgatory.numWaiting());
        this.purgatory.completeAllExceptionally((Throwable)new NotLeaderOrFollowerException());
        TestUtils.assertFutureThrows((Future)future1, NotLeaderOrFollowerException.class);
        TestUtils.assertFutureThrows((Future)future2, NotLeaderOrFollowerException.class);
        TestUtils.assertFutureThrows((Future)future3, NotLeaderOrFollowerException.class);
        Assertions.assertEquals((int)0, (int)this.purgatory.numWaiting());
    }

    @Test
    public void testExternalCompletion() {
        CompletableFuture future1 = this.purgatory.await((Comparable)Long.valueOf(3L), 500L);
        CompletableFuture future2 = this.purgatory.await((Comparable)Long.valueOf(1L), 500L);
        CompletableFuture future3 = this.purgatory.await((Comparable)Long.valueOf(5L), 500L);
        Assertions.assertEquals((int)3, (int)this.purgatory.numWaiting());
        future2.complete(this.time.milliseconds());
        Assertions.assertFalse((boolean)future1.isDone());
        Assertions.assertFalse((boolean)future3.isDone());
        Assertions.assertEquals((int)2, (int)this.purgatory.numWaiting());
        future1.complete(this.time.milliseconds());
        Assertions.assertFalse((boolean)future3.isDone());
        Assertions.assertEquals((int)1, (int)this.purgatory.numWaiting());
        future3.complete(this.time.milliseconds());
        Assertions.assertEquals((int)0, (int)this.purgatory.numWaiting());
    }
}

