/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft.internals;

import org.apache.kafka.raft.RaftMessage;
import org.apache.kafka.raft.internals.BlockingMessageQueue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class BlockingMessageQueueTest {
    BlockingMessageQueueTest() {
    }

    @Test
    public void testOfferAndPoll() {
        BlockingMessageQueue queue = new BlockingMessageQueue();
        Assertions.assertTrue((boolean)queue.isEmpty());
        Assertions.assertNull((Object)queue.poll(0L));
        RaftMessage message1 = (RaftMessage)Mockito.mock(RaftMessage.class);
        queue.add(message1);
        Assertions.assertFalse((boolean)queue.isEmpty());
        Assertions.assertEquals((Object)message1, (Object)queue.poll(0L));
        Assertions.assertTrue((boolean)queue.isEmpty());
        RaftMessage message2 = (RaftMessage)Mockito.mock(RaftMessage.class);
        RaftMessage message3 = (RaftMessage)Mockito.mock(RaftMessage.class);
        queue.add(message2);
        queue.add(message3);
        Assertions.assertFalse((boolean)queue.isEmpty());
        Assertions.assertEquals((Object)message2, (Object)queue.poll(0L));
        Assertions.assertEquals((Object)message3, (Object)queue.poll(0L));
    }

    @Test
    public void testWakeupFromPoll() {
        BlockingMessageQueue queue = new BlockingMessageQueue();
        queue.wakeup();
        Assertions.assertNull((Object)queue.poll(Long.MAX_VALUE));
    }
}

