/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft.internals;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.raft.internals.BatchBuilder;
import org.apache.kafka.raft.internals.StringSerde;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.ValueSource;

class BatchBuilderTest {
    private StringSerde serde = new StringSerde();
    private MockTime time = new MockTime();

    BatchBuilderTest() {
    }

    @ParameterizedTest
    @EnumSource(value=CompressionType.class)
    void testBuildBatch(CompressionType compressionType) {
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        long baseOffset = 57L;
        long logAppendTime = this.time.milliseconds();
        boolean isControlBatch = false;
        int leaderEpoch = 15;
        BatchBuilder builder = new BatchBuilder(buffer, (RecordSerde)this.serde, compressionType, baseOffset, logAppendTime, isControlBatch, leaderEpoch, buffer.limit());
        List<String> records = Arrays.asList("a", "ap", "app", "appl", "apple");
        records.forEach(record -> builder.appendRecord(record, null));
        MemoryRecords builtRecordSet = builder.build();
        Assertions.assertTrue((boolean)builder.bytesNeeded(Arrays.asList("a"), null).isPresent());
        Assertions.assertThrows(IllegalStateException.class, () -> builder.appendRecord((Object)"a", null));
        List builtBatches = Utils.toList((Iterator)builtRecordSet.batchIterator());
        Assertions.assertEquals((int)1, (int)builtBatches.size());
        Assertions.assertEquals(records, (Object)builder.records());
        MutableRecordBatch batch = (MutableRecordBatch)builtBatches.get(0);
        Assertions.assertEquals((int)5, (Integer)batch.countOrNull());
        Assertions.assertEquals((Object)compressionType, (Object)batch.compressionType());
        Assertions.assertEquals((long)baseOffset, (long)batch.baseOffset());
        Assertions.assertEquals((long)logAppendTime, (long)batch.maxTimestamp());
        Assertions.assertEquals((Object)isControlBatch, (Object)batch.isControlBatch());
        Assertions.assertEquals((int)leaderEpoch, (int)batch.partitionLeaderEpoch());
        List builtRecords = Utils.toList((Iterable)batch).stream().map(record -> Utils.utf8((ByteBuffer)record.value())).collect(Collectors.toList());
        Assertions.assertEquals(records, builtRecords);
    }

    @ParameterizedTest
    @ValueSource(ints={128, 157, 256, 433, 512, 777, 1024})
    public void testHasRoomForUncompressed(int batchSize) {
        ByteBuffer buffer = ByteBuffer.allocate(batchSize);
        long baseOffset = 57L;
        long logAppendTime = this.time.milliseconds();
        boolean isControlBatch = false;
        int leaderEpoch = 15;
        BatchBuilder builder = new BatchBuilder(buffer, (RecordSerde)this.serde, CompressionType.NONE, baseOffset, logAppendTime, isControlBatch, leaderEpoch, buffer.limit());
        String record = "i am a record";
        while (!builder.bytesNeeded(Arrays.asList(record), null).isPresent()) {
            builder.appendRecord((Object)record, null);
        }
        int sizeInBytes = builder.approximateSizeInBytes();
        MemoryRecords records = builder.build();
        Assertions.assertEquals((int)sizeInBytes, (int)records.sizeInBytes());
        Assertions.assertTrue((sizeInBytes <= batchSize ? 1 : 0) != 0, (String)("Built batch size " + sizeInBytes + " is larger than max batch size " + batchSize));
    }
}

