/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.raft.ElectionState;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.VotedState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class VotedStateTest {
    private final MockTime time = new MockTime();
    private final LogContext logContext = new LogContext();
    private final int epoch = 5;
    private final int votedId = 1;
    private final int electionTimeoutMs = 10000;

    VotedStateTest() {
    }

    private VotedState newVotedState(Set<Integer> voters, Optional<LogOffsetMetadata> highWatermark) {
        return new VotedState((Time)this.time, 5, 1, voters, highWatermark, 10000, this.logContext);
    }

    @Test
    public void testElectionTimeout() {
        Set voters = Utils.mkSet((Object[])new Integer[]{1, 2, 3});
        VotedState state = this.newVotedState(voters, Optional.empty());
        Assertions.assertEquals((int)5, (int)state.epoch());
        Assertions.assertEquals((int)1, (int)state.votedId());
        Assertions.assertEquals((Object)ElectionState.withVotedCandidate((int)5, (int)1, (Set)voters), (Object)state.election());
        Assertions.assertEquals((long)10000L, (long)state.remainingElectionTimeMs(this.time.milliseconds()));
        Assertions.assertFalse((boolean)state.hasElectionTimeoutExpired(this.time.milliseconds()));
        this.time.sleep(5000L);
        Assertions.assertEquals((long)5000L, (long)state.remainingElectionTimeMs(this.time.milliseconds()));
        Assertions.assertFalse((boolean)state.hasElectionTimeoutExpired(this.time.milliseconds()));
        this.time.sleep(5000L);
        Assertions.assertEquals((long)0L, (long)state.remainingElectionTimeMs(this.time.milliseconds()));
        Assertions.assertTrue((boolean)state.hasElectionTimeoutExpired(this.time.milliseconds()));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testGrantVote(boolean isLogUpToDate) {
        VotedState state = this.newVotedState(Utils.mkSet((Object[])new Integer[]{1, 2, 3}), Optional.empty());
        Assertions.assertTrue((boolean)state.canGrantVote(1, isLogUpToDate));
        Assertions.assertFalse((boolean)state.canGrantVote(2, isLogUpToDate));
        Assertions.assertFalse((boolean)state.canGrantVote(3, isLogUpToDate));
    }
}

