/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.raft.ElectionState;
import org.apache.kafka.raft.ResignedState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class ResignedStateTest {
    private final MockTime time = new MockTime();
    private final LogContext logContext = new LogContext();
    int electionTimeoutMs = 5000;
    int localId = 0;
    int epoch = 5;

    ResignedStateTest() {
    }

    private ResignedState newResignedState(Set<Integer> voters, List<Integer> preferredSuccessors) {
        return new ResignedState((Time)this.time, this.localId, this.epoch, voters, (long)this.electionTimeoutMs, preferredSuccessors, this.logContext);
    }

    @Test
    public void testResignedState() {
        int remoteId = 1;
        Set voters = Utils.mkSet((Object[])new Integer[]{this.localId, remoteId});
        ResignedState state = this.newResignedState(voters, Collections.emptyList());
        Assertions.assertEquals((Object)ElectionState.withElectedLeader((int)this.epoch, (int)this.localId, (Set)voters), (Object)state.election());
        Assertions.assertEquals((int)this.epoch, (int)state.epoch());
        Assertions.assertEquals(Collections.singleton(remoteId), (Object)state.unackedVoters());
        state.acknowledgeResignation(remoteId);
        Assertions.assertEquals(Collections.emptySet(), (Object)state.unackedVoters());
        Assertions.assertEquals((long)this.electionTimeoutMs, (long)state.remainingElectionTimeMs(this.time.milliseconds()));
        Assertions.assertFalse((boolean)state.hasElectionTimeoutExpired(this.time.milliseconds()));
        this.time.sleep((long)(this.electionTimeoutMs / 2));
        Assertions.assertEquals((long)(this.electionTimeoutMs / 2), (long)state.remainingElectionTimeMs(this.time.milliseconds()));
        Assertions.assertFalse((boolean)state.hasElectionTimeoutExpired(this.time.milliseconds()));
        this.time.sleep((long)(this.electionTimeoutMs / 2));
        Assertions.assertEquals((long)0L, (long)state.remainingElectionTimeMs(this.time.milliseconds()));
        Assertions.assertTrue((boolean)state.hasElectionTimeoutExpired(this.time.milliseconds()));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testGrantVote(boolean isLogUpToDate) {
        ResignedState state = this.newResignedState(Utils.mkSet((Object[])new Integer[]{1, 2, 3}), Collections.emptyList());
        Assertions.assertFalse((boolean)state.canGrantVote(1, isLogUpToDate));
        Assertions.assertFalse((boolean)state.canGrantVote(2, isLogUpToDate));
        Assertions.assertFalse((boolean)state.canGrantVote(3, isLogUpToDate));
    }

    @Test
    void testNegativeScenarioAcknowledgeResignation() {
        Set voters = Utils.mkSet((Object[])new Integer[]{0, 1, 2, 3, 4, 5});
        ResignedState state = this.newResignedState(voters, Collections.emptyList());
        Assertions.assertEquals((Object)ElectionState.withElectedLeader((int)this.epoch, (int)0, (Set)voters), (Object)state.election());
        Assertions.assertEquals((int)this.epoch, (int)state.epoch());
        Assertions.assertThrows(IllegalArgumentException.class, () -> state.acknowledgeResignation(10));
    }
}

