/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.util.OptionalInt;
import java.util.Random;
import java.util.function.IntFunction;

class MockableRandom
extends Random {
    private IntFunction<OptionalInt> nextIntFunction = __ -> OptionalInt.empty();

    public MockableRandom(long seed) {
        super(seed);
    }

    public void mockNextInt(int expectedBound, int returnValue) {
        this.nextIntFunction = b -> {
            if (b == expectedBound) {
                return OptionalInt.of(returnValue);
            }
            return OptionalInt.empty();
        };
    }

    public void mockNextInt(int returnValue) {
        this.nextIntFunction = __ -> OptionalInt.of(returnValue);
    }

    @Override
    public int nextInt(int bound) {
        return this.nextIntFunction.apply(bound).orElse(super.nextInt(bound));
    }
}

