/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.raft.NetworkChannel;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.raft.RaftRequest;
import org.apache.kafka.raft.RaftResponse;

public class MockNetworkChannel
implements NetworkChannel {
    private final AtomicInteger correlationIdCounter;
    private final Set<Integer> nodeCache;
    private final List<RaftRequest.Outbound> sendQueue = new ArrayList<RaftRequest.Outbound>();
    private final Map<Integer, RaftRequest.Outbound> awaitingResponse = new HashMap<Integer, RaftRequest.Outbound>();

    public MockNetworkChannel(AtomicInteger correlationIdCounter, Set<Integer> destinationIds) {
        this.correlationIdCounter = correlationIdCounter;
        this.nodeCache = destinationIds;
    }

    public MockNetworkChannel(Set<Integer> destinationIds) {
        this(new AtomicInteger(0), destinationIds);
    }

    public int newCorrelationId() {
        return this.correlationIdCounter.getAndIncrement();
    }

    public void send(RaftRequest.Outbound request) {
        if (!this.nodeCache.contains(request.destinationId())) {
            throw new IllegalArgumentException("Attempted to send to destination " + request.destinationId() + ", but its address is not yet known");
        }
        this.sendQueue.add(request);
    }

    public void updateEndpoint(int id, RaftConfig.InetAddressSpec address) {
    }

    public List<RaftRequest.Outbound> drainSendQueue() {
        return this.drainSentRequests(Optional.empty());
    }

    public List<RaftRequest.Outbound> drainSentRequests(Optional<ApiKeys> apiKeyFilter) {
        ArrayList<RaftRequest.Outbound> requests = new ArrayList<RaftRequest.Outbound>();
        Iterator<RaftRequest.Outbound> iterator = this.sendQueue.iterator();
        while (iterator.hasNext()) {
            RaftRequest.Outbound request = iterator.next();
            if (apiKeyFilter.isPresent() && request.data().apiKey() != apiKeyFilter.get().id) continue;
            this.awaitingResponse.put(request.correlationId, request);
            requests.add(request);
            iterator.remove();
        }
        return requests;
    }

    public boolean hasSentRequests() {
        return !this.sendQueue.isEmpty();
    }

    public void mockReceive(RaftResponse.Inbound response) {
        RaftRequest.Outbound request = this.awaitingResponse.get(response.correlationId);
        if (request == null) {
            throw new IllegalStateException("Received response for a request which is not being awaited");
        }
        request.completion.complete(response);
    }
}

