/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.util.ArrayDeque;
import java.util.OptionalLong;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.raft.RaftMessage;
import org.apache.kafka.raft.RaftMessageQueue;

public class MockMessageQueue
implements RaftMessageQueue {
    private final Queue<RaftMessage> messages = new ArrayDeque<RaftMessage>();
    private final AtomicBoolean wakeupRequested = new AtomicBoolean(false);
    private final AtomicLong lastPollTimeout = new AtomicLong(-1L);

    public RaftMessage poll(long timeoutMs) {
        this.wakeupRequested.set(false);
        this.lastPollTimeout.set(timeoutMs);
        return this.messages.poll();
    }

    public void add(RaftMessage message) {
        this.messages.offer(message);
    }

    public OptionalLong lastPollTimeoutMs() {
        long lastTimeoutMs = this.lastPollTimeout.get();
        if (lastTimeoutMs < 0L) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(lastTimeoutMs);
    }

    public boolean wakeupRequested() {
        return this.wakeupRequested.get();
    }

    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    public void wakeup() {
        this.wakeupRequested.set(true);
    }
}

