/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.raft.Isolation;
import org.apache.kafka.raft.LogAppendInfo;
import org.apache.kafka.raft.LogFetchInfo;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.OffsetMetadata;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.raft.ValidOffsetAndEpoch;
import org.apache.kafka.snapshot.MockRawSnapshotReader;
import org.apache.kafka.snapshot.MockRawSnapshotWriter;
import org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.slf4j.Logger;

public class MockLog
implements ReplicatedLog {
    private static final AtomicLong ID_GENERATOR = new AtomicLong();
    private final List<EpochStartOffset> epochStartOffsets = new ArrayList<EpochStartOffset>();
    private final List<LogBatch> batches = new ArrayList<LogBatch>();
    private final NavigableMap<OffsetAndEpoch, MockRawSnapshotReader> snapshots = new TreeMap<OffsetAndEpoch, MockRawSnapshotReader>();
    private final TopicPartition topicPartition;
    private final Uuid topicId;
    private final Logger logger;
    private long nextId = ID_GENERATOR.getAndIncrement();
    private LogOffsetMetadata highWatermark = new LogOffsetMetadata(0L, Optional.empty());
    private long firstUnflushedOffset = 0L;
    private boolean flushedSinceLastChecked = false;

    public MockLog(TopicPartition topicPartition, Uuid topicId, LogContext logContext) {
        this.topicPartition = topicPartition;
        this.topicId = topicId;
        this.logger = logContext.logger(MockLog.class);
    }

    public void truncateTo(long offset) {
        if (offset < this.highWatermark.offset) {
            throw new IllegalArgumentException("Illegal attempt to truncate to offset " + offset + " which is below the current high watermark " + this.highWatermark);
        }
        this.logger.debug("Truncating log to end offset {}", (Object)offset);
        this.batches.removeIf(entry -> entry.lastOffset() >= offset);
        this.epochStartOffsets.removeIf(epochStartOffset -> epochStartOffset.startOffset >= offset);
        this.firstUnflushedOffset = Math.min(this.firstUnflushedOffset, this.endOffset().offset);
    }

    public boolean truncateToLatestSnapshot() {
        AtomicBoolean truncated = new AtomicBoolean(false);
        this.latestSnapshotId().ifPresent(snapshotId -> {
            if (snapshotId.epoch() > this.logLastFetchedEpoch().orElse(0) || snapshotId.epoch() == this.logLastFetchedEpoch().orElse(0) && snapshotId.offset() > this.endOffset().offset) {
                this.logger.debug("Truncating to the latest snapshot at {}", snapshotId);
                this.batches.clear();
                this.epochStartOffsets.clear();
                this.snapshots.headMap((OffsetAndEpoch)snapshotId, false).clear();
                this.updateHighWatermark(new LogOffsetMetadata(snapshotId.offset()));
                this.flush(false);
                truncated.set(true);
            }
        });
        return truncated.get();
    }

    public void updateHighWatermark(LogOffsetMetadata offsetMetadata) {
        if (this.highWatermark.offset > offsetMetadata.offset) {
            throw new IllegalArgumentException("Non-monotonic update of current high watermark " + this.highWatermark + " to new value " + offsetMetadata);
        }
        if (offsetMetadata.offset > this.endOffset().offset) {
            throw new IllegalArgumentException("Attempt to update high watermark to " + offsetMetadata + " which is larger than the current end offset " + this.endOffset());
        }
        if (offsetMetadata.offset < this.startOffset()) {
            throw new IllegalArgumentException("Attempt to update high watermark to " + offsetMetadata + " which is smaller than the current start offset " + this.startOffset());
        }
        this.assertValidHighWatermarkMetadata(offsetMetadata);
        this.highWatermark = offsetMetadata;
    }

    public LogOffsetMetadata highWatermark() {
        return this.highWatermark;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Uuid topicId() {
        return this.topicId;
    }

    private Optional<OffsetMetadata> metadataForOffset(long offset) {
        if (offset == this.endOffset().offset) {
            return this.endOffset().metadata;
        }
        for (LogBatch batch : this.batches) {
            if (batch.lastOffset() < offset) continue;
            for (LogEntry entry : batch.entries) {
                if (entry.offset != offset) continue;
                return Optional.of(entry.metadata);
            }
        }
        return Optional.empty();
    }

    private void assertValidHighWatermarkMetadata(LogOffsetMetadata offsetMetadata) {
        if (!offsetMetadata.metadata.isPresent()) {
            return;
        }
        long id = ((MockOffsetMetadata)offsetMetadata.metadata.get()).id;
        long offset = offsetMetadata.offset;
        this.metadataForOffset(offset).ifPresent(metadata -> {
            long entryId = ((MockOffsetMetadata)metadata).id;
            if (entryId != id) {
                throw new IllegalArgumentException("High watermark " + offset + " metadata uuid " + id + " does not match the  log's record entry maintained uuid " + entryId);
            }
        });
    }

    private OptionalInt logLastFetchedEpoch() {
        if (this.epochStartOffsets.isEmpty()) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(this.epochStartOffsets.get((int)(this.epochStartOffsets.size() - 1)).epoch);
    }

    public int lastFetchedEpoch() {
        return this.logLastFetchedEpoch().orElseGet(() -> this.latestSnapshotId().map(OffsetAndEpoch::epoch).orElse(0));
    }

    public OffsetAndEpoch endOffsetForEpoch(int epoch) {
        return this.lastOffsetAndEpochFiltered(epochStartOffset -> epochStartOffset.epoch <= epoch);
    }

    private OffsetAndEpoch lastOffsetAndEpochFiltered(Predicate<EpochStartOffset> predicate) {
        int epochLowerBound = this.earliestSnapshotId().map(OffsetAndEpoch::epoch).orElse(0);
        for (EpochStartOffset epochStartOffset : this.epochStartOffsets) {
            if (!predicate.test(epochStartOffset)) {
                return new OffsetAndEpoch(epochStartOffset.startOffset, epochLowerBound);
            }
            epochLowerBound = epochStartOffset.epoch;
        }
        return new OffsetAndEpoch(this.endOffset().offset, this.lastFetchedEpoch());
    }

    private Optional<LogEntry> lastEntry() {
        if (this.batches.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.batches.get(this.batches.size() - 1).last());
    }

    private Optional<LogEntry> firstEntry() {
        if (this.batches.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.batches.get(0).first());
    }

    public LogOffsetMetadata endOffset() {
        long nextOffset = this.lastEntry().map(entry -> entry.offset + 1L).orElse(this.latestSnapshotId().map(OffsetAndEpoch::offset).orElse(0L));
        return new LogOffsetMetadata(nextOffset, Optional.of(new MockOffsetMetadata(this.nextId)));
    }

    public long startOffset() {
        return this.firstEntry().map(entry -> entry.offset).orElse(this.earliestSnapshotId().map(OffsetAndEpoch::offset).orElse(0L));
    }

    private List<LogEntry> buildEntries(RecordBatch batch, Function<Record, Long> offsetSupplier) {
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        for (Record record : batch) {
            long offset = offsetSupplier.apply(record);
            long timestamp = record.timestamp();
            ByteBuffer key = this.copy(record.key());
            ByteBuffer value = this.copy(record.value());
            entries.add(this.buildEntry(offset, new SimpleRecord(timestamp, key, value)));
        }
        return entries;
    }

    private ByteBuffer copy(ByteBuffer nullableByteBuffer) {
        if (nullableByteBuffer == null) {
            return null;
        }
        byte[] array = Utils.toArray((ByteBuffer)nullableByteBuffer, (int)nullableByteBuffer.position(), (int)nullableByteBuffer.limit());
        return ByteBuffer.wrap(array);
    }

    private LogEntry buildEntry(Long offset, SimpleRecord record) {
        long id = this.nextId;
        this.nextId = ID_GENERATOR.getAndIncrement();
        return new LogEntry(new MockOffsetMetadata(id), offset, record);
    }

    public LogAppendInfo appendAsLeader(Records records, int epoch) {
        return this.append(records, OptionalInt.of(epoch));
    }

    private long appendBatch(LogBatch batch) {
        if (batch.epoch > this.lastFetchedEpoch()) {
            this.epochStartOffsets.add(new EpochStartOffset(batch.epoch, batch.firstOffset()));
        }
        this.batches.add(batch);
        return batch.firstOffset();
    }

    public LogAppendInfo appendAsFollower(Records records) {
        return this.append(records, OptionalInt.empty());
    }

    private LogAppendInfo append(Records records, OptionalInt epoch) {
        long baseOffset;
        if (records.sizeInBytes() == 0) {
            throw new IllegalArgumentException("Attempt to append an empty record set");
        }
        long lastOffset = baseOffset = this.endOffset().offset;
        for (RecordBatch batch : records.batches()) {
            if (batch.baseOffset() != this.endOffset().offset) {
                throw new RuntimeException(String.format("Illegal append at offset %s with current end offset of %s", batch.baseOffset(), this.endOffset().offset));
            }
            LogBatch logBatch = new LogBatch(epoch.orElseGet(() -> ((RecordBatch)batch).partitionLeaderEpoch()), batch.isControlBatch(), this.buildEntries(batch, Record::offset));
            if (this.logger.isDebugEnabled()) {
                String nodeState = "Follower";
                if (epoch.isPresent()) {
                    nodeState = "Leader";
                }
                this.logger.debug("{} appending to the log {}", (Object)nodeState, (Object)logBatch);
            }
            this.appendBatch(logBatch);
            lastOffset = logBatch.last().offset;
        }
        return new LogAppendInfo(baseOffset, lastOffset);
    }

    public void flush(boolean forceFlushActiveSegment) {
        this.flushedSinceLastChecked = true;
        this.firstUnflushedOffset = this.endOffset().offset;
    }

    public boolean maybeClean() {
        return false;
    }

    public long firstUnflushedOffset() {
        return this.firstUnflushedOffset;
    }

    public boolean flushedSinceLastChecked() {
        boolean oldValue = this.flushedSinceLastChecked;
        this.flushedSinceLastChecked = false;
        return oldValue;
    }

    public void reopen() {
        this.batches.removeIf(batch -> batch.firstOffset() >= this.firstUnflushedOffset);
        this.epochStartOffsets.removeIf(epochStartOffset -> epochStartOffset.startOffset >= this.firstUnflushedOffset);
        this.highWatermark = new LogOffsetMetadata(0L, Optional.empty());
    }

    public List<LogBatch> readBatches(long startOffset, OptionalLong maxOffsetOpt) {
        this.verifyOffsetInRange(startOffset);
        long maxOffset = maxOffsetOpt.orElse(this.endOffset().offset);
        if (startOffset == maxOffset) {
            return Collections.emptyList();
        }
        return this.batches.stream().filter(batch -> batch.lastOffset() >= startOffset && batch.lastOffset() < maxOffset).collect(Collectors.toList());
    }

    private void verifyOffsetInRange(long offset) {
        if (offset > this.endOffset().offset) {
            throw new OffsetOutOfRangeException("Requested offset " + offset + " is larger than then log end offset " + this.endOffset().offset);
        }
        if (offset < this.startOffset()) {
            throw new OffsetOutOfRangeException("Requested offset " + offset + " is smaller than then log start offset " + this.startOffset());
        }
    }

    public LogFetchInfo read(long startOffset, Isolation isolation) {
        long maxOffset;
        this.verifyOffsetInRange(startOffset);
        long l = maxOffset = isolation == Isolation.COMMITTED ? this.highWatermark.offset : this.endOffset().offset;
        if (startOffset >= maxOffset) {
            return new LogFetchInfo((Records)MemoryRecords.EMPTY, new LogOffsetMetadata(startOffset, this.metadataForOffset(startOffset)));
        }
        ByteBuffer buffer = ByteBuffer.allocate(512);
        int batchCount = 0;
        LogOffsetMetadata batchStartOffset = null;
        this.logger.debug("Looking for a batch that starts at {} and ends at {} for isolation {}", new Object[]{startOffset, maxOffset, isolation});
        for (LogBatch batch : this.batches) {
            if (batch.lastOffset() < startOffset || batch.lastOffset() >= maxOffset || batch.entries.isEmpty()) continue;
            buffer = batch.writeTo(buffer);
            if (batchStartOffset == null) {
                batchStartOffset = batch.entries.get(0).logOffsetMetadata();
            }
            if (++batchCount < 2) continue;
            break;
        }
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        if (batchStartOffset == null) {
            throw new RuntimeException("Expected to find at least one entry starting from offset " + startOffset + " but found none");
        }
        return new LogFetchInfo((Records)records, batchStartOffset);
    }

    public void initializeLeaderEpoch(int epoch) {
        long startOffset = this.endOffset().offset;
        this.epochStartOffsets.removeIf(epochStartOffset -> epochStartOffset.startOffset >= startOffset || epochStartOffset.epoch >= epoch);
        this.epochStartOffsets.add(new EpochStartOffset(epoch, startOffset));
    }

    public Optional<RawSnapshotWriter> createNewSnapshot(OffsetAndEpoch snapshotId) {
        if (snapshotId.offset() < this.startOffset()) {
            this.logger.info("Cannot create a snapshot with an id ({}) less than the log start offset ({})", (Object)snapshotId, (Object)this.startOffset());
            return Optional.empty();
        }
        long highWatermarkOffset = this.highWatermark().offset;
        if (snapshotId.offset() > highWatermarkOffset) {
            throw new IllegalArgumentException(String.format("Cannot create a snapshot with an id (%s) greater than the high-watermark (%s)", snapshotId, highWatermarkOffset));
        }
        ValidOffsetAndEpoch validOffsetAndEpoch = this.validateOffsetAndEpoch(snapshotId.offset(), snapshotId.epoch());
        if (validOffsetAndEpoch.kind() != ValidOffsetAndEpoch.Kind.VALID) {
            throw new IllegalArgumentException(String.format("Snapshot id (%s) is not valid according to the log: %s", snapshotId, validOffsetAndEpoch));
        }
        return this.storeSnapshot(snapshotId);
    }

    public Optional<RawSnapshotWriter> storeSnapshot(OffsetAndEpoch snapshotId) {
        if (this.snapshots.containsKey(snapshotId)) {
            return Optional.empty();
        }
        return Optional.of(new MockRawSnapshotWriter(snapshotId, buffer -> this.snapshots.putIfAbsent(snapshotId, new MockRawSnapshotReader(snapshotId, (ByteBuffer)buffer))));
    }

    public Optional<RawSnapshotReader> readSnapshot(OffsetAndEpoch snapshotId) {
        return Optional.ofNullable((RawSnapshotReader)this.snapshots.get(snapshotId));
    }

    public Optional<RawSnapshotReader> latestSnapshot() {
        return this.latestSnapshotId().flatMap(this::readSnapshot);
    }

    public Optional<OffsetAndEpoch> latestSnapshotId() {
        return Optional.ofNullable(this.snapshots.lastEntry()).map(Map.Entry::getKey);
    }

    public Optional<OffsetAndEpoch> earliestSnapshotId() {
        return Optional.ofNullable(this.snapshots.firstEntry()).map(Map.Entry::getKey);
    }

    public void onSnapshotFrozen(OffsetAndEpoch snapshotId) {
    }

    public boolean deleteBeforeSnapshot(OffsetAndEpoch snapshotId) {
        if (this.startOffset() > snapshotId.offset()) {
            throw new OffsetOutOfRangeException(String.format("New log start (%s) is less than the current log start offset (%s)", snapshotId, this.startOffset()));
        }
        if (this.highWatermark.offset < snapshotId.offset()) {
            throw new OffsetOutOfRangeException(String.format("New log start (%s) is greater than the high watermark (%s)", snapshotId, this.highWatermark.offset));
        }
        boolean updated = false;
        if (this.snapshots.containsKey(snapshotId)) {
            this.snapshots.headMap(snapshotId, false).clear();
            this.logger.debug("Deleting batches included in the snapshot {}", (Object)snapshotId);
            this.batches.removeIf(entry -> entry.lastOffset() < snapshotId.offset());
            AtomicReference last = new AtomicReference(Optional.empty());
            this.epochStartOffsets.removeIf(epochStartOffset -> {
                if (epochStartOffset.startOffset <= snapshotId.offset()) {
                    last.set(Optional.of(epochStartOffset));
                    return true;
                }
                return false;
            });
            last.get().ifPresent(epochStartOffset -> this.epochStartOffsets.add(0, new EpochStartOffset(epochStartOffset.epoch, snapshotId.offset())));
            updated = true;
        }
        return updated;
    }

    public String toString() {
        return String.format("MockLog(epochStartOffsets=%s, batches=%s, snapshots=%s, highWatermark=%s", this.epochStartOffsets, this.batches, this.snapshots, this.highWatermark);
    }

    private static class EpochStartOffset {
        final int epoch;
        final long startOffset;

        private EpochStartOffset(int epoch, long startOffset) {
            this.epoch = epoch;
            this.startOffset = startOffset;
        }

        public String toString() {
            return String.format("EpochStartOffset(epoch=%s, startOffset=%s)", this.epoch, this.startOffset);
        }
    }

    static class LogBatch {
        final List<LogEntry> entries;
        final int epoch;
        final boolean isControlBatch;

        LogBatch(int epoch, boolean isControlBatch, List<LogEntry> entries) {
            if (entries.isEmpty()) {
                throw new IllegalArgumentException("Empty batches are not supported");
            }
            this.entries = entries;
            this.epoch = epoch;
            this.isControlBatch = isControlBatch;
        }

        long firstOffset() {
            return this.first().offset;
        }

        LogEntry first() {
            return this.entries.get(0);
        }

        long lastOffset() {
            return this.last().offset;
        }

        LogEntry last() {
            return this.entries.get(this.entries.size() - 1);
        }

        ByteBuffer writeTo(ByteBuffer buffer) {
            LogEntry first = this.first();
            MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)first.offset, (long)first.record.timestamp(), (long)-1L, (short)-1, (int)-1, (boolean)false, (boolean)this.isControlBatch, (int)this.epoch);
            for (LogEntry entry : this.entries) {
                if (this.isControlBatch) {
                    builder.appendControlRecordWithOffset(entry.offset, entry.record);
                    continue;
                }
                builder.appendWithOffset(entry.offset, entry.record);
            }
            builder.close();
            return builder.buffer();
        }

        public String toString() {
            return String.format("LogBatch(entries=%s, epoch=%s, isControlBatch=%s)", this.entries, this.epoch, this.isControlBatch);
        }
    }

    static class LogEntry {
        final MockOffsetMetadata metadata;
        final long offset;
        final SimpleRecord record;

        LogEntry(MockOffsetMetadata metadata, long offset, SimpleRecord record) {
            this.metadata = metadata;
            this.offset = offset;
            this.record = record;
        }

        LogOffsetMetadata logOffsetMetadata() {
            return new LogOffsetMetadata(this.offset, Optional.of(this.metadata));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LogEntry logEntry = (LogEntry)o;
            return this.offset == logEntry.offset && Objects.equals(this.metadata, logEntry.metadata) && Objects.equals(this.record, logEntry.record);
        }

        public int hashCode() {
            return Objects.hash(this.metadata, this.offset, this.record);
        }

        public String toString() {
            return String.format("LogEntry(metadata=%s, offset=%s, record=%s)", this.metadata, this.offset, this.record);
        }
    }

    static class MockOffsetMetadata
    implements OffsetMetadata {
        final long id;

        MockOffsetMetadata(long id) {
            this.id = id;
        }

        public String toString() {
            return "MockOffsetMetadata(id=" + this.id + ')';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MockOffsetMetadata that = (MockOffsetMetadata)o;
            return this.id == that.id;
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }
}

