/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.util.PriorityQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.raft.ExpirationService;

public class MockExpirationService
implements ExpirationService,
MockTime.Listener {
    private final AtomicLong idGenerator = new AtomicLong(0L);
    private final MockTime time;
    private final PriorityQueue<ExpirationFuture<?>> queue = new PriorityQueue();

    public MockExpirationService(MockTime time) {
        this.time = time;
        time.addListener((MockTime.Listener)this);
    }

    public <T> CompletableFuture<T> failAfter(long timeoutMs) {
        long deadlineMs = this.time.milliseconds() + timeoutMs;
        long id = this.idGenerator.incrementAndGet();
        ExpirationFuture future = new ExpirationFuture(id, deadlineMs);
        this.queue.add(future);
        return future;
    }

    public void onTimeUpdated() {
        ExpirationFuture<?> future;
        long currentTimeMs = this.time.milliseconds();
        while ((future = this.queue.peek()) != null && ((ExpirationFuture)future).deadlineMs <= currentTimeMs) {
            ExpirationFuture<?> polled = this.queue.poll();
            polled.completeExceptionally((Throwable)new TimeoutException());
        }
    }

    private static class ExpirationFuture<T>
    extends CompletableFuture<T>
    implements Comparable<ExpirationFuture<?>> {
        private final long id;
        private final long deadlineMs;

        private ExpirationFuture(long id, long deadlineMs) {
            this.id = id;
            this.deadlineMs = deadlineMs;
        }

        @Override
        public int compareTo(ExpirationFuture<?> o) {
            int res = Long.compare(this.deadlineMs, o.deadlineMs);
            if (res != 0) {
                return res;
            }
            return Long.compare(this.id, o.id);
        }
    }
}

