/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.raft.CandidateState;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class CandidateStateTest {
    private final int localId = 0;
    private final int epoch = 5;
    private final MockTime time = new MockTime();
    private final int electionTimeoutMs = 5000;
    private final LogContext logContext = new LogContext();

    private CandidateState newCandidateState(Set<Integer> voters, Optional<LogOffsetMetadata> highWatermark) {
        return new CandidateState((Time)this.time, 0, 5, voters, highWatermark, 0, 5000, this.logContext);
    }

    @Test
    public void testSingleNodeQuorum() {
        CandidateState state = this.newCandidateState(Collections.singleton(0), Optional.empty());
        Assertions.assertTrue((boolean)state.isVoteGranted());
        Assertions.assertFalse((boolean)state.isVoteRejected());
        Assertions.assertEquals(Collections.emptySet(), (Object)state.unrecordedVoters());
    }

    @Test
    public void testTwoNodeQuorumVoteRejected() {
        int otherNodeId = 1;
        CandidateState state = this.newCandidateState(Utils.mkSet((Object[])new Integer[]{0, otherNodeId}), Optional.empty());
        Assertions.assertFalse((boolean)state.isVoteGranted());
        Assertions.assertFalse((boolean)state.isVoteRejected());
        Assertions.assertEquals(Collections.singleton(otherNodeId), (Object)state.unrecordedVoters());
        Assertions.assertTrue((boolean)state.recordRejectedVote(otherNodeId));
        Assertions.assertFalse((boolean)state.isVoteGranted());
        Assertions.assertTrue((boolean)state.isVoteRejected());
    }

    @Test
    public void testTwoNodeQuorumVoteGranted() {
        int otherNodeId = 1;
        CandidateState state = this.newCandidateState(Utils.mkSet((Object[])new Integer[]{0, otherNodeId}), Optional.empty());
        Assertions.assertFalse((boolean)state.isVoteGranted());
        Assertions.assertFalse((boolean)state.isVoteRejected());
        Assertions.assertEquals(Collections.singleton(otherNodeId), (Object)state.unrecordedVoters());
        Assertions.assertTrue((boolean)state.recordGrantedVote(otherNodeId));
        Assertions.assertEquals(Collections.emptySet(), (Object)state.unrecordedVoters());
        Assertions.assertFalse((boolean)state.isVoteRejected());
        Assertions.assertTrue((boolean)state.isVoteGranted());
    }

    @Test
    public void testThreeNodeQuorumVoteGranted() {
        int node1 = 1;
        int node2 = 2;
        CandidateState state = this.newCandidateState(Utils.mkSet((Object[])new Integer[]{0, node1, node2}), Optional.empty());
        Assertions.assertFalse((boolean)state.isVoteGranted());
        Assertions.assertFalse((boolean)state.isVoteRejected());
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new Integer[]{node1, node2}), (Object)state.unrecordedVoters());
        Assertions.assertTrue((boolean)state.recordGrantedVote(node1));
        Assertions.assertEquals(Collections.singleton(node2), (Object)state.unrecordedVoters());
        Assertions.assertTrue((boolean)state.isVoteGranted());
        Assertions.assertFalse((boolean)state.isVoteRejected());
        Assertions.assertTrue((boolean)state.recordRejectedVote(node2));
        Assertions.assertEquals(Collections.emptySet(), (Object)state.unrecordedVoters());
        Assertions.assertTrue((boolean)state.isVoteGranted());
        Assertions.assertFalse((boolean)state.isVoteRejected());
    }

    @Test
    public void testThreeNodeQuorumVoteRejected() {
        int node1 = 1;
        int node2 = 2;
        CandidateState state = this.newCandidateState(Utils.mkSet((Object[])new Integer[]{0, node1, node2}), Optional.empty());
        Assertions.assertFalse((boolean)state.isVoteGranted());
        Assertions.assertFalse((boolean)state.isVoteRejected());
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new Integer[]{node1, node2}), (Object)state.unrecordedVoters());
        Assertions.assertTrue((boolean)state.recordRejectedVote(node1));
        Assertions.assertEquals(Collections.singleton(node2), (Object)state.unrecordedVoters());
        Assertions.assertFalse((boolean)state.isVoteGranted());
        Assertions.assertFalse((boolean)state.isVoteRejected());
        Assertions.assertTrue((boolean)state.recordRejectedVote(node2));
        Assertions.assertEquals(Collections.emptySet(), (Object)state.unrecordedVoters());
        Assertions.assertFalse((boolean)state.isVoteGranted());
        Assertions.assertTrue((boolean)state.isVoteRejected());
    }

    @Test
    public void testCannotRejectVoteFromLocalId() {
        int otherNodeId = 1;
        CandidateState state = this.newCandidateState(Utils.mkSet((Object[])new Integer[]{0, otherNodeId}), Optional.empty());
        Assertions.assertThrows(IllegalArgumentException.class, () -> state.recordRejectedVote(0));
    }

    @Test
    public void testCannotChangeVoteGrantedToRejected() {
        int otherNodeId = 1;
        CandidateState state = this.newCandidateState(Utils.mkSet((Object[])new Integer[]{0, otherNodeId}), Optional.empty());
        Assertions.assertTrue((boolean)state.recordGrantedVote(otherNodeId));
        Assertions.assertThrows(IllegalArgumentException.class, () -> state.recordRejectedVote(otherNodeId));
        Assertions.assertTrue((boolean)state.isVoteGranted());
    }

    @Test
    public void testCannotChangeVoteRejectedToGranted() {
        int otherNodeId = 1;
        CandidateState state = this.newCandidateState(Utils.mkSet((Object[])new Integer[]{0, otherNodeId}), Optional.empty());
        Assertions.assertTrue((boolean)state.recordRejectedVote(otherNodeId));
        Assertions.assertThrows(IllegalArgumentException.class, () -> state.recordGrantedVote(otherNodeId));
        Assertions.assertTrue((boolean)state.isVoteRejected());
    }

    @Test
    public void testCannotGrantOrRejectNonVoters() {
        int nonVoterId = 1;
        CandidateState state = this.newCandidateState(Collections.singleton(0), Optional.empty());
        Assertions.assertThrows(IllegalArgumentException.class, () -> state.recordGrantedVote(nonVoterId));
        Assertions.assertThrows(IllegalArgumentException.class, () -> state.recordRejectedVote(nonVoterId));
    }

    @Test
    public void testIdempotentGrant() {
        int otherNodeId = 1;
        CandidateState state = this.newCandidateState(Utils.mkSet((Object[])new Integer[]{0, otherNodeId}), Optional.empty());
        Assertions.assertTrue((boolean)state.recordGrantedVote(otherNodeId));
        Assertions.assertFalse((boolean)state.recordGrantedVote(otherNodeId));
    }

    @Test
    public void testIdempotentReject() {
        int otherNodeId = 1;
        CandidateState state = this.newCandidateState(Utils.mkSet((Object[])new Integer[]{0, otherNodeId}), Optional.empty());
        Assertions.assertTrue((boolean)state.recordRejectedVote(otherNodeId));
        Assertions.assertFalse((boolean)state.recordRejectedVote(otherNodeId));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testGrantVote(boolean isLogUpToDate) {
        CandidateState state = this.newCandidateState(Utils.mkSet((Object[])new Integer[]{1, 2, 3}), Optional.empty());
        Assertions.assertFalse((boolean)state.canGrantVote(1, isLogUpToDate));
        Assertions.assertFalse((boolean)state.canGrantVote(2, isLogUpToDate));
        Assertions.assertFalse((boolean)state.canGrantVote(3, isLogUpToDate));
    }
}

