/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.node;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.node.MetadataLeafNode;
import org.apache.kafka.image.node.MetadataNode;
import org.apache.kafka.metadata.BrokerRegistration;

public class ClusterImageNode
implements MetadataNode {
    public static final String NAME = "cluster";
    private final ClusterImage image;

    public ClusterImageNode(ClusterImage image) {
        this.image = image;
    }

    @Override
    public Collection<String> childNames() {
        ArrayList<String> childNames = new ArrayList<String>();
        for (Integer brokerId : this.image.brokers().keySet()) {
            childNames.add(brokerId.toString());
        }
        return childNames;
    }

    @Override
    public MetadataNode child(String name) {
        try {
            Integer brokerId = Integer.valueOf(name);
            BrokerRegistration registration = this.image.brokers().get(brokerId);
            if (registration == null) {
                return null;
            }
            return new MetadataLeafNode(registration.toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

