/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.apache.kafka.metadata.Replicas;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class ReplicasTest {
    @Test
    public void testToList() {
        Assertions.assertEquals(Arrays.asList(1, 2, 3, 4), (Object)Replicas.toList((int[])new int[]{1, 2, 3, 4}));
        Assertions.assertEquals(Arrays.asList(new Object[0]), (Object)Replicas.toList((int[])Replicas.NONE));
        Assertions.assertEquals(Arrays.asList(2), (Object)Replicas.toList((int[])new int[]{2}));
    }

    @Test
    public void testToArray() {
        Assertions.assertArrayEquals((int[])new int[]{3, 2, 1}, (int[])Replicas.toArray(Arrays.asList(3, 2, 1)));
        Assertions.assertArrayEquals((int[])new int[0], (int[])Replicas.toArray(Arrays.asList(new Integer[0])));
        Assertions.assertArrayEquals((int[])new int[]{2}, (int[])Replicas.toArray(Arrays.asList(2)));
    }

    @Test
    public void testClone() {
        Assertions.assertArrayEquals((int[])new int[]{3, 2, 1}, (int[])Replicas.clone((int[])new int[]{3, 2, 1}));
        Assertions.assertArrayEquals((int[])new int[0], (int[])Replicas.clone((int[])new int[0]));
        Assertions.assertArrayEquals((int[])new int[]{2}, (int[])Replicas.clone((int[])new int[]{2}));
    }

    @Test
    public void testValidate() {
        Assertions.assertTrue((boolean)Replicas.validate((int[])new int[0]));
        Assertions.assertTrue((boolean)Replicas.validate((int[])new int[]{3}));
        Assertions.assertTrue((boolean)Replicas.validate((int[])new int[]{3, 1, 2, 6}));
        Assertions.assertFalse((boolean)Replicas.validate((int[])new int[]{3, 3}));
        Assertions.assertFalse((boolean)Replicas.validate((int[])new int[]{4, -1, 3}));
        Assertions.assertFalse((boolean)Replicas.validate((int[])new int[]{-1}));
        Assertions.assertFalse((boolean)Replicas.validate((int[])new int[]{3, 1, 2, 6, 1}));
        Assertions.assertTrue((boolean)Replicas.validate((int[])new int[]{1, 100}));
    }

    @Test
    public void testValidateIsr() {
        Assertions.assertTrue((boolean)Replicas.validateIsr((int[])new int[0], (int[])new int[0]));
        Assertions.assertTrue((boolean)Replicas.validateIsr((int[])new int[]{1, 2, 3}, (int[])new int[0]));
        Assertions.assertTrue((boolean)Replicas.validateIsr((int[])new int[]{1, 2, 3}, (int[])new int[]{1, 2, 3}));
        Assertions.assertTrue((boolean)Replicas.validateIsr((int[])new int[]{3, 1, 2}, (int[])new int[]{2, 1}));
        Assertions.assertFalse((boolean)Replicas.validateIsr((int[])new int[]{3, 1, 2}, (int[])new int[]{4, 1}));
        Assertions.assertFalse((boolean)Replicas.validateIsr((int[])new int[]{1, 2, 4}, (int[])new int[]{4, 4}));
    }

    @Test
    public void testContains() {
        Assertions.assertTrue((boolean)Replicas.contains((int[])new int[]{3, 0, 1}, (int)0));
        Assertions.assertFalse((boolean)Replicas.contains((int[])new int[0], (int)0));
        Assertions.assertTrue((boolean)Replicas.contains((int[])new int[]{1}, (int)1));
    }

    @Test
    public void testCopyWithout() {
        Assertions.assertArrayEquals((int[])new int[0], (int[])Replicas.copyWithout((int[])new int[0], (int)0));
        Assertions.assertArrayEquals((int[])new int[0], (int[])Replicas.copyWithout((int[])new int[]{1}, (int)1));
        Assertions.assertArrayEquals((int[])new int[]{1, 3}, (int[])Replicas.copyWithout((int[])new int[]{1, 2, 3}, (int)2));
        Assertions.assertArrayEquals((int[])new int[]{4, 1}, (int[])Replicas.copyWithout((int[])new int[]{4, 2, 2, 1}, (int)2));
    }

    @Test
    public void testCopyWithout2() {
        Assertions.assertArrayEquals((int[])new int[0], (int[])Replicas.copyWithout((int[])new int[0], (int[])new int[0]));
        Assertions.assertArrayEquals((int[])new int[0], (int[])Replicas.copyWithout((int[])new int[]{1}, (int[])new int[]{1}));
        Assertions.assertArrayEquals((int[])new int[]{1, 3}, (int[])Replicas.copyWithout((int[])new int[]{1, 2, 3}, (int[])new int[]{2, 4}));
        Assertions.assertArrayEquals((int[])new int[]{4}, (int[])Replicas.copyWithout((int[])new int[]{4, 2, 2, 1}, (int[])new int[]{2, 1}));
    }

    @Test
    public void testCopyWith() {
        Assertions.assertArrayEquals((int[])new int[]{-1}, (int[])Replicas.copyWith((int[])new int[0], (int)-1));
        Assertions.assertArrayEquals((int[])new int[]{1, 2, 3, 4}, (int[])Replicas.copyWith((int[])new int[]{1, 2, 3}, (int)4));
    }

    @Test
    public void testToSet() {
        Assertions.assertEquals(Collections.emptySet(), (Object)Replicas.toSet((int[])new int[0]));
        Assertions.assertEquals(new HashSet<Integer>(Arrays.asList(3, 1, 5)), (Object)Replicas.toSet((int[])new int[]{1, 3, 5}));
        Assertions.assertEquals(new HashSet<Integer>(Arrays.asList(1, 2, 10)), (Object)Replicas.toSet((int[])new int[]{1, 1, 2, 10, 10}));
    }

    @Test
    public void testContains2() {
        Assertions.assertTrue((boolean)Replicas.contains(Collections.emptyList(), (int[])Replicas.NONE));
        Assertions.assertFalse((boolean)Replicas.contains(Collections.emptyList(), (int[])new int[]{1}));
        Assertions.assertTrue((boolean)Replicas.contains(Arrays.asList(1, 2, 3), (int[])new int[]{3, 2, 1}));
        Assertions.assertTrue((boolean)Replicas.contains(Arrays.asList(1, 2, 3, 4), (int[])new int[]{3}));
        Assertions.assertTrue((boolean)Replicas.contains(Arrays.asList(1, 2, 3, 4), (int[])new int[]{3, 1}));
        Assertions.assertFalse((boolean)Replicas.contains(Arrays.asList(1, 2, 3, 4), (int[])new int[]{3, 1, 7}));
        Assertions.assertTrue((boolean)Replicas.contains(Arrays.asList(1, 2, 3, 4), (int[])new int[0]));
    }
}

