/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.DelegationTokenRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.metadata.DelegationTokenData;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class DelegationTokenDataTest {
    private static final List<String> UUID = Arrays.asList(Uuid.randomUuid().toString(), Uuid.randomUuid().toString(), Uuid.randomUuid().toString());
    private static final List<KafkaPrincipal> EMPTYRENEWERS = Arrays.asList(new KafkaPrincipal[0]);
    private static final List<TokenInformation> TOKENINFORMATION = Arrays.asList(new TokenInformation(UUID.get(0), new KafkaPrincipal("User", "alice"), new KafkaPrincipal("User", "alice"), EMPTYRENEWERS, 0L, 100L, 100L), new TokenInformation(UUID.get(1), new KafkaPrincipal("User", "alice"), new KafkaPrincipal("User", "alice"), EMPTYRENEWERS, 0L, 100L, 100L), new TokenInformation(UUID.get(2), new KafkaPrincipal("User", "fred"), new KafkaPrincipal("User", "alice"), EMPTYRENEWERS, 0L, 100L, 100L));
    private static final List<DelegationTokenData> DELEGATIONTOKENDATA = Arrays.asList(new DelegationTokenData(TOKENINFORMATION.get(0)), new DelegationTokenData(TOKENINFORMATION.get(1)), new DelegationTokenData(TOKENINFORMATION.get(2)));

    @Test
    public void testValues() {
        Assertions.assertEquals((Object)TOKENINFORMATION.get(0), (Object)DELEGATIONTOKENDATA.get(0).tokenInformation());
        Assertions.assertEquals((Object)TOKENINFORMATION.get(1), (Object)DELEGATIONTOKENDATA.get(1).tokenInformation());
        Assertions.assertEquals((Object)TOKENINFORMATION.get(2), (Object)DELEGATIONTOKENDATA.get(2).tokenInformation());
    }

    @Test
    public void testEquals() {
        Assertions.assertNotEquals((Object)DELEGATIONTOKENDATA.get(0), (Object)DELEGATIONTOKENDATA.get(1));
        Assertions.assertNotEquals((Object)DELEGATIONTOKENDATA.get(1), (Object)DELEGATIONTOKENDATA.get(0));
        Assertions.assertNotEquals((Object)DELEGATIONTOKENDATA.get(0), (Object)DELEGATIONTOKENDATA.get(2));
        Assertions.assertNotEquals((Object)DELEGATIONTOKENDATA.get(2), (Object)DELEGATIONTOKENDATA.get(0));
        Assertions.assertEquals((Object)DELEGATIONTOKENDATA.get(0), (Object)DELEGATIONTOKENDATA.get(0));
        Assertions.assertEquals((Object)DELEGATIONTOKENDATA.get(1), (Object)DELEGATIONTOKENDATA.get(1));
        Assertions.assertEquals((Object)DELEGATIONTOKENDATA.get(2), (Object)DELEGATIONTOKENDATA.get(2));
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"DelegationTokenData(tokenInformation=[hidden])", (Object)DELEGATIONTOKENDATA.get(0).toString());
    }

    @Test
    public void testFromRecordAndToRecord() {
        this.testRoundTrip(DELEGATIONTOKENDATA.get(0));
        this.testRoundTrip(DELEGATIONTOKENDATA.get(1));
        this.testRoundTrip(DELEGATIONTOKENDATA.get(2));
    }

    private void testRoundTrip(DelegationTokenData origDelegationTokenData) {
        ApiMessageAndVersion messageAndVersion = new ApiMessageAndVersion((ApiMessage)origDelegationTokenData.toRecord(), 0);
        DelegationTokenData newDelegationTokenData = DelegationTokenData.fromRecord((DelegationTokenRecord)((DelegationTokenRecord)messageAndVersion.message()));
        Assertions.assertEquals((Object)origDelegationTokenData, (Object)newDelegationTokenData);
        ApiMessageAndVersion messageAndVersion2 = new ApiMessageAndVersion((ApiMessage)newDelegationTokenData.toRecord(), 0);
        Assertions.assertEquals((Object)messageAndVersion, (Object)messageAndVersion2);
    }
}

