/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.publisher;

import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.server.common.Features;
import org.apache.kafka.server.common.MetadataVersion;

public class FeaturesPublisher
implements MetadataPublisher {
    private volatile Features features = Features.fromKRaftVersion((MetadataVersion)MetadataVersion.MINIMUM_KRAFT_VERSION);

    public Features features() {
        return this.features;
    }

    @Override
    public String name() {
        return "FeaturesPublisher";
    }

    @Override
    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        if (delta.featuresDelta() != null) {
            this.features = new Features(newImage.features().metadataVersion(), newImage.features().finalizedVersions(), newImage.provenance().lastContainedOffset(), true);
        }
    }
}

