/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.migration;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.image.AclsImage;
import org.apache.kafka.image.AclsImageTest;
import org.apache.kafka.image.ClientQuotasImage;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.ConfigurationsImage;
import org.apache.kafka.image.ConfigurationsImageTest;
import org.apache.kafka.image.DelegationTokenImage;
import org.apache.kafka.image.FeaturesImage;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.ProducerIdsImage;
import org.apache.kafka.image.ProducerIdsImageTest;
import org.apache.kafka.image.ScramImage;
import org.apache.kafka.image.TopicsImageTest;
import org.apache.kafka.metadata.migration.CapturingAclMigrationClient;
import org.apache.kafka.metadata.migration.CapturingConfigMigrationClient;
import org.apache.kafka.metadata.migration.CapturingMigrationClient;
import org.apache.kafka.metadata.migration.CapturingTopicMigrationClient;
import org.apache.kafka.metadata.migration.KRaftMigrationDriver;
import org.apache.kafka.metadata.migration.KRaftMigrationOperationConsumer;
import org.apache.kafka.metadata.migration.KRaftMigrationZkWriter;
import org.apache.kafka.metadata.migration.MigrationClient;
import org.apache.kafka.metadata.migration.TopicMigrationClient;
import org.apache.kafka.metadata.migration.ZkMigrationLeadershipState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class KRaftMigrationZkWriterTest {
    @Test
    public void testExtraneousZkPartitions() {
        CapturingTopicMigrationClient topicClient = new CapturingTopicMigrationClient(){

            @Override
            public void iterateTopics(EnumSet<TopicMigrationClient.TopicVisitorInterest> interests, TopicMigrationClient.TopicVisitor visitor) {
                HashMap<Integer, List<Integer>> assignments = new HashMap<Integer, List<Integer>>();
                assignments.put(0, Arrays.asList(2, 3, 4));
                assignments.put(1, Arrays.asList(3, 4, 5));
                assignments.put(2, Arrays.asList(2, 4, 5));
                assignments.put(3, Arrays.asList(1, 2, 3));
                visitor.visitTopic("foo", TopicsImageTest.FOO_UUID, assignments);
                IntStream.of(0, 2, 3).forEach(partitionId -> visitor.visitPartition(new TopicIdPartition(TopicsImageTest.FOO_UUID, new TopicPartition("foo", partitionId)), TopicsImageTest.IMAGE1.getPartition(TopicsImageTest.FOO_UUID, partitionId)));
            }
        };
        CapturingConfigMigrationClient configClient = new CapturingConfigMigrationClient();
        CapturingAclMigrationClient aclClient = new CapturingAclMigrationClient();
        CapturingMigrationClient migrationClient = CapturingMigrationClient.newBuilder().setBrokersInZk(0).setTopicMigrationClient(topicClient).setConfigMigrationClient(configClient).build();
        KRaftMigrationZkWriter writer = new KRaftMigrationZkWriter((MigrationClient)migrationClient);
        MetadataImage image = new MetadataImage(MetadataProvenance.EMPTY, FeaturesImage.EMPTY, ClusterImage.EMPTY, TopicsImageTest.IMAGE1, ConfigurationsImage.EMPTY, ClientQuotasImage.EMPTY, ProducerIdsImage.EMPTY, AclsImage.EMPTY, ScramImage.EMPTY, DelegationTokenImage.EMPTY);
        writer.handleSnapshot(image, (opType, opLog, operation) -> operation.apply(ZkMigrationLeadershipState.EMPTY));
        Assertions.assertEquals((int)topicClient.updatedTopics.get("foo").size(), (int)3);
        Assertions.assertEquals(topicClient.deletedTopicPartitions.get("foo"), Collections.singleton(3));
        Assertions.assertEquals(topicClient.updatedTopicPartitions.get("foo"), Collections.singleton(1));
    }

    @Test
    public void testReconcileSnapshotEmptyZk() {
        CapturingTopicMigrationClient topicClient = new CapturingTopicMigrationClient();
        CapturingConfigMigrationClient configClient = new CapturingConfigMigrationClient();
        CapturingAclMigrationClient aclClient = new CapturingAclMigrationClient();
        CapturingMigrationClient migrationClient = CapturingMigrationClient.newBuilder().setBrokersInZk(0).setTopicMigrationClient(topicClient).setConfigMigrationClient(configClient).setAclMigrationClient(aclClient).build();
        KRaftMigrationZkWriter writer = new KRaftMigrationZkWriter((MigrationClient)migrationClient);
        MetadataImage image = new MetadataImage(MetadataProvenance.EMPTY, FeaturesImage.EMPTY, ClusterImage.EMPTY, TopicsImageTest.IMAGE1, ConfigurationsImageTest.IMAGE1, ClientQuotasImage.EMPTY, ProducerIdsImageTest.IMAGE1, AclsImageTest.IMAGE1, ScramImage.EMPTY, DelegationTokenImage.EMPTY);
        HashMap opCounts = new HashMap();
        KRaftMigrationOperationConsumer consumer = KRaftMigrationDriver.countingOperationConsumer(opCounts, (logMsg, operation) -> operation.apply(ZkMigrationLeadershipState.EMPTY));
        writer.handleSnapshot(image, consumer);
        Assertions.assertEquals((int)2, (Integer)((Integer)opCounts.remove("CreateTopic")));
        Assertions.assertEquals((int)2, (Integer)((Integer)opCounts.remove("UpdateBrokerConfig")));
        Assertions.assertEquals((int)1, (Integer)((Integer)opCounts.remove("UpdateProducerId")));
        Assertions.assertEquals((int)4, (Integer)((Integer)opCounts.remove("UpdateAcl")));
        Assertions.assertEquals((int)0, (int)opCounts.size());
        Assertions.assertEquals((int)2, (int)topicClient.createdTopics.size());
        Assertions.assertTrue((boolean)topicClient.createdTopics.contains("foo"));
        Assertions.assertTrue((boolean)topicClient.createdTopics.contains("bar"));
        Assertions.assertEquals((Object)"bar", (Object)configClient.writtenConfigs.get(new ConfigResource(ConfigResource.Type.BROKER, "0")).get("foo"));
        Assertions.assertEquals((Object)"quux", (Object)configClient.writtenConfigs.get(new ConfigResource(ConfigResource.Type.BROKER, "0")).get("baz"));
        Assertions.assertEquals((Object)"foobaz", (Object)configClient.writtenConfigs.get(new ConfigResource(ConfigResource.Type.BROKER, "1")).get("foobar"));
        Assertions.assertEquals((int)4, (int)aclClient.updatedResources.size());
    }

    @Test
    public void testReconcileSnapshotTopics() {
        CapturingTopicMigrationClient topicClient = new CapturingTopicMigrationClient(){

            @Override
            public void iterateTopics(EnumSet<TopicMigrationClient.TopicVisitorInterest> interests, TopicMigrationClient.TopicVisitor visitor) {
                HashMap<Integer, List<Integer>> assignments = new HashMap<Integer, List<Integer>>();
                assignments.put(0, Arrays.asList(2, 3, 4));
                assignments.put(1, Arrays.asList(3, 4, 5));
                assignments.put(2, Arrays.asList(2, 4, 5));
                visitor.visitTopic("foo", TopicsImageTest.FOO_UUID, assignments);
            }
        };
        CapturingConfigMigrationClient configClient = new CapturingConfigMigrationClient();
        CapturingAclMigrationClient aclClient = new CapturingAclMigrationClient();
        CapturingMigrationClient migrationClient = CapturingMigrationClient.newBuilder().setBrokersInZk(0).setTopicMigrationClient(topicClient).setConfigMigrationClient(configClient).setAclMigrationClient(aclClient).build();
        KRaftMigrationZkWriter writer = new KRaftMigrationZkWriter((MigrationClient)migrationClient);
        MetadataImage image = new MetadataImage(MetadataProvenance.EMPTY, FeaturesImage.EMPTY, ClusterImage.EMPTY, TopicsImageTest.IMAGE1, ConfigurationsImage.EMPTY, ClientQuotasImage.EMPTY, ProducerIdsImage.EMPTY, AclsImage.EMPTY, ScramImage.EMPTY, DelegationTokenImage.EMPTY);
        HashMap opCounts = new HashMap();
        KRaftMigrationOperationConsumer consumer = KRaftMigrationDriver.countingOperationConsumer(opCounts, (logMsg, operation) -> operation.apply(ZkMigrationLeadershipState.EMPTY));
        writer.handleSnapshot(image, consumer);
        Assertions.assertEquals((int)1, (Integer)((Integer)opCounts.remove("CreateTopic")));
        Assertions.assertEquals((int)1, (Integer)((Integer)opCounts.remove("UpdatePartition")));
        Assertions.assertEquals((int)1, (Integer)((Integer)opCounts.remove("UpdateTopic")));
        Assertions.assertEquals((int)0, (int)opCounts.size());
        Assertions.assertEquals((Object)"bar", (Object)topicClient.createdTopics.get(0));
    }
}

