/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.common.metadata.UserScramCredentialRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.metadata.ScramCredentialData;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.util.MockRandom;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class ScramCredentialDataTest {
    static MockRandom random = new MockRandom();
    private static final List<ScramCredentialData> SCRAMCREDENTIALDATA = Arrays.asList(new ScramCredentialData(ScramCredentialDataTest.randomBuffer((Random)random, 1024), ScramCredentialDataTest.randomBuffer((Random)random, 1024), ScramCredentialDataTest.randomBuffer((Random)random, 1024), 4096), new ScramCredentialData(ScramCredentialDataTest.randomBuffer((Random)random, 1024), ScramCredentialDataTest.randomBuffer((Random)random, 1024), ScramCredentialDataTest.randomBuffer((Random)random, 1024), 8192), new ScramCredentialData(ScramCredentialDataTest.randomBuffer((Random)random, 1024), ScramCredentialDataTest.randomBuffer((Random)random, 1024), ScramCredentialDataTest.randomBuffer((Random)random, 1024), 10000));

    static byte[] randomBuffer(Random random, int length) {
        byte[] buf = new byte[length];
        random.nextBytes(buf);
        return buf;
    }

    @Test
    public void testValues() {
        Assertions.assertEquals((int)4096, (int)SCRAMCREDENTIALDATA.get(0).iterations());
        Assertions.assertEquals((int)8192, (int)SCRAMCREDENTIALDATA.get(1).iterations());
        Assertions.assertEquals((int)10000, (int)SCRAMCREDENTIALDATA.get(2).iterations());
    }

    @Test
    public void testEquals() {
        Assertions.assertNotEquals((Object)SCRAMCREDENTIALDATA.get(0), (Object)SCRAMCREDENTIALDATA.get(1));
        Assertions.assertNotEquals((Object)SCRAMCREDENTIALDATA.get(1), (Object)SCRAMCREDENTIALDATA.get(0));
        Assertions.assertNotEquals((Object)SCRAMCREDENTIALDATA.get(0), (Object)SCRAMCREDENTIALDATA.get(2));
        Assertions.assertNotEquals((Object)SCRAMCREDENTIALDATA.get(2), (Object)SCRAMCREDENTIALDATA.get(0));
        Assertions.assertEquals((Object)SCRAMCREDENTIALDATA.get(0), (Object)SCRAMCREDENTIALDATA.get(0));
        Assertions.assertEquals((Object)SCRAMCREDENTIALDATA.get(1), (Object)SCRAMCREDENTIALDATA.get(1));
        Assertions.assertEquals((Object)SCRAMCREDENTIALDATA.get(2), (Object)SCRAMCREDENTIALDATA.get(2));
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"ScramCredentialData(salt=[hidden], storedKey=[hidden], serverKey=[hidden], iterations=[hidden])", (Object)SCRAMCREDENTIALDATA.get(0).toString());
    }

    @Test
    public void testFromRecordAndToRecord() {
        this.testRoundTrip(SCRAMCREDENTIALDATA.get(0));
        this.testRoundTrip(SCRAMCREDENTIALDATA.get(1));
        this.testRoundTrip(SCRAMCREDENTIALDATA.get(2));
    }

    private void testRoundTrip(ScramCredentialData scramCredentialData) {
        ApiMessageAndVersion messageAndVersion = new ApiMessageAndVersion((ApiMessage)scramCredentialData.toRecord("alice", ScramMechanism.SCRAM_SHA_256), 0);
        ScramCredentialData scramCredentialData2 = ScramCredentialData.fromRecord((UserScramCredentialRecord)((UserScramCredentialRecord)messageAndVersion.message()));
        Assertions.assertEquals((Object)scramCredentialData, (Object)scramCredentialData2);
        ApiMessageAndVersion messageAndVersion2 = new ApiMessageAndVersion((ApiMessage)scramCredentialData2.toRecord("alice", ScramMechanism.SCRAM_SHA_256), 0);
        Assertions.assertEquals((Object)messageAndVersion, (Object)messageAndVersion2);
    }
}

