/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.common.metadata.DelegationTokenRecord;
import org.apache.kafka.common.metadata.RemoveDelegationTokenRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.image.DelegationTokenDelta;
import org.apache.kafka.image.DelegationTokenImage;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.image.writer.RecordListWriter;
import org.apache.kafka.metadata.DelegationTokenData;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class DelegationTokenImageTest {
    public static final DelegationTokenImage IMAGE1;
    public static final List<ApiMessageAndVersion> DELTA1_RECORDS;
    static final DelegationTokenDelta DELTA1;
    static final DelegationTokenImage IMAGE2;

    static DelegationTokenData randomDelegationTokenData(String tokenId, long expireTimestamp) {
        TokenInformation ti = new TokenInformation(tokenId, SecurityUtils.parseKafkaPrincipal((String)"User:fred"), SecurityUtils.parseKafkaPrincipal((String)"User:fred"), new ArrayList(), 0L, 1000L, expireTimestamp);
        return new DelegationTokenData(ti);
    }

    @Test
    public void testEmptyImageRoundTrip() throws Throwable {
        DelegationTokenImageTest.testToImage(DelegationTokenImage.EMPTY);
    }

    @Test
    public void testImage1RoundTrip() throws Throwable {
        DelegationTokenImageTest.testToImage(IMAGE1);
    }

    @Test
    public void testApplyDelta1() throws Throwable {
        Assertions.assertEquals((Object)IMAGE2, (Object)DELTA1.apply());
        List<ApiMessageAndVersion> records = DelegationTokenImageTest.getImageRecords(IMAGE1);
        records.addAll(DELTA1_RECORDS);
        DelegationTokenImageTest.testToImage(IMAGE2, records);
    }

    @Test
    public void testImage2RoundTrip() throws Throwable {
        DelegationTokenImageTest.testToImage(IMAGE2);
    }

    private static void testToImage(DelegationTokenImage image) {
        DelegationTokenImageTest.testToImage(image, Optional.empty());
    }

    private static void testToImage(DelegationTokenImage image, Optional<List<ApiMessageAndVersion>> fromRecords) {
        DelegationTokenImageTest.testToImage(image, fromRecords.orElseGet(() -> DelegationTokenImageTest.getImageRecords(image)));
    }

    private static void testToImage(DelegationTokenImage image, List<ApiMessageAndVersion> fromRecords) {
        new RecordTestUtils.TestThroughAllIntermediateImagesLeadingToFinalImageHelper<DelegationTokenDelta, DelegationTokenImage>(() -> DelegationTokenImage.EMPTY, DelegationTokenDelta::new).test(image, fromRecords);
    }

    private static List<ApiMessageAndVersion> getImageRecords(DelegationTokenImage image) {
        RecordListWriter writer = new RecordListWriter();
        image.write((ImageWriter)writer, new ImageWriterOptions.Builder().build());
        return writer.records();
    }

    @Test
    public void testEmptyWithInvalidIBP() {
        ImageWriterOptions imageWriterOptions = new ImageWriterOptions.Builder().setMetadataVersion(MetadataVersion.IBP_3_5_IV2).build();
        RecordListWriter writer = new RecordListWriter();
        DelegationTokenImage.EMPTY.write((ImageWriter)writer, imageWriterOptions);
    }

    @Test
    public void testImage1withInvalidIBP() {
        ImageWriterOptions imageWriterOptions = new ImageWriterOptions.Builder().setMetadataVersion(MetadataVersion.IBP_3_5_IV2).build();
        RecordListWriter writer = new RecordListWriter();
        try {
            IMAGE1.write((ImageWriter)writer, imageWriterOptions);
            Assertions.fail((String)"expected exception writing IMAGE with Delegation Token records for MetadataVersion.IBP_3_5_IV2");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        HashMap<String, DelegationTokenData> image1 = new HashMap<String, DelegationTokenData>();
        image1.put("somerandomuuid1", DelegationTokenImageTest.randomDelegationTokenData("somerandomuuid1", 100L));
        image1.put("somerandomuuid2", DelegationTokenImageTest.randomDelegationTokenData("somerandomuuid2", 100L));
        image1.put("somerandomuuid3", DelegationTokenImageTest.randomDelegationTokenData("somerandomuuid3", 100L));
        IMAGE1 = new DelegationTokenImage(image1);
        DELTA1_RECORDS = new ArrayList<ApiMessageAndVersion>();
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new DelegationTokenRecord().setOwner("User:fred").setRequester("User:fred").setIssueTimestamp(0L).setMaxTimestamp(1000L).setExpirationTimestamp(200L).setTokenId("somerandomuuid1"), 0));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new RemoveDelegationTokenRecord().setTokenId("somerandomuuid3"), 0));
        DELTA1 = new DelegationTokenDelta(IMAGE1);
        RecordTestUtils.replayAll(DELTA1, DELTA1_RECORDS);
        HashMap<String, DelegationTokenData> image2 = new HashMap<String, DelegationTokenData>();
        image2.put("somerandomuuid1", DelegationTokenImageTest.randomDelegationTokenData("somerandomuuid1", 200L));
        image2.put("somerandomuuid2", DelegationTokenImageTest.randomDelegationTokenData("somerandomuuid2", 100L));
        IMAGE2 = new DelegationTokenImage(image2);
    }
}

