/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.image.ConfigurationImage;
import org.apache.kafka.image.ConfigurationsDelta;
import org.apache.kafka.image.ConfigurationsImage;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.image.writer.RecordListWriter;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class ConfigurationsImageTest {
    public static final ConfigurationsImage IMAGE1;
    public static final List<ApiMessageAndVersion> DELTA1_RECORDS;
    static final ConfigurationsDelta DELTA1;
    static final ConfigurationsImage IMAGE2;

    @Test
    public void testEmptyImageRoundTrip() {
        ConfigurationsImageTest.testToImage(ConfigurationsImage.EMPTY);
    }

    @Test
    public void testImage1RoundTrip() {
        ConfigurationsImageTest.testToImage(IMAGE1);
    }

    @Test
    public void testApplyDelta1() {
        Assertions.assertEquals((Object)IMAGE2, (Object)DELTA1.apply());
        List<ApiMessageAndVersion> records = ConfigurationsImageTest.getImageRecords(IMAGE1);
        records.addAll(DELTA1_RECORDS);
        ConfigurationsImageTest.testToImage(IMAGE2, records);
    }

    @Test
    public void testImage2RoundTrip() {
        ConfigurationsImageTest.testToImage(IMAGE2);
    }

    private static void testToImage(ConfigurationsImage image) {
        ConfigurationsImageTest.testToImage(image, Optional.empty());
    }

    private static void testToImage(ConfigurationsImage image, Optional<List<ApiMessageAndVersion>> fromRecords) {
        ConfigurationsImageTest.testToImage(image, fromRecords.orElseGet(() -> ConfigurationsImageTest.getImageRecords(image)));
    }

    private static void testToImage(ConfigurationsImage image, List<ApiMessageAndVersion> fromRecords) {
        new RecordTestUtils.TestThroughAllIntermediateImagesLeadingToFinalImageHelper<ConfigurationsDelta, ConfigurationsImage>(() -> ConfigurationsImage.EMPTY, ConfigurationsDelta::new).test(image, fromRecords);
    }

    private static List<ApiMessageAndVersion> getImageRecords(ConfigurationsImage image) {
        RecordListWriter writer = new RecordListWriter();
        image.write((ImageWriter)writer, new ImageWriterOptions.Builder().build());
        return writer.records();
    }

    static {
        HashMap<ConfigResource, ConfigurationImage> map1 = new HashMap<ConfigResource, ConfigurationImage>();
        HashMap<String, String> broker0Map = new HashMap<String, String>();
        broker0Map.put("foo", "bar");
        broker0Map.put("baz", "quux");
        map1.put(new ConfigResource(ConfigResource.Type.BROKER, "0"), new ConfigurationImage(new ConfigResource(ConfigResource.Type.BROKER, "0"), broker0Map));
        HashMap<String, String> broker1Map = new HashMap<String, String>();
        broker1Map.put("foobar", "foobaz");
        map1.put(new ConfigResource(ConfigResource.Type.BROKER, "1"), new ConfigurationImage(new ConfigResource(ConfigResource.Type.BROKER, "1"), broker1Map));
        IMAGE1 = new ConfigurationsImage(map1);
        DELTA1_RECORDS = new ArrayList<ApiMessageAndVersion>();
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("0").setName("foo").setValue(null), MetadataRecordType.CONFIG_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("1").setName("barfoo").setValue("bazfoo"), MetadataRecordType.CONFIG_RECORD.highestSupportedVersion()));
        DELTA1 = new ConfigurationsDelta(IMAGE1);
        RecordTestUtils.replayAll(DELTA1, DELTA1_RECORDS);
        HashMap<ConfigResource, ConfigurationImage> map2 = new HashMap<ConfigResource, ConfigurationImage>();
        HashMap<String, String> broker0Map2 = new HashMap<String, String>();
        broker0Map2.put("baz", "quux");
        map2.put(new ConfigResource(ConfigResource.Type.BROKER, "0"), new ConfigurationImage(new ConfigResource(ConfigResource.Type.BROKER, "0"), broker0Map2));
        HashMap<String, String> broker1Map2 = new HashMap<String, String>();
        broker1Map2.put("foobar", "foobaz");
        broker1Map2.put("barfoo", "bazfoo");
        map2.put(new ConfigResource(ConfigResource.Type.BROKER, "1"), new ConfigurationImage(new ConfigResource(ConfigResource.Type.BROKER, "1"), broker1Map2));
        IMAGE2 = new ConfigurationsImage(map2);
    }
}

