/*
 * Decompiled with CFR 0.152.
 */
package kafka.examples;

import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kafka.examples.Consumer;
import kafka.examples.Producer;
import kafka.examples.Utils;

public class KafkaConsumerProducerDemo {
    public static final String TOPIC_NAME = "my-topic";
    public static final String GROUP_NAME = "my-group";

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                Utils.printHelp("This example takes 2 parameters (i.e. 10000 sync):%n- records: total number of records to send (required)%n- mode: pass 'sync' to send records synchronously (optional)", new Object[0]);
                return;
            }
            int numRecords = Integer.parseInt(args[0]);
            boolean isAsync = args.length == 1 || !args[1].trim().equalsIgnoreCase("sync");
            Utils.recreateTopics("localhost:9092", -1, TOPIC_NAME);
            CountDownLatch latch = new CountDownLatch(2);
            Producer producerThread = new Producer("producer", "localhost:9092", TOPIC_NAME, isAsync, null, false, numRecords, -1, latch);
            producerThread.start();
            Consumer consumerThread = new Consumer("consumer", "localhost:9092", TOPIC_NAME, GROUP_NAME, Optional.empty(), false, numRecords, latch);
            consumerThread.start();
            if (!latch.await(5L, TimeUnit.MINUTES)) {
                Utils.printErr("Timeout after 5 minutes waiting for termination", new Object[0]);
                producerThread.shutdown();
                consumerThread.shutdown();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

