/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.utils.Java;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=120L)
public class KafkaFutureTest {
    private void assertIsSuccessful(KafkaFuture<?> future) {
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertFalse((boolean)future.isCompletedExceptionally());
        Assertions.assertFalse((boolean)future.isCancelled());
    }

    private void assertIsFailed(KafkaFuture<?> future) {
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertFalse((boolean)future.isCancelled());
        Assertions.assertTrue((boolean)future.isCompletedExceptionally());
    }

    private void assertIsCancelled(KafkaFuture<?> future) {
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertTrue((boolean)future.isCancelled());
        Assertions.assertTrue((boolean)future.isCompletedExceptionally());
        Assertions.assertThrows(CancellationException.class, () -> future.getNow(null));
        Assertions.assertThrows(CancellationException.class, () -> future.get(0L, TimeUnit.MILLISECONDS));
    }

    private <T> void awaitAndAssertResult(KafkaFuture<T> future, T expectedResult, T alternativeValue) {
        Assertions.assertNotEquals(expectedResult, alternativeValue);
        try {
            Assertions.assertEquals(expectedResult, (Object)future.get(5L, TimeUnit.MINUTES));
        }
        catch (Exception e) {
            throw new AssertionError("Unexpected exception", e);
        }
        try {
            Assertions.assertEquals(expectedResult, (Object)future.get());
        }
        catch (Exception e) {
            throw new AssertionError("Unexpected exception", e);
        }
        try {
            Assertions.assertEquals(expectedResult, (Object)future.getNow(alternativeValue));
        }
        catch (Exception e) {
            throw new AssertionError("Unexpected exception", e);
        }
    }

    private Throwable awaitAndAssertFailure(KafkaFuture<?> future, Class<? extends Throwable> expectedException, String expectedMessage) {
        ExecutionException executionException = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> future.get(5L, TimeUnit.MINUTES));
        Assertions.assertEquals(expectedException, executionException.getCause().getClass());
        Assertions.assertEquals((Object)expectedMessage, (Object)executionException.getCause().getMessage());
        executionException = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> future.get());
        Assertions.assertEquals(expectedException, executionException.getCause().getClass());
        Assertions.assertEquals((Object)expectedMessage, (Object)executionException.getCause().getMessage());
        executionException = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> future.getNow(null));
        Assertions.assertEquals(expectedException, executionException.getCause().getClass());
        Assertions.assertEquals((Object)expectedMessage, (Object)executionException.getCause().getMessage());
        return executionException.getCause();
    }

    private void awaitAndAssertCancelled(KafkaFuture<?> future, String expectedMessage) {
        CancellationException cancellationException = (CancellationException)Assertions.assertThrows(CancellationException.class, () -> future.get(5L, TimeUnit.MINUTES));
        Assertions.assertEquals((Object)expectedMessage, (Object)cancellationException.getMessage());
        Assertions.assertEquals(CancellationException.class, cancellationException.getClass());
        cancellationException = (CancellationException)Assertions.assertThrows(CancellationException.class, () -> future.get());
        Assertions.assertEquals((Object)expectedMessage, (Object)cancellationException.getMessage());
        Assertions.assertEquals(CancellationException.class, cancellationException.getClass());
        cancellationException = (CancellationException)Assertions.assertThrows(CancellationException.class, () -> future.getNow(null));
        Assertions.assertEquals((Object)expectedMessage, (Object)cancellationException.getMessage());
        Assertions.assertEquals(CancellationException.class, cancellationException.getClass());
    }

    private Object invokeOrThrow(Method method, Object obj, Object ... args) throws Throwable {
        try {
            return method.invoke(obj, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    @Test
    public void testCompleteFutures() throws Exception {
        KafkaFutureImpl future123 = new KafkaFutureImpl();
        Assertions.assertTrue((boolean)future123.complete((Object)123));
        Assertions.assertFalse((boolean)future123.complete((Object)456));
        Assertions.assertFalse((boolean)future123.cancel(true));
        Assertions.assertEquals((Integer)123, (Integer)((Integer)future123.get()));
        this.assertIsSuccessful((KafkaFuture<?>)future123);
        KafkaFuture future456 = KafkaFuture.completedFuture((Object)456);
        Assertions.assertFalse((boolean)future456.complete((Object)789));
        Assertions.assertFalse((boolean)future456.cancel(true));
        Assertions.assertEquals((Integer)456, (Integer)((Integer)future456.get()));
        this.assertIsSuccessful(future456);
    }

    @Test
    public void testCompleteFuturesExceptionally() {
        KafkaFutureImpl futureFail = new KafkaFutureImpl();
        Assertions.assertTrue((boolean)futureFail.completeExceptionally((Throwable)new RuntimeException("We require more vespene gas")));
        this.assertIsFailed((KafkaFuture<?>)futureFail);
        Assertions.assertFalse((boolean)futureFail.completeExceptionally((Throwable)new RuntimeException("We require more minerals")));
        Assertions.assertFalse((boolean)futureFail.cancel(true));
        ExecutionException executionException = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> futureFail.get());
        Assertions.assertEquals(RuntimeException.class, executionException.getCause().getClass());
        Assertions.assertEquals((Object)"We require more vespene gas", (Object)executionException.getCause().getMessage());
        KafkaFutureImpl tricky1 = new KafkaFutureImpl();
        Assertions.assertTrue((boolean)tricky1.completeExceptionally((Throwable)new CompletionException(new CancellationException())));
        this.assertIsFailed((KafkaFuture<?>)tricky1);
        this.awaitAndAssertFailure((KafkaFuture<?>)tricky1, (Class<? extends Throwable>)CompletionException.class, "java.util.concurrent.CancellationException");
    }

    @Test
    public void testCompleteFuturesViaCancellation() {
        KafkaFutureImpl viaCancel = new KafkaFutureImpl();
        Assertions.assertTrue((boolean)viaCancel.cancel(true));
        this.assertIsCancelled((KafkaFuture<?>)viaCancel);
        this.awaitAndAssertCancelled((KafkaFuture<?>)viaCancel, null);
        KafkaFutureImpl viaCancellationException = new KafkaFutureImpl();
        Assertions.assertTrue((boolean)viaCancellationException.completeExceptionally((Throwable)new CancellationException("We require more vespene gas")));
        this.assertIsCancelled((KafkaFuture<?>)viaCancellationException);
        this.awaitAndAssertCancelled((KafkaFuture<?>)viaCancellationException, "We require more vespene gas");
    }

    @Test
    public void testToString() {
        KafkaFutureImpl success = new KafkaFutureImpl();
        Assertions.assertEquals((Object)"KafkaFuture{value=null,exception=null,done=false}", (Object)success.toString());
        success.complete((Object)12);
        Assertions.assertEquals((Object)"KafkaFuture{value=12,exception=null,done=true}", (Object)success.toString());
        KafkaFutureImpl failure = new KafkaFutureImpl();
        failure.completeExceptionally((Throwable)new RuntimeException("foo"));
        Assertions.assertEquals((Object)"KafkaFuture{value=null,exception=java.lang.RuntimeException: foo,done=true}", (Object)failure.toString());
        KafkaFutureImpl tricky1 = new KafkaFutureImpl();
        tricky1.completeExceptionally((Throwable)new CompletionException(new CancellationException()));
        Assertions.assertEquals((Object)"KafkaFuture{value=null,exception=java.util.concurrent.CompletionException: java.util.concurrent.CancellationException,done=true}", (Object)tricky1.toString());
        KafkaFutureImpl cancelled = new KafkaFutureImpl();
        cancelled.cancel(true);
        Assertions.assertEquals((Object)"KafkaFuture{value=null,exception=java.util.concurrent.CancellationException,done=true}", (Object)cancelled.toString());
    }

    @Test
    public void testCompletingFutures() throws Exception {
        KafkaFutureImpl future = new KafkaFutureImpl();
        CompleterThread<String> myThread = new CompleterThread<String>(future, "You must construct additional pylons.");
        this.assertIsNotCompleted((KafkaFutureImpl<String>)future);
        Assertions.assertEquals((Object)"I am ready", (Object)future.getNow((Object)"I am ready"));
        myThread.start();
        this.awaitAndAssertResult((KafkaFuture)future, (Object)"You must construct additional pylons.", (Object)"I am ready");
        this.assertIsSuccessful((KafkaFuture<?>)future);
        myThread.join();
        Assertions.assertNull((Object)myThread.testException);
    }

    @Test
    public void testCompletingFuturesExceptionally() throws Exception {
        KafkaFutureImpl future = new KafkaFutureImpl();
        CompleterThread<Object> myThread = new CompleterThread<Object>(future, null, new RuntimeException("Ultimate efficiency achieved."));
        this.assertIsNotCompleted((KafkaFutureImpl<String>)future);
        Assertions.assertEquals((Object)"I am ready", (Object)future.getNow((Object)"I am ready"));
        myThread.start();
        this.awaitAndAssertFailure((KafkaFuture<?>)future, (Class<? extends Throwable>)RuntimeException.class, "Ultimate efficiency achieved.");
        this.assertIsFailed((KafkaFuture<?>)future);
        myThread.join();
        Assertions.assertNull((Object)myThread.testException);
    }

    @Test
    public void testCompletingFuturesViaCancellation() throws Exception {
        KafkaFutureImpl future = new KafkaFutureImpl();
        CompleterThread<Object> myThread = new CompleterThread<Object>(future, null, new CancellationException("Ultimate efficiency achieved."));
        this.assertIsNotCompleted((KafkaFutureImpl<String>)future);
        Assertions.assertEquals((Object)"I am ready", (Object)future.getNow((Object)"I am ready"));
        myThread.start();
        this.awaitAndAssertCancelled((KafkaFuture<?>)future, "Ultimate efficiency achieved.");
        this.assertIsCancelled((KafkaFuture<?>)future);
        myThread.join();
        Assertions.assertNull((Object)myThread.testException);
    }

    private void assertIsNotCompleted(KafkaFutureImpl<String> future) {
        Assertions.assertFalse((boolean)future.isDone());
        Assertions.assertFalse((boolean)future.isCompletedExceptionally());
        Assertions.assertFalse((boolean)future.isCancelled());
    }

    @Test
    public void testThenApplyOnSucceededFuture() throws Exception {
        KafkaFutureImpl future = new KafkaFutureImpl();
        KafkaFuture doubledFuture = future.thenApply(integer -> 2 * integer);
        Assertions.assertFalse((boolean)doubledFuture.isDone());
        KafkaFuture tripledFuture = future.thenApply(integer -> 3 * integer);
        Assertions.assertFalse((boolean)tripledFuture.isDone());
        future.complete((Object)21);
        Assertions.assertEquals((Integer)21, (Integer)((Integer)future.getNow((Object)-1)));
        Assertions.assertEquals((Integer)42, (Integer)((Integer)doubledFuture.getNow((Object)-1)));
        Assertions.assertEquals((Integer)63, (Integer)((Integer)tripledFuture.getNow((Object)-1)));
        KafkaFuture quadrupledFuture = future.thenApply(integer -> 4 * integer);
        Assertions.assertEquals((Integer)84, (Integer)((Integer)quadrupledFuture.getNow((Object)-1)));
    }

    @Test
    public void testThenApplyOnFailedFuture() {
        KafkaFutureImpl future = new KafkaFutureImpl();
        KafkaFuture dependantFuture = future.thenApply(integer -> 2 * integer);
        future.completeExceptionally((Throwable)new RuntimeException("We require more vespene gas"));
        this.assertIsFailed((KafkaFuture<?>)future);
        this.assertIsFailed(dependantFuture);
        this.awaitAndAssertFailure((KafkaFuture<?>)future, (Class<? extends Throwable>)RuntimeException.class, "We require more vespene gas");
        this.awaitAndAssertFailure(dependantFuture, RuntimeException.class, "We require more vespene gas");
    }

    @Test
    public void testThenApplyOnFailedFutureTricky() {
        KafkaFutureImpl future = new KafkaFutureImpl();
        KafkaFuture dependantFuture = future.thenApply(integer -> 2 * integer);
        future.completeExceptionally((Throwable)new CompletionException(new RuntimeException("We require more vespene gas")));
        this.assertIsFailed((KafkaFuture<?>)future);
        this.assertIsFailed(dependantFuture);
        this.awaitAndAssertFailure((KafkaFuture<?>)future, (Class<? extends Throwable>)CompletionException.class, "java.lang.RuntimeException: We require more vespene gas");
        this.awaitAndAssertFailure(dependantFuture, CompletionException.class, "java.lang.RuntimeException: We require more vespene gas");
    }

    @Test
    public void testThenApplyOnFailedFutureTricky2() {
        KafkaFutureImpl future = new KafkaFutureImpl();
        KafkaFuture dependantFuture = future.thenApply(integer -> 2 * integer);
        future.completeExceptionally((Throwable)new CompletionException(new CancellationException()));
        this.assertIsFailed((KafkaFuture<?>)future);
        this.assertIsFailed(dependantFuture);
        this.awaitAndAssertFailure((KafkaFuture<?>)future, (Class<? extends Throwable>)CompletionException.class, "java.util.concurrent.CancellationException");
        this.awaitAndAssertFailure(dependantFuture, CompletionException.class, "java.util.concurrent.CancellationException");
    }

    @Test
    public void testThenApplyOnSucceededFutureAndFunctionThrows() {
        KafkaFutureImpl future = new KafkaFutureImpl();
        KafkaFuture dependantFuture = future.thenApply(integer -> {
            throw new RuntimeException("We require more vespene gas");
        });
        future.complete((Object)21);
        this.assertIsSuccessful((KafkaFuture<?>)future);
        this.assertIsFailed(dependantFuture);
        this.awaitAndAssertResult((KafkaFuture)future, 21, null);
        this.awaitAndAssertFailure(dependantFuture, RuntimeException.class, "We require more vespene gas");
    }

    @Test
    public void testThenApplyOnSucceededFutureAndFunctionThrowsCompletionException() {
        KafkaFutureImpl future = new KafkaFutureImpl();
        KafkaFuture dependantFuture = future.thenApply(integer -> {
            throw new CompletionException(new RuntimeException("We require more vespene gas"));
        });
        future.complete((Object)21);
        this.assertIsSuccessful((KafkaFuture<?>)future);
        this.assertIsFailed(dependantFuture);
        this.awaitAndAssertResult((KafkaFuture)future, 21, null);
        Throwable cause = this.awaitAndAssertFailure(dependantFuture, CompletionException.class, "java.lang.RuntimeException: We require more vespene gas");
        Assertions.assertTrue((boolean)(cause.getCause() instanceof RuntimeException));
        Assertions.assertEquals((Object)cause.getCause().getMessage(), (Object)"We require more vespene gas");
    }

    @Test
    public void testThenApplyOnFailedFutureFunctionNotCalled() {
        KafkaFutureImpl future = new KafkaFutureImpl();
        boolean[] ran = new boolean[]{false};
        KafkaFuture dependantFuture = future.thenApply(integer -> {
            ran[0] = true;
            return null;
        });
        future.completeExceptionally((Throwable)new RuntimeException("We require more minerals"));
        this.assertIsFailed((KafkaFuture<?>)future);
        this.assertIsFailed(dependantFuture);
        this.awaitAndAssertFailure((KafkaFuture<?>)future, (Class<? extends Throwable>)RuntimeException.class, "We require more minerals");
        this.awaitAndAssertFailure(dependantFuture, RuntimeException.class, "We require more minerals");
        Assertions.assertFalse((boolean)ran[0]);
    }

    @Test
    public void testThenApplyOnCancelledFuture() {
        KafkaFutureImpl future = new KafkaFutureImpl();
        KafkaFuture dependantFuture = future.thenApply(integer -> 2 * integer);
        future.cancel(true);
        this.assertIsCancelled((KafkaFuture<?>)future);
        this.assertIsCancelled(dependantFuture);
        this.awaitAndAssertCancelled((KafkaFuture<?>)future, null);
        this.awaitAndAssertCancelled(dependantFuture, null);
    }

    @Test
    public void testWhenCompleteOnSucceededFuture() throws Throwable {
        KafkaFutureImpl future = new KafkaFutureImpl();
        Throwable[] err = new Throwable[1];
        boolean[] ran = new boolean[]{false};
        KafkaFuture dependantFuture = future.whenComplete((integer, ex) -> {
            ran[0] = true;
            try {
                Assertions.assertEquals((Integer)21, (Integer)integer);
                if (ex != null) {
                    throw ex;
                }
            }
            catch (Throwable e) {
                err[0] = e;
            }
        });
        Assertions.assertFalse((boolean)dependantFuture.isDone());
        Assertions.assertTrue((boolean)future.complete((Object)21));
        Assertions.assertTrue((boolean)ran[0]);
        if (err[0] != null) {
            throw err[0];
        }
    }

    @Test
    public void testWhenCompleteOnFailedFuture() {
        KafkaFutureImpl future = new KafkaFutureImpl();
        Throwable[] err = new Throwable[1];
        boolean[] ran = new boolean[]{false};
        KafkaFuture dependantFuture = future.whenComplete((integer, ex) -> {
            ran[0] = true;
            err[0] = ex;
            if (integer != null) {
                err[0] = new AssertionError();
            }
        });
        Assertions.assertFalse((boolean)dependantFuture.isDone());
        RuntimeException ex2 = new RuntimeException("We require more vespene gas");
        Assertions.assertTrue((boolean)future.completeExceptionally((Throwable)ex2));
        Assertions.assertTrue((boolean)ran[0]);
        Assertions.assertEquals((Object)err[0], (Object)ex2);
    }

    @Test
    public void testWhenCompleteOnSucceededFutureAndConsumerThrows() {
        KafkaFutureImpl future = new KafkaFutureImpl();
        boolean[] ran = new boolean[]{false};
        KafkaFuture dependantFuture = future.whenComplete((integer, ex) -> {
            ran[0] = true;
            throw new RuntimeException("We require more minerals");
        });
        Assertions.assertFalse((boolean)dependantFuture.isDone());
        Assertions.assertTrue((boolean)future.complete((Object)21));
        this.assertIsSuccessful((KafkaFuture<?>)future);
        Assertions.assertTrue((boolean)ran[0]);
        this.assertIsFailed(dependantFuture);
        this.awaitAndAssertFailure(dependantFuture, RuntimeException.class, "We require more minerals");
    }

    @Test
    public void testWhenCompleteOnFailedFutureAndConsumerThrows() {
        KafkaFutureImpl future = new KafkaFutureImpl();
        boolean[] ran = new boolean[]{false};
        KafkaFuture dependantFuture = future.whenComplete((integer, ex) -> {
            ran[0] = true;
            throw new RuntimeException("We require more minerals");
        });
        Assertions.assertFalse((boolean)dependantFuture.isDone());
        Assertions.assertTrue((boolean)future.completeExceptionally((Throwable)new RuntimeException("We require more vespene gas")));
        this.assertIsFailed((KafkaFuture<?>)future);
        Assertions.assertTrue((boolean)ran[0]);
        this.assertIsFailed(dependantFuture);
        this.awaitAndAssertFailure(dependantFuture, RuntimeException.class, "We require more vespene gas");
    }

    @Test
    public void testWhenCompleteOnCancelledFuture() {
        KafkaFutureImpl future = new KafkaFutureImpl();
        Throwable[] err = new Throwable[1];
        boolean[] ran = new boolean[]{false};
        KafkaFuture dependantFuture = future.whenComplete((integer, ex) -> {
            ran[0] = true;
            err[0] = ex;
            if (integer != null) {
                err[0] = new AssertionError();
            }
        });
        Assertions.assertFalse((boolean)dependantFuture.isDone());
        Assertions.assertTrue((boolean)future.cancel(true));
        Assertions.assertTrue((boolean)ran[0]);
        Assertions.assertTrue((boolean)(err[0] instanceof CancellationException));
    }

    @Test
    public void testAllOfFutures() throws Exception {
        int i;
        int numThreads = 5;
        ArrayList<KafkaFutureImpl> futures = new ArrayList<KafkaFutureImpl>();
        for (int i2 = 0; i2 < 5; ++i2) {
            futures.add(new KafkaFutureImpl());
        }
        KafkaFuture allFuture = KafkaFuture.allOf((KafkaFuture[])futures.toArray(new KafkaFuture[0]));
        ArrayList<CompleterThread<Integer>> completerThreads = new ArrayList<CompleterThread<Integer>>();
        ArrayList<WaiterThread<Integer>> waiterThreads = new ArrayList<WaiterThread<Integer>>();
        for (i = 0; i < 5; ++i) {
            completerThreads.add(new CompleterThread<Integer>((KafkaFutureImpl)futures.get(i), i));
            waiterThreads.add(new WaiterThread<Integer>((KafkaFutureImpl)futures.get(i), i));
        }
        Assertions.assertFalse((boolean)allFuture.isDone());
        for (i = 0; i < 5; ++i) {
            ((WaiterThread)waiterThreads.get(i)).start();
        }
        for (i = 0; i < 4; ++i) {
            ((CompleterThread)completerThreads.get(i)).start();
        }
        Assertions.assertFalse((boolean)allFuture.isDone());
        ((CompleterThread)completerThreads.get(4)).start();
        allFuture.get();
        this.assertIsSuccessful(allFuture);
        for (i = 0; i < 5; ++i) {
            Assertions.assertEquals((Integer)i, (Integer)((Integer)((KafkaFutureImpl)futures.get(i)).get()));
        }
        for (i = 0; i < 5; ++i) {
            ((CompleterThread)completerThreads.get(i)).join();
            ((WaiterThread)waiterThreads.get(i)).join();
            Assertions.assertNull((Object)((CompleterThread)completerThreads.get((int)i)).testException);
            Assertions.assertNull((Object)((WaiterThread)waiterThreads.get((int)i)).testException);
        }
    }

    @Test
    public void testAllOfFuturesWithFailure() throws Exception {
        int i;
        int numThreads = 5;
        ArrayList<KafkaFutureImpl> futures = new ArrayList<KafkaFutureImpl>();
        for (int i2 = 0; i2 < 5; ++i2) {
            futures.add(new KafkaFutureImpl());
        }
        KafkaFuture allFuture = KafkaFuture.allOf((KafkaFuture[])futures.toArray(new KafkaFuture[0]));
        ArrayList<CompleterThread<Integer>> completerThreads = new ArrayList<CompleterThread<Integer>>();
        ArrayList<WaiterThread<Integer>> waiterThreads = new ArrayList<WaiterThread<Integer>>();
        int lastIndex = 4;
        for (i = 0; i < lastIndex; ++i) {
            completerThreads.add(new CompleterThread<Integer>((KafkaFutureImpl)futures.get(i), i));
            waiterThreads.add(new WaiterThread<Integer>((KafkaFutureImpl)futures.get(i), i));
        }
        completerThreads.add(new CompleterThread<Object>((KafkaFutureImpl)futures.get(lastIndex), null, new RuntimeException("Last one failed")));
        waiterThreads.add(new WaiterThread<Integer>((KafkaFutureImpl)futures.get(lastIndex), lastIndex));
        Assertions.assertFalse((boolean)allFuture.isDone());
        for (i = 0; i < 5; ++i) {
            ((WaiterThread)waiterThreads.get(i)).start();
        }
        for (i = 0; i < lastIndex; ++i) {
            ((CompleterThread)completerThreads.get(i)).start();
        }
        Assertions.assertFalse((boolean)allFuture.isDone());
        ((CompleterThread)completerThreads.get(lastIndex)).start();
        this.awaitAndAssertFailure(allFuture, RuntimeException.class, "Last one failed");
        this.assertIsFailed(allFuture);
        for (i = 0; i < lastIndex; ++i) {
            Assertions.assertEquals((Integer)i, (Integer)((Integer)((KafkaFutureImpl)futures.get(i)).get()));
        }
        this.assertIsFailed((KafkaFuture)futures.get(lastIndex));
        for (i = 0; i < 5; ++i) {
            ((CompleterThread)completerThreads.get(i)).join();
            ((WaiterThread)waiterThreads.get(i)).join();
            Assertions.assertNull((Object)((CompleterThread)completerThreads.get((int)i)).testException);
            if (i == lastIndex) {
                Assertions.assertEquals(ExecutionException.class, ((WaiterThread)waiterThreads.get((int)i)).testException.getClass());
                Assertions.assertEquals(RuntimeException.class, ((WaiterThread)waiterThreads.get((int)i)).testException.getCause().getClass());
                Assertions.assertEquals((Object)"Last one failed", (Object)((WaiterThread)waiterThreads.get((int)i)).testException.getCause().getMessage());
                continue;
            }
            Assertions.assertNull((Object)((WaiterThread)waiterThreads.get((int)i)).testException);
        }
    }

    @Test
    public void testAllOfFuturesHandlesZeroFutures() throws Exception {
        KafkaFuture allFuture = KafkaFuture.allOf((KafkaFuture[])new KafkaFuture[0]);
        Assertions.assertTrue((boolean)allFuture.isDone());
        Assertions.assertFalse((boolean)allFuture.isCancelled());
        Assertions.assertFalse((boolean)allFuture.isCompletedExceptionally());
        allFuture.get();
    }

    @Test
    public void testFutureTimeoutWithZeroWait() {
        KafkaFutureImpl future = new KafkaFutureImpl();
        Assertions.assertThrows(TimeoutException.class, () -> future.get(0L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testLeakCompletableFuture() throws Throwable {
        KafkaFutureImpl kfut = new KafkaFutureImpl();
        CompletableFuture comfut = kfut.toCompletionStage().toCompletableFuture();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> comfut.complete(""));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> comfut.completeExceptionally(new RuntimeException()));
        if (Java.IS_JAVA9_COMPATIBLE) {
            Method completeOnTimeout = CompletableFuture.class.getDeclaredMethod("completeOnTimeout", Object.class, Long.TYPE, TimeUnit.class);
            Assertions.assertThrows(UnsupportedOperationException.class, () -> this.invokeOrThrow(completeOnTimeout, comfut, new Object[]{"", 1L, TimeUnit.MILLISECONDS}));
            Method completeAsync = CompletableFuture.class.getDeclaredMethod("completeAsync", Supplier.class);
            Assertions.assertThrows(UnsupportedOperationException.class, () -> this.invokeOrThrow(completeAsync, comfut, () -> ""));
            Method obtrudeValue = CompletableFuture.class.getDeclaredMethod("obtrudeValue", Object.class);
            Assertions.assertThrows(UnsupportedOperationException.class, () -> this.invokeOrThrow(obtrudeValue, comfut, ""));
            Method obtrudeException = CompletableFuture.class.getDeclaredMethod("obtrudeException", Throwable.class);
            Assertions.assertThrows(UnsupportedOperationException.class, () -> this.invokeOrThrow(obtrudeException, comfut, new RuntimeException()));
            Method minimal = CompletableFuture.class.getDeclaredMethod("minimalCompletionStage", new Class[0]);
            CompletionStage cs = (CompletionStage)this.invokeOrThrow(minimal, comfut, new Object[0]);
            cs.toCompletableFuture().complete("");
            Assertions.assertFalse((boolean)kfut.isDone());
            Assertions.assertFalse((boolean)comfut.isDone());
        }
    }

    private static class WaiterThread<T>
    extends Thread {
        private final KafkaFutureImpl<T> future;
        private final T expected;
        Throwable testException = null;

        WaiterThread(KafkaFutureImpl<T> future, T expected) {
            this.future = future;
            this.expected = expected;
        }

        @Override
        public void run() {
            try {
                Object value = this.future.get();
                Assertions.assertEquals(this.expected, (Object)value);
            }
            catch (Throwable testException) {
                this.testException = testException;
            }
        }
    }

    private static class CompleterThread<T>
    extends Thread {
        private final KafkaFutureImpl<T> future;
        private final T value;
        private final Throwable exception;
        Throwable testException = null;

        CompleterThread(KafkaFutureImpl<T> future, T value) {
            this.future = future;
            this.value = value;
            this.exception = null;
        }

        CompleterThread(KafkaFutureImpl<T> future, T value, Exception exception) {
            this.future = future;
            this.value = value;
            this.exception = exception;
        }

        @Override
        public void run() {
            try {
                try {
                    Thread.sleep(0L, 200);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.exception == null) {
                    this.future.complete(this.value);
                } else {
                    this.future.completeExceptionally(this.exception);
                }
            }
            catch (Throwable testException) {
                this.testException = testException;
            }
        }
    }
}

