/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.StickyAssignor;
import org.apache.kafka.clients.consumer.internals.AbstractPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.AbstractPartitionAssignorTest;
import org.apache.kafka.clients.consumer.internals.AbstractStickyAssignor;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.CollectionUtils;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.ValueSource;

public abstract class AbstractStickyAssignorTest {
    protected AbstractStickyAssignor assignor;
    protected String consumerId = "consumer";
    protected String consumer1 = "consumer1";
    protected String consumer2 = "consumer2";
    protected String consumer3 = "consumer3";
    protected String consumer4 = "consumer4";
    protected Map<String, ConsumerPartitionAssignor.Subscription> subscriptions;
    protected String topic = "topic";
    protected String topic1 = "topic1";
    protected String topic2 = "topic2";
    protected String topic3 = "topic3";
    protected TopicPartition tp0 = AbstractStickyAssignorTest.tp(this.topic, 0);
    protected TopicPartition tp1 = AbstractStickyAssignorTest.tp(this.topic, 1);
    protected TopicPartition tp2 = AbstractStickyAssignorTest.tp(this.topic, 2);
    protected String groupId = "group";
    protected int generationId = 1;
    protected int numBrokerRacks;
    protected boolean hasConsumerRack;
    protected int replicationFactor = 2;
    private int nextPartitionIndex;

    protected abstract AbstractStickyAssignor createAssignor();

    protected abstract ConsumerPartitionAssignor.Subscription buildSubscriptionV0(List<String> var1, List<TopicPartition> var2, int var3, int var4);

    protected abstract ConsumerPartitionAssignor.Subscription buildSubscriptionV1(List<String> var1, List<TopicPartition> var2, int var3, int var4);

    protected abstract ConsumerPartitionAssignor.Subscription buildSubscriptionV2Above(List<String> var1, List<TopicPartition> var2, int var3, int var4);

    protected abstract ByteBuffer generateUserData(List<String> var1, List<TopicPartition> var2, int var3);

    @BeforeEach
    public void setUp() {
        this.assignor = this.createAssignor();
        if (this.subscriptions != null) {
            this.subscriptions.clear();
        } else {
            this.subscriptions = new HashMap<String, ConsumerPartitionAssignor.Subscription>();
        }
    }

    @Test
    public void testMemberData() {
        List<String> topics = AbstractStickyAssignorTest.topics(this.topic);
        List<TopicPartition> ownedPartitions = AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic1, 0), AbstractStickyAssignorTest.tp(this.topic2, 1));
        ArrayList<ConsumerPartitionAssignor.Subscription> subscriptions = new ArrayList<ConsumerPartitionAssignor.Subscription>();
        subscriptions.add(this.buildSubscriptionV0(topics, ownedPartitions, this.generationId, 0));
        subscriptions.add(this.buildSubscriptionV1(topics, ownedPartitions, this.generationId, 1));
        subscriptions.add(this.buildSubscriptionV2Above(topics, ownedPartitions, this.generationId, 2));
        for (ConsumerPartitionAssignor.Subscription subscription : subscriptions) {
            if (subscription == null) continue;
            AbstractStickyAssignor.MemberData memberData = this.assignor.memberData(subscription);
            Assertions.assertEquals(ownedPartitions, (Object)memberData.partitions, (String)("subscription: " + subscription + " doesn't have expected owned partition"));
            Assertions.assertEquals((int)this.generationId, (Integer)memberData.generation.orElse(-1), (String)("subscription: " + subscription + " doesn't have expected generation id"));
        }
    }

    @ParameterizedTest(name="{displayName}.hasConsumerRack = {0}")
    @ValueSource(booleans={false, true})
    public void testOneConsumerNoTopic(boolean hasConsumerRack) {
        this.initializeRacks(hasConsumerRack ? AbstractPartitionAssignorTest.RackConfig.BROKER_AND_CONSUMER_RACK : AbstractPartitionAssignorTest.RackConfig.NO_CONSUMER_RACK);
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        this.subscriptions = Collections.singletonMap(this.consumerId, this.subscription(Collections.emptyList(), 0));
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals(Collections.singleton(this.consumerId), assignment.keySet());
        Assertions.assertTrue((boolean)((List)assignment.get(this.consumerId)).isEmpty());
        Assertions.assertTrue((boolean)this.assignor.partitionsTransferringOwnership.isEmpty());
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
    }

    @ParameterizedTest(name="{displayName}.hasConsumerRack = {0}")
    @ValueSource(booleans={false, true})
    public void testOneConsumerNonexistentTopic(boolean hasConsumerRack) {
        this.initializeRacks(hasConsumerRack ? AbstractPartitionAssignorTest.RackConfig.BROKER_AND_CONSUMER_RACK : AbstractPartitionAssignorTest.RackConfig.NO_CONSUMER_RACK);
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        partitionsPerTopic.put(this.topic, Collections.emptyList());
        this.subscriptions = Collections.singletonMap(this.consumerId, this.subscription(AbstractStickyAssignorTest.topics(this.topic), 0));
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals(Collections.singleton(this.consumerId), assignment.keySet());
        Assertions.assertTrue((boolean)((List)assignment.get(this.consumerId)).isEmpty());
        Assertions.assertTrue((boolean)this.assignor.partitionsTransferringOwnership.isEmpty());
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testOneConsumerOneTopic(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        this.initializeRacks(rackConfig);
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        partitionsPerTopic.put(this.topic, this.partitionInfos(this.topic, 3));
        this.subscriptions = Collections.singletonMap(this.consumerId, this.subscription(AbstractStickyAssignorTest.topics(this.topic), 0));
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 0), AbstractStickyAssignorTest.tp(this.topic, 1), AbstractStickyAssignorTest.tp(this.topic, 2)), assignment.get(this.consumerId));
        Assertions.assertTrue((boolean)this.assignor.partitionsTransferringOwnership.isEmpty());
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testOnlyAssignsPartitionsFromSubscribedTopics(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        String otherTopic = "other";
        this.initializeRacks(rackConfig);
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        partitionsPerTopic.put(this.topic, this.partitionInfos(this.topic, 2));
        this.subscriptions = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.consumerId, (Object)this.buildSubscriptionV2Above(AbstractStickyAssignorTest.topics(this.topic), Arrays.asList(AbstractStickyAssignorTest.tp(this.topic, 0), AbstractStickyAssignorTest.tp(this.topic, 1), AbstractStickyAssignorTest.tp(otherTopic, 0), AbstractStickyAssignorTest.tp(otherTopic, 1)), this.generationId, 0))});
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 0), AbstractStickyAssignorTest.tp(this.topic, 1)), assignment.get(this.consumerId));
        Assertions.assertTrue((boolean)this.assignor.partitionsTransferringOwnership.isEmpty());
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testOneConsumerMultipleTopics(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        this.initializeRacks(rackConfig);
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        partitionsPerTopic.put(this.topic1, this.partitionInfos(this.topic1, 1));
        partitionsPerTopic.put(this.topic2, this.partitionInfos(this.topic2, 2));
        this.subscriptions = Collections.singletonMap(this.consumerId, this.subscription(AbstractStickyAssignorTest.topics(this.topic1, this.topic2), 0));
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic1, 0), AbstractStickyAssignorTest.tp(this.topic2, 0), AbstractStickyAssignorTest.tp(this.topic2, 1)), assignment.get(this.consumerId));
        Assertions.assertTrue((boolean)this.assignor.partitionsTransferringOwnership.isEmpty());
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testTwoConsumersOneTopicOnePartition(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        this.initializeRacks(rackConfig);
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        partitionsPerTopic.put(this.topic, this.partitionInfos(this.topic, 1));
        this.subscriptions.put(this.consumer1, this.subscription(AbstractStickyAssignorTest.topics(this.topic), 0));
        this.subscriptions.put(this.consumer2, this.subscription(AbstractStickyAssignorTest.topics(this.topic), 1));
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        Assertions.assertTrue((boolean)this.assignor.partitionsTransferringOwnership.isEmpty());
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testTwoConsumersOneTopicTwoPartitions(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        this.initializeRacks(rackConfig);
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        partitionsPerTopic.put(this.topic, this.partitionInfos(this.topic, 2));
        this.subscriptions.put(this.consumer1, this.subscription(AbstractStickyAssignorTest.topics(this.topic), 0));
        this.subscriptions.put(this.consumer2, this.subscription(AbstractStickyAssignorTest.topics(this.topic), 1));
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 0)), assignment.get(this.consumer1));
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 1)), assignment.get(this.consumer2));
        Assertions.assertTrue((boolean)this.assignor.partitionsTransferringOwnership.isEmpty());
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testMultipleConsumersMixedTopicSubscriptions(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        this.initializeRacks(rackConfig);
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        partitionsPerTopic.put(this.topic1, this.partitionInfos(this.topic1, 3));
        partitionsPerTopic.put(this.topic2, this.partitionInfos(this.topic2, 2));
        this.subscriptions.put(this.consumer1, this.subscription(AbstractStickyAssignorTest.topics(this.topic1), 0));
        this.subscriptions.put(this.consumer2, this.subscription(AbstractStickyAssignorTest.topics(this.topic1, this.topic2), 1));
        this.subscriptions.put(this.consumer3, this.subscription(AbstractStickyAssignorTest.topics(this.topic1), 2));
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic1, 0), AbstractStickyAssignorTest.tp(this.topic1, 2)), assignment.get(this.consumer1));
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic2, 0), AbstractStickyAssignorTest.tp(this.topic2, 1)), assignment.get(this.consumer2));
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic1, 1)), assignment.get(this.consumer3));
        Assertions.assertNull((Object)this.assignor.partitionsTransferringOwnership);
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testTwoConsumersTwoTopicsSixPartitions(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        this.initializeRacks(rackConfig);
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        partitionsPerTopic.put(this.topic1, this.partitionInfos(this.topic1, 3));
        partitionsPerTopic.put(this.topic2, this.partitionInfos(this.topic2, 3));
        this.subscriptions.put(this.consumer1, this.subscription(AbstractStickyAssignorTest.topics(this.topic1, this.topic2), 0));
        this.subscriptions.put(this.consumer2, this.subscription(AbstractStickyAssignorTest.topics(this.topic1, this.topic2), 1));
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic1, 0), AbstractStickyAssignorTest.tp(this.topic1, 2), AbstractStickyAssignorTest.tp(this.topic2, 1)), assignment.get(this.consumer1));
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic1, 1), AbstractStickyAssignorTest.tp(this.topic2, 0), AbstractStickyAssignorTest.tp(this.topic2, 2)), assignment.get(this.consumer2));
        Assertions.assertTrue((boolean)this.assignor.partitionsTransferringOwnership.isEmpty());
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testConsumerOwningMinQuotaExpectedMaxQuota(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        this.initializeRacks(rackConfig);
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        partitionsPerTopic.put(this.topic1, this.partitionInfos(this.topic1, 2));
        partitionsPerTopic.put(this.topic2, this.partitionInfos(this.topic2, 3));
        List<String> subscribedTopics = AbstractStickyAssignorTest.topics(this.topic1, this.topic2);
        this.subscriptions.put(this.consumer1, this.buildSubscriptionV2Above(subscribedTopics, AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic1, 0), AbstractStickyAssignorTest.tp(this.topic2, 1)), this.generationId, 0));
        this.subscriptions.put(this.consumer2, this.buildSubscriptionV2Above(subscribedTopics, AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic1, 1), AbstractStickyAssignorTest.tp(this.topic2, 2)), this.generationId, 1));
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic1, 0), AbstractStickyAssignorTest.tp(this.topic2, 1), AbstractStickyAssignorTest.tp(this.topic2, 0)), assignment.get(this.consumer1));
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic1, 1), AbstractStickyAssignorTest.tp(this.topic2, 2)), assignment.get(this.consumer2));
        Assertions.assertTrue((boolean)this.assignor.partitionsTransferringOwnership.isEmpty());
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testMaxQuotaConsumerMoreThanNumExpectedMaxCapacityMembers(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        this.initializeRacks(rackConfig);
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        partitionsPerTopic.put(this.topic1, this.partitionInfos(this.topic1, 2));
        partitionsPerTopic.put(this.topic2, this.partitionInfos(this.topic2, 2));
        List<String> subscribedTopics = AbstractStickyAssignorTest.topics(this.topic1, this.topic2);
        this.subscriptions.put(this.consumer1, this.buildSubscriptionV2Above(subscribedTopics, AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic1, 0), AbstractStickyAssignorTest.tp(this.topic2, 0)), this.generationId, 0));
        this.subscriptions.put(this.consumer2, this.buildSubscriptionV2Above(subscribedTopics, AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic1, 1), AbstractStickyAssignorTest.tp(this.topic2, 1)), this.generationId, 1));
        this.subscriptions.put(this.consumer3, this.buildSubscriptionV2Above(subscribedTopics, Collections.emptyList(), this.generationId, 2));
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals(Collections.singletonMap(AbstractStickyAssignorTest.tp(this.topic2, 0), this.consumer3), (Object)this.assignor.partitionsTransferringOwnership);
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic1, 0)), assignment.get(this.consumer1));
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic1, 1), AbstractStickyAssignorTest.tp(this.topic2, 1)), assignment.get(this.consumer2));
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic2, 0)), assignment.get(this.consumer3));
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testAllConsumersAreUnderMinQuota(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        this.initializeRacks(rackConfig);
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        partitionsPerTopic.put(this.topic1, this.partitionInfos(this.topic1, 2));
        partitionsPerTopic.put(this.topic2, this.partitionInfos(this.topic2, 3));
        List<String> subscribedTopics = AbstractStickyAssignorTest.topics(this.topic1, this.topic2);
        this.subscriptions.put(this.consumer1, this.buildSubscriptionV2Above(subscribedTopics, AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic1, 0)), this.generationId, 0));
        this.subscriptions.put(this.consumer2, this.buildSubscriptionV2Above(subscribedTopics, AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic1, 1)), this.generationId, 1));
        this.subscriptions.put(this.consumer3, this.buildSubscriptionV2Above(subscribedTopics, Collections.emptyList(), this.generationId, 2));
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        Assertions.assertTrue((boolean)this.assignor.partitionsTransferringOwnership.isEmpty());
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic1, 0), AbstractStickyAssignorTest.tp(this.topic2, 1)), assignment.get(this.consumer1));
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic1, 1), AbstractStickyAssignorTest.tp(this.topic2, 2)), assignment.get(this.consumer2));
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic2, 0)), assignment.get(this.consumer3));
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testAddRemoveConsumerOneTopic(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        this.initializeRacks(rackConfig);
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        partitionsPerTopic.put(this.topic, this.partitionInfos(this.topic, 3));
        this.subscriptions.put(this.consumer1, this.subscription(AbstractStickyAssignorTest.topics(this.topic), 0));
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 0), AbstractStickyAssignorTest.tp(this.topic, 1), AbstractStickyAssignorTest.tp(this.topic, 2)), assignment.get(this.consumer1));
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
        this.subscriptions.put(this.consumer1, this.buildSubscriptionV2Above(AbstractStickyAssignorTest.topics(this.topic), (List)assignment.get(this.consumer1), this.generationId, 0));
        this.subscriptions.put(this.consumer2, this.buildSubscriptionV2Above(AbstractStickyAssignorTest.topics(this.topic), Collections.emptyList(), this.generationId, 1));
        assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals(Collections.singletonMap(AbstractStickyAssignorTest.tp(this.topic, 2), this.consumer2), (Object)this.assignor.partitionsTransferringOwnership);
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 0), AbstractStickyAssignorTest.tp(this.topic, 1)), assignment.get(this.consumer1));
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 2)), assignment.get(this.consumer2));
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
        this.subscriptions.remove(this.consumer1);
        this.subscriptions.put(this.consumer2, this.buildSubscriptionV2Above(AbstractStickyAssignorTest.topics(this.topic), (List)assignment.get(this.consumer2), this.generationId, 1));
        assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals(new HashSet<TopicPartition>(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 2), AbstractStickyAssignorTest.tp(this.topic, 1), AbstractStickyAssignorTest.tp(this.topic, 0))), new HashSet((Collection)assignment.get(this.consumer2)));
        Assertions.assertTrue((boolean)this.assignor.partitionsTransferringOwnership.isEmpty());
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testAddRemoveTwoConsumersTwoTopics(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        this.initializeRacks(rackConfig);
        List<String> allTopics = AbstractStickyAssignorTest.topics(this.topic1, this.topic2);
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        partitionsPerTopic.put(this.topic1, this.partitionInfos(this.topic1, 3));
        partitionsPerTopic.put(this.topic2, this.partitionInfos(this.topic2, 4));
        this.subscriptions.put(this.consumer1, this.subscription(allTopics, 0));
        this.subscriptions.put(this.consumer2, this.subscription(allTopics, 1));
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic1, 0), AbstractStickyAssignorTest.tp(this.topic1, 2), AbstractStickyAssignorTest.tp(this.topic2, 1), AbstractStickyAssignorTest.tp(this.topic2, 3)), assignment.get(this.consumer1));
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic1, 1), AbstractStickyAssignorTest.tp(this.topic2, 0), AbstractStickyAssignorTest.tp(this.topic2, 2)), assignment.get(this.consumer2));
        Assertions.assertTrue((boolean)this.assignor.partitionsTransferringOwnership.isEmpty());
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
        this.subscriptions.put(this.consumer1, this.buildSubscriptionV2Above(allTopics, (List)assignment.get(this.consumer1), this.generationId, 0));
        this.subscriptions.put(this.consumer2, this.buildSubscriptionV2Above(allTopics, (List)assignment.get(this.consumer2), this.generationId, 1));
        this.subscriptions.put(this.consumer3, this.buildSubscriptionV2Above(allTopics, Collections.emptyList(), this.generationId, 2));
        this.subscriptions.put(this.consumer4, this.buildSubscriptionV2Above(allTopics, Collections.emptyList(), this.generationId, 3));
        assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        HashMap<TopicPartition, String> expectedPartitionsTransferringOwnership = new HashMap<TopicPartition, String>();
        expectedPartitionsTransferringOwnership.put(AbstractStickyAssignorTest.tp(this.topic2, 1), this.consumer3);
        expectedPartitionsTransferringOwnership.put(AbstractStickyAssignorTest.tp(this.topic2, 3), this.consumer3);
        expectedPartitionsTransferringOwnership.put(AbstractStickyAssignorTest.tp(this.topic2, 2), this.consumer4);
        Assertions.assertEquals(expectedPartitionsTransferringOwnership, (Object)this.assignor.partitionsTransferringOwnership);
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic1, 0), AbstractStickyAssignorTest.tp(this.topic1, 2)), assignment.get(this.consumer1));
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic1, 1), AbstractStickyAssignorTest.tp(this.topic2, 0)), assignment.get(this.consumer2));
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic2, 1), AbstractStickyAssignorTest.tp(this.topic2, 3)), assignment.get(this.consumer3));
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic2, 2)), assignment.get(this.consumer4));
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
        this.subscriptions.remove(this.consumer1);
        this.subscriptions.remove(this.consumer2);
        this.subscriptions.put(this.consumer3, this.buildSubscriptionV2Above(allTopics, (List)assignment.get(this.consumer3), this.generationId, 2));
        this.subscriptions.put(this.consumer4, this.buildSubscriptionV2Above(allTopics, (List)assignment.get(this.consumer4), this.generationId, 3));
        assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic2, 1), AbstractStickyAssignorTest.tp(this.topic2, 3), AbstractStickyAssignorTest.tp(this.topic1, 0), AbstractStickyAssignorTest.tp(this.topic2, 0)), assignment.get(this.consumer3));
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic2, 2), AbstractStickyAssignorTest.tp(this.topic1, 1), AbstractStickyAssignorTest.tp(this.topic1, 2)), assignment.get(this.consumer4));
        Assertions.assertTrue((boolean)this.assignor.partitionsTransferringOwnership.isEmpty());
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testPoorRoundRobinAssignmentScenario(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        this.initializeRacks(rackConfig);
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        for (int i = 1; i <= 5; ++i) {
            String topicName = String.format("topic%d", i);
            partitionsPerTopic.put(topicName, this.partitionInfos(topicName, i % 2 + 1));
        }
        this.subscriptions.put("consumer1", this.subscription(AbstractStickyAssignorTest.topics("topic1", "topic2", "topic3", "topic4", "topic5"), 0));
        this.subscriptions.put("consumer2", this.subscription(AbstractStickyAssignorTest.topics("topic1", "topic3", "topic5"), 1));
        this.subscriptions.put("consumer3", this.subscription(AbstractStickyAssignorTest.topics("topic1", "topic3", "topic5"), 2));
        this.subscriptions.put("consumer4", this.subscription(AbstractStickyAssignorTest.topics("topic1", "topic2", "topic3", "topic4", "topic5"), 3));
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testAddRemoveTopicTwoConsumers(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        this.initializeRacks(rackConfig);
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        partitionsPerTopic.put(this.topic, this.partitionInfos(this.topic, 3));
        this.subscriptions.put(this.consumer1, this.subscription(AbstractStickyAssignorTest.topics(this.topic), 0));
        this.subscriptions.put(this.consumer2, this.subscription(AbstractStickyAssignorTest.topics(this.topic), 1));
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        Assertions.assertTrue((boolean)this.assignor.partitionsTransferringOwnership.isEmpty());
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        List consumer1Assignment1 = (List)assignment.get(this.consumer1);
        List consumer2Assignment1 = (List)assignment.get(this.consumer2);
        Assertions.assertTrue((consumer1Assignment1.size() == 1 && consumer2Assignment1.size() == 2 || consumer1Assignment1.size() == 2 && consumer2Assignment1.size() == 1 ? 1 : 0) != 0);
        partitionsPerTopic.put(this.topic2, this.partitionInfos(this.topic2, 3));
        this.subscriptions.put(this.consumer1, this.buildSubscriptionV2Above(AbstractStickyAssignorTest.topics(this.topic, this.topic2), (List)assignment.get(this.consumer1), this.generationId, 0));
        this.subscriptions.put(this.consumer2, this.buildSubscriptionV2Above(AbstractStickyAssignorTest.topics(this.topic, this.topic2), (List)assignment.get(this.consumer2), this.generationId, 1));
        assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        Assertions.assertTrue((boolean)this.assignor.partitionsTransferringOwnership.isEmpty());
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
        List consumer1assignment = (List)assignment.get(this.consumer1);
        List consumer2assignment = (List)assignment.get(this.consumer2);
        Assertions.assertTrue((consumer1assignment.size() == 3 && consumer2assignment.size() == 3 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)consumer1assignment.containsAll(consumer1Assignment1));
        Assertions.assertTrue((boolean)consumer2assignment.containsAll(consumer2Assignment1));
        partitionsPerTopic.remove(this.topic);
        this.subscriptions.put(this.consumer1, this.buildSubscriptionV2Above(AbstractStickyAssignorTest.topics(this.topic2), (List)assignment.get(this.consumer1), this.generationId, 0));
        this.subscriptions.put(this.consumer2, this.buildSubscriptionV2Above(AbstractStickyAssignorTest.topics(this.topic2), (List)assignment.get(this.consumer2), this.generationId, 1));
        assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        Assertions.assertTrue((boolean)this.assignor.partitionsTransferringOwnership.isEmpty());
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
        List consumer1Assignment3 = (List)assignment.get(this.consumer1);
        List consumer2Assignment3 = (List)assignment.get(this.consumer2);
        Assertions.assertTrue((consumer1Assignment3.size() == 1 && consumer2Assignment3.size() == 2 || consumer1Assignment3.size() == 2 && consumer2Assignment3.size() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)consumer1assignment.containsAll(consumer1Assignment3));
        Assertions.assertTrue((boolean)consumer2assignment.containsAll(consumer2Assignment3));
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testReassignmentAfterOneConsumerLeaves(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        int i;
        this.initializeRacks(rackConfig);
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        for (i = 1; i < 20; ++i) {
            String topicName = this.getTopicName(i, 20);
            partitionsPerTopic.put(topicName, this.partitionInfos(topicName, i));
        }
        for (i = 1; i < 20; ++i) {
            ArrayList<String> topics = new ArrayList<String>();
            for (int j = 1; j <= i; ++j) {
                topics.add(this.getTopicName(j, 20));
            }
            this.subscriptions.put(this.getConsumerName(i, 20), this.subscription(topics, i));
        }
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        for (int i2 = 1; i2 < 20; ++i2) {
            String consumer = this.getConsumerName(i2, 20);
            this.subscriptions.put(consumer, this.buildSubscriptionV2Above(this.subscriptions.get(consumer).topics(), (List)assignment.get(consumer), this.generationId, i2));
        }
        this.subscriptions.remove("consumer10");
        assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)this.assignor.isSticky());
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testReassignmentAfterOneConsumerAdded(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        this.initializeRacks(rackConfig);
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        partitionsPerTopic.put("topic", this.partitionInfos("topic", 20));
        for (int i = 1; i < 10; ++i) {
            this.subscriptions.put(this.getConsumerName(i, 10), this.subscription(AbstractStickyAssignorTest.topics("topic"), i));
        }
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        Assertions.assertTrue((boolean)this.assignor.partitionsTransferringOwnership.isEmpty());
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        this.subscriptions.put(this.getConsumerName(10, 10), this.subscription(AbstractStickyAssignorTest.topics("topic"), 10));
        assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        Assertions.assertTrue((boolean)this.assignor.partitionsTransferringOwnership.isEmpty());
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testSameSubscriptions(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        int i;
        this.initializeRacks(rackConfig);
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        for (i = 1; i < 15; ++i) {
            String topicName = this.getTopicName(i, 15);
            partitionsPerTopic.put(topicName, this.partitionInfos(topicName, i));
        }
        for (i = 1; i < 9; ++i) {
            ArrayList<String> topics = new ArrayList<String>();
            for (int j = 1; j <= partitionsPerTopic.size(); ++j) {
                topics.add(this.getTopicName(j, 15));
            }
            this.subscriptions.put(this.getConsumerName(i, 9), this.subscription(topics, i));
        }
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        Assertions.assertTrue((boolean)this.assignor.partitionsTransferringOwnership.isEmpty());
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        for (int i2 = 1; i2 < 9; ++i2) {
            String consumer = this.getConsumerName(i2, 9);
            this.subscriptions.put(consumer, this.buildSubscriptionV2Above(this.subscriptions.get(consumer).topics(), (List)assignment.get(consumer), this.generationId, i2));
        }
        this.subscriptions.remove(this.getConsumerName(5, 9));
        assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        Assertions.assertTrue((boolean)this.assignor.partitionsTransferringOwnership.isEmpty());
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
    }

    @Timeout(value=30L)
    @ParameterizedTest(name="{displayName}.hasConsumerRack = {0}")
    @ValueSource(booleans={false, true})
    public void testLargeAssignmentAndGroupWithUniformSubscription(boolean hasConsumerRack) {
        int i;
        this.initializeRacks(hasConsumerRack ? AbstractPartitionAssignorTest.RackConfig.BROKER_AND_CONSUMER_RACK : AbstractPartitionAssignorTest.RackConfig.NO_CONSUMER_RACK);
        int topicCount = hasConsumerRack ? 50 : 500;
        int partitionCount = 2000;
        int consumerCount = 2000;
        ArrayList<String> topics = new ArrayList<String>();
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        for (i = 0; i < topicCount; ++i) {
            String topicName = this.getTopicName(i, topicCount);
            topics.add(topicName);
            partitionsPerTopic.put(topicName, this.partitionInfos(topicName, partitionCount));
        }
        for (i = 0; i < consumerCount; ++i) {
            this.subscriptions.put(this.getConsumerName(i, consumerCount), this.subscription(topics, i));
        }
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        for (int i2 = 1; i2 < consumerCount; ++i2) {
            String consumer = this.getConsumerName(i2, consumerCount);
            this.subscriptions.put(consumer, this.buildSubscriptionV2Above(topics, (List)assignment.get(consumer), this.generationId, i2));
        }
        this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
    }

    @Timeout(value=90L)
    @ParameterizedTest(name="{displayName}.hasConsumerRack = {0}")
    @ValueSource(booleans={false, true})
    public void testLargeAssignmentAndGroupWithNonEqualSubscription(boolean hasConsumerRack) {
        int i;
        this.initializeRacks(hasConsumerRack ? AbstractPartitionAssignorTest.RackConfig.BROKER_AND_CONSUMER_RACK : AbstractPartitionAssignorTest.RackConfig.NO_CONSUMER_RACK);
        int topicCount = hasConsumerRack ? 50 : 500;
        int partitionCount = 2000;
        int consumerCount = 2000;
        ArrayList<String> topics = new ArrayList<String>();
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        for (i = 0; i < topicCount; ++i) {
            String topicName = this.getTopicName(i, topicCount);
            topics.add(topicName);
            partitionsPerTopic.put(topicName, this.partitionInfos(topicName, partitionCount));
        }
        for (i = 0; i < consumerCount; ++i) {
            if (i == consumerCount - 1) {
                this.subscriptions.put(this.getConsumerName(i, consumerCount), this.subscription(topics.subList(0, 1), i));
                continue;
            }
            this.subscriptions.put(this.getConsumerName(i, consumerCount), this.subscription(topics, i));
        }
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        for (int i2 = 1; i2 < consumerCount; ++i2) {
            String consumer = this.getConsumerName(i2, consumerCount);
            if (i2 == consumerCount - 1) {
                this.subscriptions.put(consumer, this.buildSubscriptionV2Above(topics.subList(0, 1), (List)assignment.get(consumer), this.generationId, i2));
                continue;
            }
            this.subscriptions.put(consumer, this.buildSubscriptionV2Above(topics, (List)assignment.get(consumer), this.generationId, i2));
        }
        this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
    }

    @Timeout(value=90L)
    @ParameterizedTest(name="{displayName}.hasConsumerRack = {0}")
    @ValueSource(booleans={false, true})
    public void testAssignmentAndGroupWithNonEqualSubscriptionNotTimeout(boolean hasConsumerRack) {
        int i;
        this.initializeRacks(hasConsumerRack ? AbstractPartitionAssignorTest.RackConfig.BROKER_AND_CONSUMER_RACK : AbstractPartitionAssignorTest.RackConfig.NO_CONSUMER_RACK);
        int topicCount = hasConsumerRack ? 50 : 100;
        int partitionCount = 200;
        int consumerCount = 500;
        ArrayList<String> topics = new ArrayList<String>();
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        for (i = 0; i < topicCount; ++i) {
            String topicName = this.getTopicName(i, topicCount);
            topics.add(topicName);
            partitionsPerTopic.put(topicName, this.partitionInfos(topicName, partitionCount));
        }
        for (i = 0; i < consumerCount; ++i) {
            if (i % 4 == 0) {
                this.subscriptions.put(this.getConsumerName(i, consumerCount), this.subscription(topics.subList(0, topicCount / 2), i));
                continue;
            }
            this.subscriptions.put(this.getConsumerName(i, consumerCount), this.subscription(topics.subList(topicCount / 2, topicCount), i));
        }
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        for (int i2 = 1; i2 < consumerCount; ++i2) {
            String consumer = this.getConsumerName(i2, consumerCount);
            if (i2 % 4 == 0) {
                this.subscriptions.put(consumer, this.buildSubscriptionV2Above(topics.subList(0, topicCount / 2), (List)assignment.get(consumer), this.generationId, i2));
                continue;
            }
            this.subscriptions.put(consumer, this.buildSubscriptionV2Above(topics.subList(topicCount / 2, topicCount), (List)assignment.get(consumer), this.generationId, i2));
        }
        this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
    }

    @Test
    public void testSubscriptionNotEqualAndAssignSamePartitionWith3Generation() {
        int[][] sequence;
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        partitionsPerTopic.put(this.topic, this.partitionInfos(this.topic, 6));
        partitionsPerTopic.put(this.topic1, this.partitionInfos(this.topic1, 1));
        for (int[] ints : sequence = new int[][]{{1, 2, 3}, {1, 3, 2}, {2, 1, 3}, {2, 3, 1}, {3, 1, 2}, {3, 2, 1}}) {
            this.subscriptions.put(this.consumer1, this.buildSubscriptionV2Above(AbstractStickyAssignorTest.topics(this.topic), AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 0), AbstractStickyAssignorTest.tp(this.topic, 2)), ints[0], 0));
            this.subscriptions.put(this.consumer2, this.buildSubscriptionV2Above(AbstractStickyAssignorTest.topics(this.topic), AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 1), AbstractStickyAssignorTest.tp(this.topic, 2), AbstractStickyAssignorTest.tp(this.topic, 3)), ints[1], 1));
            this.subscriptions.put(this.consumer3, this.buildSubscriptionV2Above(AbstractStickyAssignorTest.topics(this.topic), AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 2), AbstractStickyAssignorTest.tp(this.topic, 4), AbstractStickyAssignorTest.tp(this.topic, 5)), ints[2], 2));
            this.subscriptions.put(this.consumer4, this.buildSubscriptionV2Above(AbstractStickyAssignorTest.topics(this.topic1), AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic1, 0)), 2, 3));
            Map assign = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
            Assertions.assertEquals((int)assign.values().stream().mapToInt(List::size).sum(), (int)assign.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()).size());
            for (List list : assign.values()) {
                Assertions.assertTrue((list.size() >= 1 && list.size() <= 2 ? 1 : 0) != 0);
            }
        }
    }

    @Timeout(value=60L)
    @ParameterizedTest(name="{displayName}.hasConsumerRack = {0}")
    @ValueSource(booleans={false, true})
    public void testLargeAssignmentWithMultipleConsumersLeavingAndRandomSubscription(boolean hasConsumerRack) {
        int i;
        int i2;
        this.initializeRacks(hasConsumerRack ? AbstractPartitionAssignorTest.RackConfig.BROKER_AND_CONSUMER_RACK : AbstractPartitionAssignorTest.RackConfig.NO_CONSUMER_RACK);
        Random rand = new Random();
        int topicCount = 40;
        int consumerCount = 200;
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        for (i2 = 0; i2 < topicCount; ++i2) {
            String topicName = this.getTopicName(i2, topicCount);
            partitionsPerTopic.put(topicName, this.partitionInfos(topicName, rand.nextInt(10) + 1));
        }
        for (i2 = 0; i2 < consumerCount; ++i2) {
            ArrayList<String> topics = new ArrayList<String>();
            for (int j = 0; j < rand.nextInt(20); ++j) {
                topics.add(this.getTopicName(rand.nextInt(topicCount), topicCount));
            }
            this.subscriptions.put(this.getConsumerName(i2, consumerCount), this.subscription(topics, i2));
        }
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        for (i = 1; i < consumerCount; ++i) {
            String consumer = this.getConsumerName(i, consumerCount);
            this.subscriptions.put(consumer, this.buildSubscriptionV2Above(this.subscriptions.get(consumer).topics(), (List)assignment.get(consumer), this.generationId, i));
        }
        for (i = 0; i < 50; ++i) {
            String c = this.getConsumerName(rand.nextInt(consumerCount), consumerCount);
            this.subscriptions.remove(c);
        }
        assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)this.assignor.isSticky());
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testNewSubscription(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        int i;
        this.initializeRacks(rackConfig);
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        for (i = 1; i < 5; ++i) {
            String topicName = this.getTopicName(i, 5);
            partitionsPerTopic.put(topicName, this.partitionInfos(topicName, 1));
        }
        for (i = 0; i < 3; ++i) {
            ArrayList<String> topics = new ArrayList<String>();
            for (int j = i; j <= 3 * i - 2; ++j) {
                topics.add(this.getTopicName(j, 5));
            }
            this.subscriptions.put(this.getConsumerName(i, 3), this.subscription(topics, i));
        }
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        this.subscriptions.get(this.getConsumerName(0, 3)).topics().add(this.getTopicName(1, 5));
        assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)this.assignor.isSticky());
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testMoveExistingAssignments(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        this.initializeRacks(rackConfig);
        String topic4 = "topic4";
        String topic5 = "topic5";
        String topic6 = "topic6";
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        for (int i = 1; i <= 6; ++i) {
            String topicName = String.format("topic%d", i);
            partitionsPerTopic.put(topicName, this.partitionInfos(topicName, 1));
        }
        this.subscriptions.put(this.consumer1, this.buildSubscriptionV2Above(AbstractStickyAssignorTest.topics(this.topic1, this.topic2), AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic1, 0)), this.generationId, 0));
        this.subscriptions.put(this.consumer2, this.buildSubscriptionV2Above(AbstractStickyAssignorTest.topics(this.topic1, this.topic2, this.topic3, topic4), AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic2, 0), AbstractStickyAssignorTest.tp(this.topic3, 0)), this.generationId, 1));
        this.subscriptions.put(this.consumer3, this.buildSubscriptionV2Above(AbstractStickyAssignorTest.topics(this.topic2, this.topic3, topic4, topic5, topic6), AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(topic4, 0), AbstractStickyAssignorTest.tp(topic5, 0), AbstractStickyAssignorTest.tp(topic6, 0)), this.generationId, 2));
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        Assertions.assertNull((Object)this.assignor.partitionsTransferringOwnership);
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testStickiness(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        List topicPartitions;
        String consumer;
        this.initializeRacks(rackConfig);
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        partitionsPerTopic.put(this.topic1, this.partitionInfos(this.topic1, 3));
        this.subscriptions.put(this.consumer1, this.subscription(AbstractStickyAssignorTest.topics(this.topic1), 0));
        this.subscriptions.put(this.consumer2, this.subscription(AbstractStickyAssignorTest.topics(this.topic1), 1));
        this.subscriptions.put(this.consumer3, this.subscription(AbstractStickyAssignorTest.topics(this.topic1), 2));
        this.subscriptions.put(this.consumer4, this.subscription(AbstractStickyAssignorTest.topics(this.topic1), 3));
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        Assertions.assertTrue((boolean)this.assignor.partitionsTransferringOwnership.isEmpty());
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        HashMap<String, TopicPartition> partitionsAssigned = new HashMap<String, TopicPartition>();
        Set assignments = assignment.entrySet();
        for (Map.Entry entry : assignments) {
            consumer = (String)entry.getKey();
            topicPartitions = (List)entry.getValue();
            int size = topicPartitions.size();
            Assertions.assertTrue((size <= 1 ? 1 : 0) != 0, (String)("Consumer " + consumer + " is assigned more topic partitions than expected."));
            if (size != 1) continue;
            partitionsAssigned.put(consumer, (TopicPartition)topicPartitions.get(0));
        }
        this.subscriptions.remove(this.consumer1);
        this.subscriptions.put(this.consumer2, this.buildSubscriptionV2Above(AbstractStickyAssignorTest.topics(this.topic1), (List)assignment.get(this.consumer2), this.generationId, 1));
        this.subscriptions.put(this.consumer3, this.buildSubscriptionV2Above(AbstractStickyAssignorTest.topics(this.topic1), (List)assignment.get(this.consumer3), this.generationId, 2));
        this.subscriptions.put(this.consumer4, this.buildSubscriptionV2Above(AbstractStickyAssignorTest.topics(this.topic1), (List)assignment.get(this.consumer4), this.generationId, 3));
        assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        Assertions.assertTrue((boolean)this.assignor.partitionsTransferringOwnership.isEmpty());
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        assignments = assignment.entrySet();
        for (Map.Entry entry : assignments) {
            consumer = (String)entry.getKey();
            topicPartitions = (List)entry.getValue();
            Assertions.assertEquals((int)1, (int)topicPartitions.size(), (String)("Consumer " + consumer + " is assigned more topic partitions than expected."));
            Assertions.assertTrue((!partitionsAssigned.containsKey(consumer) || ((List)assignment.get(consumer)).contains(partitionsAssigned.get(consumer)) ? 1 : 0) != 0, (String)("Stickiness was not honored for consumer " + consumer));
        }
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testAssignmentUpdatedForDeletedTopic(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        this.initializeRacks(rackConfig);
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        partitionsPerTopic.put(this.topic1, this.partitionInfos(this.topic1, 1));
        partitionsPerTopic.put(this.topic3, this.partitionInfos(this.topic3, 100));
        this.subscriptions = Collections.singletonMap(this.consumerId, this.subscription(AbstractStickyAssignorTest.topics(this.topic1, this.topic2, this.topic3), 0));
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        Assertions.assertTrue((boolean)this.assignor.partitionsTransferringOwnership.isEmpty());
        Assertions.assertEquals((int)assignment.values().stream().mapToInt(List::size).sum(), (int)101);
        Assertions.assertEquals(Collections.singleton(this.consumerId), assignment.keySet());
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testNoExceptionThrownWhenOnlySubscribedTopicDeleted(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        this.initializeRacks(rackConfig);
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        partitionsPerTopic.put(this.topic, this.partitionInfos(this.topic, 3));
        this.subscriptions.put(this.consumerId, this.subscription(AbstractStickyAssignorTest.topics(this.topic), 0));
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        Assertions.assertTrue((boolean)this.assignor.partitionsTransferringOwnership.isEmpty());
        this.subscriptions.put(this.consumerId, this.buildSubscriptionV2Above(AbstractStickyAssignorTest.topics(this.topic), (List)assignment.get(this.consumerId), this.generationId, 0));
        assignment = this.assignor.assign(Collections.emptyMap(), this.subscriptions);
        Assertions.assertTrue((boolean)this.assignor.partitionsTransferringOwnership.isEmpty());
        Assertions.assertEquals((int)assignment.size(), (int)1);
        Assertions.assertTrue((boolean)((List)assignment.get(this.consumerId)).isEmpty());
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testReassignmentWithRandomSubscriptionsAndChanges(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        this.initializeRacks(rackConfig);
        int minNumConsumers = 20;
        int maxNumConsumers = 40;
        int minNumTopics = 10;
        int maxNumTopics = 20;
        for (int round = 1; round <= 100; ++round) {
            int numTopics = 10 + new Random().nextInt(10);
            ArrayList<String> topics = new ArrayList<String>();
            HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
            for (int i = 0; i < numTopics; ++i) {
                String topicName = this.getTopicName(i, 20);
                topics.add(topicName);
                partitionsPerTopic.put(topicName, this.partitionInfos(topicName, i + 1));
            }
            int numConsumers = 20 + new Random().nextInt(20);
            for (int i = 0; i < numConsumers; ++i) {
                List sub = Utils.sorted(AbstractStickyAssignorTest.getRandomSublist(topics));
                this.subscriptions.put(this.getConsumerName(i, 40), this.subscription(sub, i));
            }
            this.assignor = this.createAssignor();
            Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
            this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
            this.subscriptions.clear();
            for (int i = 0; i < numConsumers; ++i) {
                List sub = Utils.sorted(AbstractStickyAssignorTest.getRandomSublist(topics));
                String consumer = this.getConsumerName(i, 40);
                this.subscriptions.put(consumer, this.buildSubscriptionV2Above(sub, (List)assignment.get(consumer), this.generationId, i));
            }
            assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
            this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
            Assertions.assertTrue((boolean)this.assignor.isSticky());
        }
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testAllConsumersReachExpectedQuotaAndAreConsideredFilled(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        this.initializeRacks(rackConfig);
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        partitionsPerTopic.put(this.topic, this.partitionInfos(this.topic, 4));
        this.subscriptions.put(this.consumer1, this.buildSubscriptionV2Above(AbstractStickyAssignorTest.topics(this.topic), AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 0), AbstractStickyAssignorTest.tp(this.topic, 1)), this.generationId, 0));
        this.subscriptions.put(this.consumer2, this.buildSubscriptionV2Above(AbstractStickyAssignorTest.topics(this.topic), AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 2)), this.generationId, 1));
        this.subscriptions.put(this.consumer3, this.buildSubscriptionV2Above(AbstractStickyAssignorTest.topics(this.topic), Collections.emptyList(), this.generationId, 2));
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 0), AbstractStickyAssignorTest.tp(this.topic, 1)), assignment.get(this.consumer1));
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 2)), assignment.get(this.consumer2));
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 3)), assignment.get(this.consumer3));
        Assertions.assertTrue((boolean)this.assignor.partitionsTransferringOwnership.isEmpty());
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testOwnedPartitionsAreInvalidatedForConsumerWithStaleGeneration(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        this.initializeRacks(rackConfig);
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        partitionsPerTopic.put(this.topic, this.partitionInfos(this.topic, 3));
        partitionsPerTopic.put(this.topic2, this.partitionInfos(this.topic2, 3));
        int currentGeneration = 10;
        this.subscriptions.put(this.consumer1, this.buildSubscriptionV2Above(AbstractStickyAssignorTest.topics(this.topic, this.topic2), AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 0), AbstractStickyAssignorTest.tp(this.topic, 2), AbstractStickyAssignorTest.tp(this.topic2, 1)), currentGeneration, 0));
        this.subscriptions.put(this.consumer2, this.buildSubscriptionV2Above(AbstractStickyAssignorTest.topics(this.topic, this.topic2), AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 0), AbstractStickyAssignorTest.tp(this.topic, 2), AbstractStickyAssignorTest.tp(this.topic2, 1)), currentGeneration - 1, 1));
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals(new HashSet<TopicPartition>(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 0), AbstractStickyAssignorTest.tp(this.topic, 2), AbstractStickyAssignorTest.tp(this.topic2, 1))), new HashSet((Collection)assignment.get(this.consumer1)));
        Assertions.assertEquals(new HashSet<TopicPartition>(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 1), AbstractStickyAssignorTest.tp(this.topic2, 0), AbstractStickyAssignorTest.tp(this.topic2, 2))), new HashSet((Collection)assignment.get(this.consumer2)));
        Assertions.assertTrue((boolean)this.assignor.partitionsTransferringOwnership.isEmpty());
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testOwnedPartitionsAreInvalidatedForConsumerWithNoGeneration(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        this.initializeRacks(rackConfig);
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        partitionsPerTopic.put(this.topic, this.partitionInfos(this.topic, 3));
        partitionsPerTopic.put(this.topic2, this.partitionInfos(this.topic2, 3));
        int currentGeneration = 10;
        this.subscriptions.put(this.consumer1, this.buildSubscriptionV2Above(AbstractStickyAssignorTest.topics(this.topic, this.topic2), AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 0), AbstractStickyAssignorTest.tp(this.topic, 2), AbstractStickyAssignorTest.tp(this.topic2, 1)), currentGeneration, 0));
        this.subscriptions.put(this.consumer2, this.buildSubscriptionV2Above(AbstractStickyAssignorTest.topics(this.topic, this.topic2), AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 0), AbstractStickyAssignorTest.tp(this.topic, 2), AbstractStickyAssignorTest.tp(this.topic2, 1)), -1, 1));
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals(new HashSet<TopicPartition>(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 0), AbstractStickyAssignorTest.tp(this.topic, 2), AbstractStickyAssignorTest.tp(this.topic2, 1))), new HashSet((Collection)assignment.get(this.consumer1)));
        Assertions.assertEquals(new HashSet<TopicPartition>(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 1), AbstractStickyAssignorTest.tp(this.topic2, 0), AbstractStickyAssignorTest.tp(this.topic2, 2))), new HashSet((Collection)assignment.get(this.consumer2)));
        Assertions.assertTrue((boolean)this.assignor.partitionsTransferringOwnership.isEmpty());
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testPartitionsTransferringOwnershipIncludeThePartitionClaimedByMultipleConsumersInSameGeneration(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        this.initializeRacks(rackConfig);
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        partitionsPerTopic.put(this.topic, this.partitionInfos(this.topic, 3));
        this.subscriptions.put(this.consumer1, this.buildSubscriptionV2Above(AbstractStickyAssignorTest.topics(this.topic), AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 0), AbstractStickyAssignorTest.tp(this.topic, 1)), this.generationId, 0));
        this.subscriptions.put(this.consumer2, this.buildSubscriptionV2Above(AbstractStickyAssignorTest.topics(this.topic), AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 0), AbstractStickyAssignorTest.tp(this.topic, 2)), this.generationId, 1));
        this.subscriptions.put(this.consumer3, this.buildSubscriptionV2Above(AbstractStickyAssignorTest.topics(this.topic), Collections.emptyList(), this.generationId, 2));
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals(Collections.singletonMap(AbstractStickyAssignorTest.tp(this.topic, 0), this.consumer3), (Object)this.assignor.partitionsTransferringOwnership);
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 1)), assignment.get(this.consumer1));
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 2)), assignment.get(this.consumer2));
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 0)), assignment.get(this.consumer3));
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testEnsurePartitionsAssignedToHighestGeneration(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        this.initializeRacks(rackConfig);
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        partitionsPerTopic.put(this.topic, this.partitionInfos(this.topic, 3));
        partitionsPerTopic.put(this.topic2, this.partitionInfos(this.topic2, 3));
        partitionsPerTopic.put(this.topic3, this.partitionInfos(this.topic3, 3));
        int currentGeneration = 10;
        this.subscriptions.put(this.consumer1, this.buildSubscriptionV2Above(AbstractStickyAssignorTest.topics(this.topic, this.topic2, this.topic3), AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 0), AbstractStickyAssignorTest.tp(this.topic2, 0), AbstractStickyAssignorTest.tp(this.topic3, 0)), currentGeneration, 0));
        this.subscriptions.put(this.consumer2, this.buildSubscriptionV2Above(AbstractStickyAssignorTest.topics(this.topic, this.topic2, this.topic3), AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 1), AbstractStickyAssignorTest.tp(this.topic2, 1), AbstractStickyAssignorTest.tp(this.topic3, 1)), currentGeneration - 1, 1));
        this.subscriptions.put(this.consumer3, this.buildSubscriptionV2Above(AbstractStickyAssignorTest.topics(this.topic, this.topic2, this.topic3), AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic2, 1), AbstractStickyAssignorTest.tp(this.topic3, 0), AbstractStickyAssignorTest.tp(this.topic3, 2)), currentGeneration - 2, 1));
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals(new HashSet<TopicPartition>(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 0), AbstractStickyAssignorTest.tp(this.topic2, 0), AbstractStickyAssignorTest.tp(this.topic3, 0))), new HashSet((Collection)assignment.get(this.consumer1)));
        Assertions.assertEquals(new HashSet<TopicPartition>(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 1), AbstractStickyAssignorTest.tp(this.topic2, 1), AbstractStickyAssignorTest.tp(this.topic3, 1))), new HashSet((Collection)assignment.get(this.consumer2)));
        Assertions.assertEquals(new HashSet<TopicPartition>(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 2), AbstractStickyAssignorTest.tp(this.topic2, 2), AbstractStickyAssignorTest.tp(this.topic3, 2))), new HashSet((Collection)assignment.get(this.consumer3)));
        Assertions.assertTrue((boolean)this.assignor.partitionsTransferringOwnership.isEmpty());
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testNoReassignmentOnCurrentMembers(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        this.initializeRacks(rackConfig);
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        partitionsPerTopic.put(this.topic, this.partitionInfos(this.topic, 3));
        partitionsPerTopic.put(this.topic1, this.partitionInfos(this.topic1, 3));
        partitionsPerTopic.put(this.topic2, this.partitionInfos(this.topic2, 3));
        partitionsPerTopic.put(this.topic3, this.partitionInfos(this.topic3, 3));
        int currentGeneration = 10;
        this.subscriptions.put(this.consumer1, this.buildSubscriptionV2Above(AbstractStickyAssignorTest.topics(this.topic, this.topic2, this.topic3, this.topic1), AbstractStickyAssignorTest.partitions(new TopicPartition[0]), -1, 0));
        this.subscriptions.put(this.consumer2, this.buildSubscriptionV2Above(AbstractStickyAssignorTest.topics(this.topic, this.topic2, this.topic3, this.topic1), AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 0), AbstractStickyAssignorTest.tp(this.topic2, 0), AbstractStickyAssignorTest.tp(this.topic1, 0)), currentGeneration - 1, 1));
        this.subscriptions.put(this.consumer3, this.buildSubscriptionV2Above(AbstractStickyAssignorTest.topics(this.topic, this.topic2, this.topic3, this.topic1), AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic3, 2), AbstractStickyAssignorTest.tp(this.topic2, 2), AbstractStickyAssignorTest.tp(this.topic1, 1)), currentGeneration - 2, 2));
        this.subscriptions.put(this.consumer4, this.buildSubscriptionV2Above(AbstractStickyAssignorTest.topics(this.topic, this.topic2, this.topic3, this.topic1), AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic3, 1), AbstractStickyAssignorTest.tp(this.topic, 1), AbstractStickyAssignorTest.tp(this.topic, 2)), currentGeneration - 3, 3));
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals(new HashSet<TopicPartition>(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic1, 2), AbstractStickyAssignorTest.tp(this.topic2, 1), AbstractStickyAssignorTest.tp(this.topic3, 0))), new HashSet((Collection)assignment.get(this.consumer1)));
        Assertions.assertTrue((boolean)this.assignor.partitionsTransferringOwnership.isEmpty());
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testOwnedPartitionsAreInvalidatedForConsumerWithMultipleGeneration(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        this.initializeRacks(rackConfig);
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        partitionsPerTopic.put(this.topic, this.partitionInfos(this.topic, 3));
        partitionsPerTopic.put(this.topic2, this.partitionInfos(this.topic2, 3));
        int currentGeneration = 10;
        this.subscriptions.put(this.consumer1, this.buildSubscriptionV2Above(AbstractStickyAssignorTest.topics(this.topic, this.topic2), AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 0), AbstractStickyAssignorTest.tp(this.topic2, 1), AbstractStickyAssignorTest.tp(this.topic, 1)), currentGeneration, 0));
        this.subscriptions.put(this.consumer2, this.buildSubscriptionV2Above(AbstractStickyAssignorTest.topics(this.topic, this.topic2), AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 0), AbstractStickyAssignorTest.tp(this.topic2, 1), AbstractStickyAssignorTest.tp(this.topic2, 2)), currentGeneration - 2, 1));
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals(new HashSet<TopicPartition>(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 0), AbstractStickyAssignorTest.tp(this.topic2, 1), AbstractStickyAssignorTest.tp(this.topic, 1))), new HashSet((Collection)assignment.get(this.consumer1)));
        Assertions.assertEquals(new HashSet<TopicPartition>(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 2), AbstractStickyAssignorTest.tp(this.topic2, 2), AbstractStickyAssignorTest.tp(this.topic2, 0))), new HashSet((Collection)assignment.get(this.consumer2)));
        Assertions.assertTrue((boolean)this.assignor.partitionsTransferringOwnership.isEmpty());
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
    }

    @Test
    public void testRackAwareAssignmentWithUniformSubscription() {
        Map topics = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"t1", (Object)6), Utils.mkEntry((Object)"t2", (Object)7), Utils.mkEntry((Object)"t3", (Object)2)});
        List<String> allTopics = Arrays.asList("t1", "t2", "t3");
        List<List<String>> consumerTopics = Arrays.asList(allTopics, allTopics, allTopics);
        List<String> nonRackAwareAssignment = Arrays.asList("t1-0, t1-3, t2-0, t2-3, t2-6", "t1-1, t1-4, t2-1, t2-4, t3-0", "t1-2, t1-5, t2-2, t2-5, t3-1");
        this.verifyUniformSubscription(this.assignor, topics, 3, AbstractPartitionAssignorTest.nullRacks(3), AbstractPartitionAssignorTest.racks(3), consumerTopics, nonRackAwareAssignment, -1);
        this.verifyUniformSubscription(this.assignor, topics, 3, AbstractPartitionAssignorTest.racks(3), AbstractPartitionAssignorTest.nullRacks(3), consumerTopics, nonRackAwareAssignment, -1);
        AbstractPartitionAssignorTest.preferRackAwareLogic((AbstractPartitionAssignor)this.assignor, true);
        this.verifyUniformSubscription(this.assignor, topics, 3, AbstractPartitionAssignorTest.racks(3), AbstractPartitionAssignorTest.racks(3), consumerTopics, nonRackAwareAssignment, 0);
        AbstractPartitionAssignorTest.preferRackAwareLogic((AbstractPartitionAssignor)this.assignor, true);
        this.verifyUniformSubscription(this.assignor, topics, 4, AbstractPartitionAssignorTest.racks(4), AbstractPartitionAssignorTest.racks(3), consumerTopics, nonRackAwareAssignment, 0);
        AbstractPartitionAssignorTest.preferRackAwareLogic((AbstractPartitionAssignor)this.assignor, false);
        this.verifyUniformSubscription(this.assignor, topics, 3, AbstractPartitionAssignorTest.racks(3), AbstractPartitionAssignorTest.racks(3), consumerTopics, nonRackAwareAssignment, 0);
        this.verifyUniformSubscription(this.assignor, topics, 3, AbstractPartitionAssignorTest.racks(3), Arrays.asList("d", "e", "f"), consumerTopics, nonRackAwareAssignment, -1);
        this.verifyUniformSubscription(this.assignor, topics, 3, AbstractPartitionAssignorTest.racks(3), Arrays.asList(null, "e", "f"), consumerTopics, nonRackAwareAssignment, -1);
        List<String> assignment = Arrays.asList("t1-0, t1-3, t2-0, t2-3, t2-6", "t1-1, t1-4, t2-1, t2-4, t3-0", "t1-2, t1-5, t2-2, t2-5, t3-1");
        this.verifyUniformSubscription(this.assignor, topics, 1, AbstractPartitionAssignorTest.racks(3), AbstractPartitionAssignorTest.racks(3), consumerTopics, assignment, 0);
        assignment = Arrays.asList("t1-0, t1-3, t2-0, t2-3, t2-6", "t1-1, t1-4, t2-1, t2-4, t3-0", "t1-2, t1-5, t2-2, t2-5, t3-1");
        this.verifyUniformSubscription(this.assignor, topics, 2, AbstractPartitionAssignorTest.racks(3), AbstractPartitionAssignorTest.racks(3), consumerTopics, assignment, 0);
        assignment = Arrays.asList("t1-0, t1-3, t2-0, t2-3, t2-6", "t1-1, t1-4, t2-1, t2-4, t3-0", "t1-2, t1-5, t2-2, t2-5, t3-1");
        this.verifyUniformSubscription(this.assignor, topics, 3, AbstractPartitionAssignorTest.racks(2), AbstractPartitionAssignorTest.racks(3), consumerTopics, assignment, 5);
        assignment = Arrays.asList("t1-0, t1-3, t2-0, t2-3, t2-6", "t1-1, t1-4, t2-1, t2-4, t3-0", "t1-2, t1-5, t2-2, t2-5, t3-1");
        List<String> owned = Arrays.asList("t1-0, t1-1, t1-2, t1-3, t1-4", "t1-5, t2-0, t2-1, t2-2, t2-3", "t2-4, t2-5, t2-6, t3-0, t3-1");
        AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)this.assignor, topics, 1, AbstractPartitionAssignorTest.racks(3), AbstractPartitionAssignorTest.racks(3), consumerTopics, owned, assignment, 0);
        AbstractPartitionAssignorTest.preferRackAwareLogic((AbstractPartitionAssignor)this.assignor, true);
        AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)this.assignor, topics, 3, AbstractPartitionAssignorTest.racks(3), AbstractPartitionAssignorTest.racks(3), consumerTopics, assignment, assignment, 0);
    }

    private void verifyUniformSubscription(AbstractStickyAssignor assignor, Map<String, Integer> numPartitionsPerTopic, int replicationFactor, List<String> brokerRacks, List<String> consumerRacks, List<List<String>> consumerTopics, List<String> expectedAssignments, int numPartitionsWithRackMismatch) {
        AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)assignor, numPartitionsPerTopic, replicationFactor, brokerRacks, consumerRacks, consumerTopics, null, expectedAssignments, numPartitionsWithRackMismatch);
        AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)assignor, numPartitionsPerTopic, replicationFactor, brokerRacks, consumerRacks, consumerTopics, expectedAssignments, expectedAssignments, numPartitionsWithRackMismatch);
    }

    @Test
    public void testRackAwareAssignmentWithNonEqualSubscription() {
        List<String> intermediate;
        Map topics = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"t1", (Object)6), Utils.mkEntry((Object)"t2", (Object)7), Utils.mkEntry((Object)"t3", (Object)2)});
        List<String> allTopics = Arrays.asList("t1", "t2", "t3");
        List<List<String>> consumerTopics = Arrays.asList(allTopics, allTopics, Arrays.asList("t1", "t3"));
        List<String> nonRackAwareAssignment = Arrays.asList("t1-5, t2-0, t2-2, t2-4, t2-6", "t1-3, t2-1, t2-3, t2-5, t3-0", "t1-0, t1-1, t1-2, t1-4, t3-1");
        this.verifyNonEqualSubscription(this.assignor, topics, 3, AbstractPartitionAssignorTest.nullRacks(3), AbstractPartitionAssignorTest.racks(3), consumerTopics, nonRackAwareAssignment, -1);
        this.verifyNonEqualSubscription(this.assignor, topics, 3, AbstractPartitionAssignorTest.racks(3), AbstractPartitionAssignorTest.nullRacks(3), consumerTopics, nonRackAwareAssignment, -1);
        AbstractPartitionAssignorTest.preferRackAwareLogic((AbstractPartitionAssignor)this.assignor, true);
        this.verifyNonEqualSubscription(this.assignor, topics, 3, AbstractPartitionAssignorTest.racks(3), AbstractPartitionAssignorTest.racks(3), consumerTopics, nonRackAwareAssignment, 0);
        AbstractPartitionAssignorTest.preferRackAwareLogic((AbstractPartitionAssignor)this.assignor, true);
        this.verifyNonEqualSubscription(this.assignor, topics, 4, AbstractPartitionAssignorTest.racks(4), AbstractPartitionAssignorTest.racks(3), consumerTopics, nonRackAwareAssignment, 0);
        AbstractPartitionAssignorTest.preferRackAwareLogic((AbstractPartitionAssignor)this.assignor, false);
        this.verifyNonEqualSubscription(this.assignor, topics, 3, AbstractPartitionAssignorTest.racks(3), AbstractPartitionAssignorTest.racks(3), consumerTopics, nonRackAwareAssignment, 0);
        this.verifyNonEqualSubscription(this.assignor, topics, 3, AbstractPartitionAssignorTest.racks(3), Arrays.asList("d", "e", "f"), consumerTopics, nonRackAwareAssignment, -1);
        this.verifyNonEqualSubscription(this.assignor, topics, 3, AbstractPartitionAssignorTest.racks(3), Arrays.asList(null, "e", "f"), consumerTopics, nonRackAwareAssignment, -1);
        List<String> assignment = Arrays.asList("t1-3, t2-0, t2-2, t2-3, t2-6", "t1-4, t2-1, t2-4, t2-5, t3-0", "t1-0, t1-1, t1-2, t1-5, t3-1");
        this.verifyNonEqualSubscription(this.assignor, topics, 1, AbstractPartitionAssignorTest.racks(3), AbstractPartitionAssignorTest.racks(3), consumerTopics, assignment, 4);
        assignment = Arrays.asList("t1-3, t2-0, t2-2, t2-5, t2-6", "t1-0, t2-1, t2-3, t2-4, t3-0", "t1-1, t1-2, t1-4, t1-5, t3-1");
        this.verifyNonEqualSubscription(this.assignor, topics, 2, AbstractPartitionAssignorTest.racks(3), AbstractPartitionAssignorTest.racks(3), consumerTopics, assignment, 0);
        this.verifyNonEqualSubscription(this.assignor, topics, 3, AbstractPartitionAssignorTest.racks(2), AbstractPartitionAssignorTest.racks(3), consumerTopics, Arrays.asList("t1-5, t2-0, t2-2, t2-4, t2-6", "t1-3, t2-1, t2-3, t2-5, t3-0", "t1-0, t1-1, t1-2, t1-4, t3-1"), 5);
        List<String> owned = Arrays.asList("t1-0, t1-1, t1-2, t1-3, t1-4", "t1-5, t2-0, t2-1, t2-2, t2-3", "t2-4, t2-5, t2-6, t3-0, t3-1");
        if (this.assignor instanceof StickyAssignor) {
            assignment = Arrays.asList("t1-3, t2-0, t2-2, t2-3, t2-6", "t1-4, t2-1, t2-4, t2-5, t3-0", "t1-0, t1-1, t1-2, t1-5, t3-1");
            AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)this.assignor, topics, 1, AbstractPartitionAssignorTest.racks(3), AbstractPartitionAssignorTest.racks(3), consumerTopics, owned, assignment, 4);
        } else {
            intermediate = Arrays.asList("t1-3", "t2-1", "t3-1");
            AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)this.assignor, topics, 1, AbstractPartitionAssignorTest.racks(3), AbstractPartitionAssignorTest.racks(3), consumerTopics, owned, intermediate, 0);
            assignment = Arrays.asList("t1-3, t2-0, t2-2, t2-3, t2-6", "t1-4, t2-1, t2-4, t2-5, t3-0", "t1-0, t1-1, t1-2, t1-5, t3-1");
            AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)this.assignor, topics, 1, AbstractPartitionAssignorTest.racks(3), AbstractPartitionAssignorTest.racks(3), consumerTopics, intermediate, assignment, 4);
        }
        if (this.assignor instanceof StickyAssignor) {
            assignment = Arrays.asList("t1-5, t2-0, t2-2, t2-4, t2-6", "t1-3, t2-1, t2-3, t2-5, t3-0", "t1-0, t1-1, t1-2, t1-4, t3-1");
            AbstractPartitionAssignorTest.preferRackAwareLogic((AbstractPartitionAssignor)this.assignor, false);
            AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)this.assignor, topics, 3, AbstractPartitionAssignorTest.racks(3), AbstractPartitionAssignorTest.racks(3), consumerTopics, owned, assignment, 0);
            AbstractPartitionAssignorTest.preferRackAwareLogic((AbstractPartitionAssignor)this.assignor, true);
            AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)this.assignor, topics, 3, AbstractPartitionAssignorTest.racks(3), AbstractPartitionAssignorTest.racks(3), consumerTopics, owned, assignment, 0);
        } else {
            assignment = Arrays.asList("t1-2, t1-3, t1-4, t2-4, t2-5", "t2-0, t2-1, t2-2, t2-3, t2-6", "t1-0, t1-1, t1-5, t3-0, t3-1");
            intermediate = Arrays.asList("t1-2, t1-3, t1-4", "t2-0, t2-1, t2-2, t2-3", "t3-0, t3-1");
            AbstractPartitionAssignorTest.preferRackAwareLogic((AbstractPartitionAssignor)this.assignor, false);
            AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)this.assignor, topics, 3, AbstractPartitionAssignorTest.racks(3), AbstractPartitionAssignorTest.racks(3), consumerTopics, owned, intermediate, 0);
            AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)this.assignor, topics, 3, AbstractPartitionAssignorTest.racks(3), AbstractPartitionAssignorTest.racks(3), consumerTopics, intermediate, assignment, 0);
            AbstractPartitionAssignorTest.preferRackAwareLogic((AbstractPartitionAssignor)this.assignor, true);
            AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)this.assignor, topics, 3, AbstractPartitionAssignorTest.racks(3), AbstractPartitionAssignorTest.racks(3), consumerTopics, owned, intermediate, 0);
            AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)this.assignor, topics, 3, AbstractPartitionAssignorTest.racks(3), AbstractPartitionAssignorTest.racks(3), consumerTopics, intermediate, assignment, 0);
        }
    }

    private void verifyNonEqualSubscription(AbstractStickyAssignor assignor, Map<String, Integer> numPartitionsPerTopic, int replicationFactor, List<String> brokerRacks, List<String> consumerRacks, List<List<String>> consumerTopics, List<String> expectedAssignments, int numPartitionsWithRackMismatch) {
        AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)assignor, numPartitionsPerTopic, replicationFactor, brokerRacks, consumerRacks, consumerTopics, null, expectedAssignments, numPartitionsWithRackMismatch);
        AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)assignor, numPartitionsPerTopic, replicationFactor, brokerRacks, consumerRacks, consumerTopics, expectedAssignments, expectedAssignments, numPartitionsWithRackMismatch);
    }

    private String getTopicName(int i, int maxNum) {
        return this.getCanonicalName("t", i, maxNum);
    }

    private String getConsumerName(int i, int maxNum) {
        return this.getCanonicalName("c", i, maxNum);
    }

    private String getCanonicalName(String str, int i, int maxNum) {
        return str + this.pad(i, Integer.toString(maxNum).length());
    }

    private String pad(int num, int digits) {
        StringBuilder sb = new StringBuilder();
        int iDigits = Integer.toString(num).length();
        for (int i = 1; i <= digits - iDigits; ++i) {
            sb.append("0");
        }
        sb.append(num);
        return sb.toString();
    }

    protected static List<String> topics(String ... topics) {
        return Arrays.asList(topics);
    }

    protected static List<TopicPartition> partitions(TopicPartition ... partitions) {
        return Arrays.asList(partitions);
    }

    protected static TopicPartition tp(String topic, int partition) {
        return new TopicPartition(topic, partition);
    }

    protected Optional<String> consumerRackId(int consumerIndex) {
        int numRacks = this.numBrokerRacks > 0 ? this.numBrokerRacks : AbstractPartitionAssignorTest.ALL_RACKS.length;
        return Optional.ofNullable(this.hasConsumerRack ? AbstractPartitionAssignorTest.ALL_RACKS[consumerIndex % numRacks] : null);
    }

    protected ConsumerPartitionAssignor.Subscription subscription(List<String> topics, int consumerIndex) {
        return new ConsumerPartitionAssignor.Subscription(topics, null, Collections.emptyList(), -1, this.consumerRackId(consumerIndex));
    }

    protected static boolean isFullyBalanced(Map<String, List<TopicPartition>> assignment) {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (List<TopicPartition> topicPartitions : assignment.values()) {
            int size = topicPartitions.size();
            if (size < min) {
                min = size;
            }
            if (size <= max) continue;
            max = size;
        }
        return max - min <= 1;
    }

    protected static List<String> getRandomSublist(ArrayList<String> list) {
        ArrayList<String> selectedItems = new ArrayList<String>(list);
        int len = list.size();
        Random random = new Random();
        int howManyToRemove = random.nextInt(len);
        for (int i = 1; i <= howManyToRemove; ++i) {
            selectedItems.remove(random.nextInt(selectedItems.size()));
        }
        return selectedItems;
    }

    protected void verifyValidityAndBalance(Map<String, ConsumerPartitionAssignor.Subscription> subscriptions, Map<String, List<TopicPartition>> assignments, Map<String, List<PartitionInfo>> partitionsPerTopic) {
        int size = subscriptions.size();
        assert (size == assignments.size());
        List consumers = Utils.sorted(assignments.keySet());
        for (int i = 0; i < size; ++i) {
            String consumer = (String)consumers.get(i);
            List<TopicPartition> partitions = assignments.get(consumer);
            for (TopicPartition partition : partitions) {
                Assertions.assertTrue((boolean)subscriptions.get(consumer).topics().contains(partition.topic()), (String)("Error: Partition " + partition + "is assigned to c" + i + ", but it is not subscribed to Topic t" + partition.topic() + "\nSubscriptions: " + subscriptions + "\nAssignments: " + assignments));
            }
            if (i == size - 1) continue;
            for (int j = i + 1; j < size; ++j) {
                String otherConsumer = (String)consumers.get(j);
                List<TopicPartition> otherPartitions = assignments.get(otherConsumer);
                HashSet<TopicPartition> intersection = new HashSet<TopicPartition>(partitions);
                intersection.retainAll(otherPartitions);
                Assertions.assertTrue((boolean)intersection.isEmpty(), (String)("Error: Consumers c" + i + " and c" + j + " have common partitions assigned to them: " + intersection + "\nSubscriptions: " + subscriptions + "\nAssignments: " + assignments));
                int len = partitions.size();
                int otherLen = otherPartitions.size();
                if (Math.abs(len - otherLen) <= 1) continue;
                Map map = CollectionUtils.groupPartitionsByTopic(partitions);
                Map otherMap = CollectionUtils.groupPartitionsByTopic(otherPartitions);
                int moreLoaded = len > otherLen ? i : j;
                int lessLoaded = len > otherLen ? j : i;
                for (String topic : map.keySet()) {
                    Assertions.assertFalse((boolean)otherMap.containsKey(topic), (String)("Error: Some partitions can be moved from c" + moreLoaded + " to c" + lessLoaded + " to achieve a better balance\nc" + i + " has " + len + " partitions, and c" + j + " has " + otherLen + " partitions.\nSubscriptions: " + subscriptions + "\nAssignments: " + assignments));
                }
            }
        }
    }

    protected AbstractStickyAssignor.MemberData memberData(ConsumerPartitionAssignor.Subscription subscription) {
        return this.assignor.memberData(subscription);
    }

    protected List<PartitionInfo> partitionInfos(String topic, int numberOfPartitions) {
        int nextIndex = this.nextPartitionIndex++;
        return AbstractPartitionAssignorTest.partitionInfos(topic, numberOfPartitions, this.replicationFactor, this.numBrokerRacks, nextIndex);
    }

    protected void initializeRacks(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        this.replicationFactor = 3;
        this.numBrokerRacks = rackConfig != AbstractPartitionAssignorTest.RackConfig.NO_BROKER_RACK ? 3 : 0;
        this.hasConsumerRack = rackConfig != AbstractPartitionAssignorTest.RackConfig.NO_CONSUMER_RACK;
        AbstractPartitionAssignorTest.preferRackAwareLogic((AbstractPartitionAssignor)this.assignor, true);
    }
}

