/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer.internals;

import java.util.ArrayList;
import java.util.Map;
import org.apache.kafka.clients.producer.ProducerInterceptor;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.clients.producer.internals.ProducerInterceptors;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.junit.Assert;
import org.junit.Test;

public class ProducerInterceptorsTest {
    private final TopicPartition tp = new TopicPartition("test", 0);
    private final ProducerRecord<Integer, String> producerRecord = new ProducerRecord("test", Integer.valueOf(0), (Object)1, (Object)"value");
    private int onAckCount = 0;
    private int onErrorAckCount = 0;
    private int onErrorAckWithTopicSetCount = 0;
    private int onErrorAckWithTopicPartitionSetCount = 0;
    private int onSendCount = 0;

    @Test
    public void testOnSendChain() {
        ArrayList<AppendProducerInterceptor> interceptorList = new ArrayList<AppendProducerInterceptor>();
        AppendProducerInterceptor interceptor1 = new AppendProducerInterceptor("One");
        AppendProducerInterceptor interceptor2 = new AppendProducerInterceptor("Two");
        interceptorList.add(interceptor1);
        interceptorList.add(interceptor2);
        ProducerInterceptors interceptors = new ProducerInterceptors(interceptorList);
        ProducerRecord interceptedRecord = interceptors.onSend(this.producerRecord);
        Assert.assertEquals((long)2L, (long)this.onSendCount);
        Assert.assertEquals((Object)this.producerRecord.topic(), (Object)interceptedRecord.topic());
        Assert.assertEquals((Object)this.producerRecord.partition(), (Object)interceptedRecord.partition());
        Assert.assertEquals((Object)this.producerRecord.key(), (Object)interceptedRecord.key());
        Assert.assertEquals((Object)interceptedRecord.value(), (Object)((String)this.producerRecord.value()).concat("One").concat("Two"));
        ProducerRecord anotherRecord = interceptors.onSend(this.producerRecord);
        Assert.assertEquals((long)4L, (long)this.onSendCount);
        Assert.assertEquals((Object)interceptedRecord, (Object)anotherRecord);
        interceptor1.injectOnSendError(true);
        ProducerRecord partInterceptRecord = interceptors.onSend(this.producerRecord);
        Assert.assertEquals((long)6L, (long)this.onSendCount);
        Assert.assertEquals((Object)partInterceptRecord.value(), (Object)((String)this.producerRecord.value()).concat("Two"));
        interceptor2.injectOnSendError(true);
        ProducerRecord noInterceptRecord = interceptors.onSend(this.producerRecord);
        Assert.assertEquals(this.producerRecord, (Object)noInterceptRecord);
        interceptors.close();
    }

    @Test
    public void testOnAcknowledgementChain() {
        ArrayList<AppendProducerInterceptor> interceptorList = new ArrayList<AppendProducerInterceptor>();
        AppendProducerInterceptor interceptor1 = new AppendProducerInterceptor("One");
        AppendProducerInterceptor interceptor2 = new AppendProducerInterceptor("Two");
        interceptorList.add(interceptor1);
        interceptorList.add(interceptor2);
        ProducerInterceptors interceptors = new ProducerInterceptors(interceptorList);
        RecordMetadata meta = new RecordMetadata(this.tp, 0L, 0L, 0L, Long.valueOf(0L), 0, 0);
        interceptors.onAcknowledgement(meta, null);
        Assert.assertEquals((long)2L, (long)this.onAckCount);
        interceptor1.injectOnAcknowledgementError(true);
        interceptors.onAcknowledgement(meta, null);
        Assert.assertEquals((long)4L, (long)this.onAckCount);
        interceptor2.injectOnAcknowledgementError(true);
        interceptors.onAcknowledgement(meta, null);
        Assert.assertEquals((long)6L, (long)this.onAckCount);
        interceptors.close();
    }

    @Test
    public void testOnAcknowledgementWithErrorChain() {
        ArrayList<AppendProducerInterceptor> interceptorList = new ArrayList<AppendProducerInterceptor>();
        AppendProducerInterceptor interceptor1 = new AppendProducerInterceptor("One");
        interceptorList.add(interceptor1);
        ProducerInterceptors interceptors = new ProducerInterceptors(interceptorList);
        interceptors.onSendError(this.producerRecord, new TopicPartition(this.producerRecord.topic(), this.producerRecord.partition().intValue()), (Exception)((Object)new KafkaException("Test")));
        Assert.assertEquals((long)1L, (long)this.onErrorAckCount);
        Assert.assertEquals((long)1L, (long)this.onErrorAckWithTopicPartitionSetCount);
        interceptors.onSendError(this.producerRecord, null, (Exception)((Object)new KafkaException("Test")));
        Assert.assertEquals((long)2L, (long)this.onErrorAckCount);
        Assert.assertEquals((long)2L, (long)this.onErrorAckWithTopicPartitionSetCount);
        ProducerRecord record2 = new ProducerRecord("test2", null, (Object)1, (Object)"value");
        interceptors.onSendError(record2, null, (Exception)((Object)new KafkaException("Test")));
        Assert.assertEquals((long)3L, (long)this.onErrorAckCount);
        Assert.assertEquals((long)3L, (long)this.onErrorAckWithTopicSetCount);
        Assert.assertEquals((long)2L, (long)this.onErrorAckWithTopicPartitionSetCount);
        int reassignedPartition = this.producerRecord.partition() + 1;
        interceptors.onSendError(record2, new TopicPartition(record2.topic(), reassignedPartition), (Exception)((Object)new KafkaException("Test")));
        Assert.assertEquals((long)4L, (long)this.onErrorAckCount);
        Assert.assertEquals((long)4L, (long)this.onErrorAckWithTopicSetCount);
        Assert.assertEquals((long)3L, (long)this.onErrorAckWithTopicPartitionSetCount);
        interceptors.onSendError(null, null, (Exception)((Object)new KafkaException("Test")));
        Assert.assertEquals((long)5L, (long)this.onErrorAckCount);
        Assert.assertEquals((long)4L, (long)this.onErrorAckWithTopicSetCount);
        Assert.assertEquals((long)3L, (long)this.onErrorAckWithTopicPartitionSetCount);
        interceptors.close();
    }

    private class AppendProducerInterceptor
    implements ProducerInterceptor<Integer, String> {
        private String appendStr = "";
        private boolean throwExceptionOnSend = false;
        private boolean throwExceptionOnAck = false;

        public AppendProducerInterceptor(String appendStr) {
            this.appendStr = appendStr;
        }

        public void configure(Map<String, ?> configs) {
        }

        public ProducerRecord<Integer, String> onSend(ProducerRecord<Integer, String> record) {
            ProducerInterceptorsTest.this.onSendCount++;
            if (this.throwExceptionOnSend) {
                throw new KafkaException("Injected exception in AppendProducerInterceptor.onSend");
            }
            return new ProducerRecord(record.topic(), record.partition(), (Object)((Integer)record.key()), (Object)((String)record.value()).concat(this.appendStr));
        }

        public void onAcknowledgement(RecordMetadata metadata, Exception exception) {
            ProducerInterceptorsTest.this.onAckCount++;
            if (exception != null) {
                ProducerInterceptorsTest.this.onErrorAckCount++;
                if (metadata != null && metadata.topic().length() >= 0) {
                    ProducerInterceptorsTest.this.onErrorAckWithTopicSetCount++;
                    if (metadata.partition() >= 0) {
                        ProducerInterceptorsTest.this.onErrorAckWithTopicPartitionSetCount++;
                    }
                }
            }
            if (this.throwExceptionOnAck) {
                throw new KafkaException("Injected exception in AppendProducerInterceptor.onAcknowledgement");
            }
        }

        public void close() {
        }

        public void injectOnSendError(boolean on) {
            this.throwExceptionOnSend = on;
        }

        public void injectOnAcknowledgementError(boolean on) {
            this.throwExceptionOnAck = on;
        }
    }
}

