/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.message;

import java.io.StringWriter;
import java.io.Writer;
import org.apache.kafka.message.CodeBuffer;
import org.apache.kafka.message.VersionConditional;
import org.apache.kafka.message.Versions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=120L)
public class VersionConditionalTest {
    static void claimEquals(CodeBuffer buffer, String ... lines) throws Exception {
        StringWriter stringWriter = new StringWriter();
        buffer.write((Writer)stringWriter);
        StringBuilder expectedStringBuilder = new StringBuilder();
        for (String line : lines) {
            expectedStringBuilder.append(String.format(line, new Object[0]));
        }
        Assertions.assertEquals((Object)stringWriter.toString(), (Object)expectedStringBuilder.toString());
    }

    @Test
    public void testAlwaysFalseConditional() throws Exception {
        CodeBuffer buffer = new CodeBuffer();
        VersionConditional.forVersions((Versions)Versions.parse((String)"1-2", null), (Versions)Versions.parse((String)"3+", null)).ifMember(__ -> buffer.printf("System.out.println(\"hello world\");%n", new Object[0])).ifNotMember(__ -> buffer.printf("System.out.println(\"foobar\");%n", new Object[0])).generate(buffer);
        VersionConditionalTest.claimEquals(buffer, "System.out.println(\"foobar\");%n");
    }

    @Test
    public void testAnotherAlwaysFalseConditional() throws Exception {
        CodeBuffer buffer = new CodeBuffer();
        VersionConditional.forVersions((Versions)Versions.parse((String)"3+", null), (Versions)Versions.parse((String)"1-2", null)).ifMember(__ -> buffer.printf("System.out.println(\"hello world\");%n", new Object[0])).ifNotMember(__ -> buffer.printf("System.out.println(\"foobar\");%n", new Object[0])).generate(buffer);
        VersionConditionalTest.claimEquals(buffer, "System.out.println(\"foobar\");%n");
    }

    @Test
    public void testAllowMembershipCheckAlwaysFalseFails() throws Exception {
        try {
            CodeBuffer buffer = new CodeBuffer();
            VersionConditional.forVersions((Versions)Versions.parse((String)"1-2", null), (Versions)Versions.parse((String)"3+", null)).ifMember(__ -> buffer.printf("System.out.println(\"hello world\");%n", new Object[0])).ifNotMember(__ -> buffer.printf("System.out.println(\"foobar\");%n", new Object[0])).allowMembershipCheckAlwaysFalse(false).generate(buffer);
        }
        catch (RuntimeException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("no versions in common"));
        }
    }

    @Test
    public void testAlwaysTrueConditional() throws Exception {
        CodeBuffer buffer = new CodeBuffer();
        VersionConditional.forVersions((Versions)Versions.parse((String)"1-5", null), (Versions)Versions.parse((String)"2-4", null)).ifMember(__ -> buffer.printf("System.out.println(\"hello world\");%n", new Object[0])).ifNotMember(__ -> buffer.printf("System.out.println(\"foobar\");%n", new Object[0])).allowMembershipCheckAlwaysFalse(false).generate(buffer);
        VersionConditionalTest.claimEquals(buffer, "System.out.println(\"hello world\");%n");
    }

    @Test
    public void testAlwaysTrueConditionalWithAlwaysEmitBlockScope() throws Exception {
        CodeBuffer buffer = new CodeBuffer();
        VersionConditional.forVersions((Versions)Versions.parse((String)"1-5", null), (Versions)Versions.parse((String)"2-4", null)).ifMember(__ -> buffer.printf("System.out.println(\"hello world\");%n", new Object[0])).ifNotMember(__ -> buffer.printf("System.out.println(\"foobar\");%n", new Object[0])).alwaysEmitBlockScope(true).generate(buffer);
        VersionConditionalTest.claimEquals(buffer, "{%n", "    System.out.println(\"hello world\");%n", "}%n");
    }

    @Test
    public void testLowerRangeCheckWithElse() throws Exception {
        CodeBuffer buffer = new CodeBuffer();
        VersionConditional.forVersions((Versions)Versions.parse((String)"1+", null), (Versions)Versions.parse((String)"0-100", null)).ifMember(__ -> buffer.printf("System.out.println(\"hello world\");%n", new Object[0])).ifNotMember(__ -> buffer.printf("System.out.println(\"foobar\");%n", new Object[0])).generate(buffer);
        VersionConditionalTest.claimEquals(buffer, "if (_version >= 1) {%n", "    System.out.println(\"hello world\");%n", "} else {%n", "    System.out.println(\"foobar\");%n", "}%n");
    }

    @Test
    public void testLowerRangeCheckWithIfMember() throws Exception {
        CodeBuffer buffer = new CodeBuffer();
        VersionConditional.forVersions((Versions)Versions.parse((String)"1+", null), (Versions)Versions.parse((String)"0-100", null)).ifMember(__ -> buffer.printf("System.out.println(\"hello world\");%n", new Object[0])).generate(buffer);
        VersionConditionalTest.claimEquals(buffer, "if (_version >= 1) {%n", "    System.out.println(\"hello world\");%n", "}%n");
    }

    @Test
    public void testLowerRangeCheckWithIfNotMember() throws Exception {
        CodeBuffer buffer = new CodeBuffer();
        VersionConditional.forVersions((Versions)Versions.parse((String)"1+", null), (Versions)Versions.parse((String)"0-100", null)).ifNotMember(__ -> buffer.printf("System.out.println(\"hello world\");%n", new Object[0])).generate(buffer);
        VersionConditionalTest.claimEquals(buffer, "if (_version < 1) {%n", "    System.out.println(\"hello world\");%n", "}%n");
    }

    @Test
    public void testUpperRangeCheckWithElse() throws Exception {
        CodeBuffer buffer = new CodeBuffer();
        VersionConditional.forVersions((Versions)Versions.parse((String)"0-10", null), (Versions)Versions.parse((String)"4+", null)).ifMember(__ -> buffer.printf("System.out.println(\"hello world\");%n", new Object[0])).ifNotMember(__ -> buffer.printf("System.out.println(\"foobar\");%n", new Object[0])).generate(buffer);
        VersionConditionalTest.claimEquals(buffer, "if (_version <= 10) {%n", "    System.out.println(\"hello world\");%n", "} else {%n", "    System.out.println(\"foobar\");%n", "}%n");
    }

    @Test
    public void testUpperRangeCheckWithIfMember() throws Exception {
        CodeBuffer buffer = new CodeBuffer();
        VersionConditional.forVersions((Versions)Versions.parse((String)"0-10", null), (Versions)Versions.parse((String)"4+", null)).ifMember(__ -> buffer.printf("System.out.println(\"hello world\");%n", new Object[0])).generate(buffer);
        VersionConditionalTest.claimEquals(buffer, "if (_version <= 10) {%n", "    System.out.println(\"hello world\");%n", "}%n");
    }

    @Test
    public void testUpperRangeCheckWithIfNotMember() throws Exception {
        CodeBuffer buffer = new CodeBuffer();
        VersionConditional.forVersions((Versions)Versions.parse((String)"1+", null), (Versions)Versions.parse((String)"0-100", null)).ifNotMember(__ -> buffer.printf("System.out.println(\"hello world\");%n", new Object[0])).generate(buffer);
        VersionConditionalTest.claimEquals(buffer, "if (_version < 1) {%n", "    System.out.println(\"hello world\");%n", "}%n");
    }

    @Test
    public void testFullRangeCheck() throws Exception {
        CodeBuffer buffer = new CodeBuffer();
        VersionConditional.forVersions((Versions)Versions.parse((String)"5-10", null), (Versions)Versions.parse((String)"1+", null)).ifMember(__ -> buffer.printf("System.out.println(\"hello world\");%n", new Object[0])).allowMembershipCheckAlwaysFalse(false).generate(buffer);
        VersionConditionalTest.claimEquals(buffer, "if ((_version >= 5) && (_version <= 10)) {%n", "    System.out.println(\"hello world\");%n", "}%n");
    }
}

