/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.message;

import org.apache.kafka.message.EntityType;
import org.apache.kafka.message.FieldType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=120L)
public class EntityTypeTest {
    @Test
    public void testUnknownEntityType() {
        for (FieldType type : new FieldType[]{FieldType.StringFieldType.INSTANCE, FieldType.Int8FieldType.INSTANCE, FieldType.Int16FieldType.INSTANCE, FieldType.Int32FieldType.INSTANCE, FieldType.Int64FieldType.INSTANCE, new FieldType.ArrayType((FieldType)FieldType.StringFieldType.INSTANCE)}) {
            EntityType.UNKNOWN.verifyTypeMatches("unknown", type);
        }
    }

    @Test
    public void testVerifyTypeMatches() {
        EntityType.TRANSACTIONAL_ID.verifyTypeMatches("transactionalIdField", (FieldType)FieldType.StringFieldType.INSTANCE);
        EntityType.TRANSACTIONAL_ID.verifyTypeMatches("transactionalIdField", (FieldType)new FieldType.ArrayType((FieldType)FieldType.StringFieldType.INSTANCE));
        EntityType.PRODUCER_ID.verifyTypeMatches("producerIdField", (FieldType)FieldType.Int64FieldType.INSTANCE);
        EntityType.PRODUCER_ID.verifyTypeMatches("producerIdField", (FieldType)new FieldType.ArrayType((FieldType)FieldType.Int64FieldType.INSTANCE));
        EntityType.GROUP_ID.verifyTypeMatches("groupIdField", (FieldType)FieldType.StringFieldType.INSTANCE);
        EntityType.GROUP_ID.verifyTypeMatches("groupIdField", (FieldType)new FieldType.ArrayType((FieldType)FieldType.StringFieldType.INSTANCE));
        EntityType.TOPIC_NAME.verifyTypeMatches("topicNameField", (FieldType)FieldType.StringFieldType.INSTANCE);
        EntityType.TOPIC_NAME.verifyTypeMatches("topicNameField", (FieldType)new FieldType.ArrayType((FieldType)FieldType.StringFieldType.INSTANCE));
        EntityType.BROKER_ID.verifyTypeMatches("brokerIdField", (FieldType)FieldType.Int32FieldType.INSTANCE);
        EntityType.BROKER_ID.verifyTypeMatches("brokerIdField", (FieldType)new FieldType.ArrayType((FieldType)FieldType.Int32FieldType.INSTANCE));
    }

    private static void expectException(Runnable r) {
        Assertions.assertThrows(RuntimeException.class, r::run);
    }

    @Test
    public void testVerifyTypeMismatches() {
        EntityTypeTest.expectException(() -> EntityType.TRANSACTIONAL_ID.verifyTypeMatches("transactionalIdField", (FieldType)FieldType.Int32FieldType.INSTANCE));
        EntityTypeTest.expectException(() -> EntityType.PRODUCER_ID.verifyTypeMatches("producerIdField", (FieldType)FieldType.StringFieldType.INSTANCE));
        EntityTypeTest.expectException(() -> EntityType.GROUP_ID.verifyTypeMatches("groupIdField", (FieldType)FieldType.Int8FieldType.INSTANCE));
        EntityTypeTest.expectException(() -> EntityType.TOPIC_NAME.verifyTypeMatches("topicNameField", (FieldType)new FieldType.ArrayType((FieldType)FieldType.Int64FieldType.INSTANCE)));
        EntityTypeTest.expectException(() -> EntityType.BROKER_ID.verifyTypeMatches("brokerIdField", (FieldType)FieldType.Int64FieldType.INSTANCE));
    }
}

