/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.message;

import java.io.BufferedWriter;
import java.util.Iterator;
import org.apache.kafka.message.CodeBuffer;
import org.apache.kafka.message.FieldSpec;
import org.apache.kafka.message.FieldType;
import org.apache.kafka.message.HeaderGenerator;
import org.apache.kafka.message.IsNullConditional;
import org.apache.kafka.message.MessageClassGenerator;
import org.apache.kafka.message.MessageGenerator;
import org.apache.kafka.message.MessageSpec;
import org.apache.kafka.message.StructRegistry;
import org.apache.kafka.message.StructSpec;
import org.apache.kafka.message.Target;
import org.apache.kafka.message.VersionConditional;
import org.apache.kafka.message.Versions;

public final class JsonConverterGenerator
implements MessageClassGenerator {
    private static final String SUFFIX = "JsonConverter";
    private final String packageName;
    private final StructRegistry structRegistry;
    private final HeaderGenerator headerGenerator;
    private final CodeBuffer buffer;

    JsonConverterGenerator(String packageName) {
        this.packageName = packageName;
        this.structRegistry = new StructRegistry();
        this.headerGenerator = new HeaderGenerator(packageName);
        this.buffer = new CodeBuffer();
    }

    @Override
    public String outputName(MessageSpec spec) {
        return spec.dataClassName() + SUFFIX;
    }

    @Override
    public void generateAndWrite(MessageSpec message, BufferedWriter writer) throws Exception {
        this.structRegistry.register(message);
        this.headerGenerator.addStaticImport(String.format("%s.%s.*", this.packageName, message.dataClassName()));
        this.buffer.printf("public class %s {%n", MessageGenerator.capitalizeFirst(this.outputName(message)));
        this.buffer.incrementIndent();
        this.generateConverters(message.dataClassName(), message.struct(), message.validVersions());
        Iterator<StructRegistry.StructInfo> iter = this.structRegistry.structs();
        while (iter.hasNext()) {
            StructRegistry.StructInfo info = iter.next();
            this.buffer.printf("%n", new Object[0]);
            this.buffer.printf("public static class %s {%n", MessageGenerator.capitalizeFirst(info.spec().name() + SUFFIX));
            this.buffer.incrementIndent();
            this.generateConverters(MessageGenerator.capitalizeFirst(info.spec().name()), info.spec(), info.parentVersions());
            this.buffer.decrementIndent();
            this.buffer.printf("}%n", new Object[0]);
        }
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
        this.headerGenerator.generate();
        this.headerGenerator.buffer().write(writer);
        this.buffer.write(writer);
    }

    private void generateConverters(String name, StructSpec spec, Versions parentVersions) {
        this.generateRead(name, spec, parentVersions);
        this.generateWrite(name, spec, parentVersions);
        this.generateOverloadWrite(name);
    }

    private void generateRead(String className, StructSpec struct, Versions parentVersions) {
        this.headerGenerator.addImport("com.fasterxml.jackson.databind.JsonNode");
        this.buffer.printf("public static %s read(JsonNode _node, short _version) {%n", className);
        this.buffer.incrementIndent();
        this.buffer.printf("%s _object = new %s();%n", className, className);
        VersionConditional.forVersions(struct.versions(), parentVersions).allowMembershipCheckAlwaysFalse(false).ifNotMember(__ -> {
            this.headerGenerator.addImport("org.apache.kafka.common.errors.UnsupportedVersionException");
            this.buffer.printf("throw new UnsupportedVersionException(\"Can't read version \" + _version + \" of %s\");%n", className);
        }).generate(this.buffer);
        Versions curVersions = parentVersions.intersect(struct.versions());
        for (FieldSpec field : struct.fields()) {
            String sourceVariable = String.format("_%sNode", field.camelCaseName());
            this.buffer.printf("JsonNode %s = _node.get(\"%s\");%n", sourceVariable, field.camelCaseName());
            this.buffer.printf("if (%s == null) {%n", sourceVariable);
            this.buffer.incrementIndent();
            Versions mandatoryVersions = field.versions().subtract(field.taggedVersions());
            VersionConditional.forVersions(mandatoryVersions, curVersions).ifMember(__ -> this.buffer.printf("throw new RuntimeException(\"%s: unable to locate field '%s', which is mandatory in version \" + _version);%n", className, field.camelCaseName())).ifNotMember(__ -> this.buffer.printf("_object.%s = %s;%n", field.camelCaseName(), field.fieldDefault(this.headerGenerator, this.structRegistry))).generate(this.buffer);
            this.buffer.decrementIndent();
            this.buffer.printf("} else {%n", new Object[0]);
            this.buffer.incrementIndent();
            VersionConditional.forVersions(struct.versions(), curVersions).ifMember(presentVersions -> this.generateTargetFromJson(new Target(field, sourceVariable, className, input -> String.format("_object.%s = %s", field.camelCaseName(), input)), curVersions)).ifNotMember(__ -> this.buffer.printf("throw new RuntimeException(\"%s: field '%s' is not supported in version \" + _version);%n", className, field.camelCaseName())).generate(this.buffer);
            this.buffer.decrementIndent();
            this.buffer.printf("}%n", new Object[0]);
        }
        this.buffer.printf("return _object;%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    private void generateTargetFromJson(Target target, Versions curVersions) {
        if (target.field().type() instanceof FieldType.BoolFieldType) {
            this.buffer.printf("if (!%s.isBoolean()) {%n", target.sourceVariable());
            this.buffer.incrementIndent();
            this.buffer.printf("throw new RuntimeException(\"%s expected Boolean type, but got \" + _node.getNodeType());%n", target.humanReadableName());
            this.buffer.decrementIndent();
            this.buffer.printf("}%n", new Object[0]);
            this.buffer.printf("%s;%n", target.assignmentStatement(target.sourceVariable() + ".asBoolean()"));
        } else if (target.field().type() instanceof FieldType.Int8FieldType) {
            this.headerGenerator.addImport("org.apache.kafka.common.protocol.MessageUtil");
            this.buffer.printf("%s;%n", target.assignmentStatement(String.format("MessageUtil.jsonNodeToByte(%s, \"%s\")", target.sourceVariable(), target.humanReadableName())));
        } else if (target.field().type() instanceof FieldType.Int16FieldType) {
            this.headerGenerator.addImport("org.apache.kafka.common.protocol.MessageUtil");
            this.buffer.printf("%s;%n", target.assignmentStatement(String.format("MessageUtil.jsonNodeToShort(%s, \"%s\")", target.sourceVariable(), target.humanReadableName())));
        } else if (target.field().type() instanceof FieldType.Uint16FieldType) {
            this.headerGenerator.addImport("org.apache.kafka.common.protocol.MessageUtil");
            this.buffer.printf("%s;%n", target.assignmentStatement(String.format("MessageUtil.jsonNodeToUnsignedShort(%s, \"%s\")", target.sourceVariable(), target.humanReadableName())));
        } else if (target.field().type() instanceof FieldType.Uint32FieldType) {
            this.headerGenerator.addImport("org.apache.kafka.common.protocol.MessageUtil");
            this.buffer.printf("%s;%n", target.assignmentStatement(String.format("MessageUtil.jsonNodeToUnsignedInt(%s, \"%s\")", target.sourceVariable(), target.humanReadableName())));
        } else if (target.field().type() instanceof FieldType.Int32FieldType) {
            this.headerGenerator.addImport("org.apache.kafka.common.protocol.MessageUtil");
            this.buffer.printf("%s;%n", target.assignmentStatement(String.format("MessageUtil.jsonNodeToInt(%s, \"%s\")", target.sourceVariable(), target.humanReadableName())));
        } else if (target.field().type() instanceof FieldType.Int64FieldType) {
            this.headerGenerator.addImport("org.apache.kafka.common.protocol.MessageUtil");
            this.buffer.printf("%s;%n", target.assignmentStatement(String.format("MessageUtil.jsonNodeToLong(%s, \"%s\")", target.sourceVariable(), target.humanReadableName())));
        } else if (target.field().type() instanceof FieldType.UUIDFieldType) {
            this.buffer.printf("if (!%s.isTextual()) {%n", target.sourceVariable());
            this.buffer.incrementIndent();
            this.buffer.printf("throw new RuntimeException(\"%s expected a JSON string type, but got \" + _node.getNodeType());%n", target.humanReadableName());
            this.buffer.decrementIndent();
            this.buffer.printf("}%n", new Object[0]);
            this.headerGenerator.addImport("org.apache.kafka.common.Uuid");
            this.buffer.printf("%s;%n", target.assignmentStatement(String.format("Uuid.fromString(%s.asText())", target.sourceVariable())));
        } else if (target.field().type() instanceof FieldType.Float64FieldType) {
            this.headerGenerator.addImport("org.apache.kafka.common.protocol.MessageUtil");
            this.buffer.printf("%s;%n", target.assignmentStatement(String.format("MessageUtil.jsonNodeToDouble(%s, \"%s\")", target.sourceVariable(), target.humanReadableName())));
        } else {
            IsNullConditional.forName(target.sourceVariable()).nullableVersions(target.field().nullableVersions()).possibleVersions(curVersions).conditionalGenerator((name, negated) -> String.format("%s%s.isNull()", negated ? "!" : "", name)).ifNull(() -> this.buffer.printf("%s;%n", target.assignmentStatement("null"))).ifShouldNotBeNull(() -> this.generateVariableLengthTargetFromJson(target, curVersions)).generate(this.buffer);
        }
    }

    private void generateVariableLengthTargetFromJson(Target target, Versions curVersions) {
        if (target.field().type().isString()) {
            this.buffer.printf("if (!%s.isTextual()) {%n", target.sourceVariable());
            this.buffer.incrementIndent();
            this.buffer.printf("throw new RuntimeException(\"%s expected a string type, but got \" + _node.getNodeType());%n", target.humanReadableName());
            this.buffer.decrementIndent();
            this.buffer.printf("}%n", new Object[0]);
            this.buffer.printf("%s;%n", target.assignmentStatement(String.format("%s.asText()", target.sourceVariable())));
        } else if (target.field().type().isBytes()) {
            this.headerGenerator.addImport("org.apache.kafka.common.protocol.MessageUtil");
            if (target.field().zeroCopy()) {
                this.headerGenerator.addImport("java.nio.ByteBuffer");
                this.buffer.printf("%s;%n", target.assignmentStatement(String.format("ByteBuffer.wrap(MessageUtil.jsonNodeToBinary(%s, \"%s\"))", target.sourceVariable(), target.humanReadableName())));
            } else {
                this.buffer.printf("%s;%n", target.assignmentStatement(String.format("MessageUtil.jsonNodeToBinary(%s, \"%s\")", target.sourceVariable(), target.humanReadableName())));
            }
        } else if (target.field().type().isRecords()) {
            this.headerGenerator.addImport("org.apache.kafka.common.protocol.MessageUtil");
            this.headerGenerator.addImport("java.nio.ByteBuffer");
            this.headerGenerator.addImport("org.apache.kafka.common.record.MemoryRecords");
            this.buffer.printf("%s;%n", target.assignmentStatement(String.format("MemoryRecords.readableRecords(ByteBuffer.wrap(MessageUtil.jsonNodeToBinary(%s, \"%s\")))", target.sourceVariable(), target.humanReadableName())));
        } else if (target.field().type().isArray()) {
            this.buffer.printf("if (!%s.isArray()) {%n", target.sourceVariable());
            this.buffer.incrementIndent();
            this.buffer.printf("throw new RuntimeException(\"%s expected a JSON array, but got \" + _node.getNodeType());%n", target.humanReadableName());
            this.buffer.decrementIndent();
            this.buffer.printf("}%n", new Object[0]);
            String type = target.field().concreteJavaType(this.headerGenerator, this.structRegistry);
            this.buffer.printf("%s _collection = new %s(%s.size());%n", type, type, target.sourceVariable());
            this.buffer.printf("%s;%n", target.assignmentStatement("_collection"));
            this.headerGenerator.addImport("com.fasterxml.jackson.databind.JsonNode");
            this.buffer.printf("for (JsonNode _element : %s) {%n", target.sourceVariable());
            this.buffer.incrementIndent();
            this.generateTargetFromJson(target.arrayElementTarget(input -> String.format("_collection.add(%s)", input)), curVersions);
            this.buffer.decrementIndent();
            this.buffer.printf("}%n", new Object[0]);
        } else if (target.field().type().isStruct()) {
            this.buffer.printf("%s;%n", target.assignmentStatement(String.format("%s%s.read(%s, _version)", target.field().type().toString(), SUFFIX, target.sourceVariable())));
        } else {
            throw new RuntimeException("Unexpected type " + target.field().type());
        }
    }

    private void generateOverloadWrite(String className) {
        this.buffer.printf("public static JsonNode write(%s _object, short _version) {%n", className);
        this.buffer.incrementIndent();
        this.buffer.printf("return write(_object, _version, true);%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    private void generateWrite(String className, StructSpec struct, Versions parentVersions) {
        this.headerGenerator.addImport("com.fasterxml.jackson.databind.JsonNode");
        this.buffer.printf("public static JsonNode write(%s _object, short _version, boolean _serializeRecords) {%n", className);
        this.buffer.incrementIndent();
        VersionConditional.forVersions(struct.versions(), parentVersions).allowMembershipCheckAlwaysFalse(false).ifNotMember(__ -> {
            this.headerGenerator.addImport("org.apache.kafka.common.errors.UnsupportedVersionException");
            this.buffer.printf("throw new UnsupportedVersionException(\"Can't write version \" + _version + \" of %s\");%n", className);
        }).generate(this.buffer);
        Versions curVersions = parentVersions.intersect(struct.versions());
        this.headerGenerator.addImport("com.fasterxml.jackson.databind.node.ObjectNode");
        this.headerGenerator.addImport("com.fasterxml.jackson.databind.node.JsonNodeFactory");
        this.buffer.printf("ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);%n", new Object[0]);
        for (FieldSpec field : struct.fields()) {
            Target target = new Target(field, String.format("_object.%s", field.camelCaseName()), field.camelCaseName(), input -> String.format("_node.set(\"%s\", %s)", field.camelCaseName(), input));
            VersionConditional cond = VersionConditional.forVersions(field.versions(), curVersions).ifMember(presentVersions -> VersionConditional.forVersions(field.taggedVersions(), presentVersions).ifMember(presentAndTaggedVersions -> {
                field.generateNonDefaultValueCheck(this.headerGenerator, this.structRegistry, this.buffer, "_object.", field.nullableVersions());
                this.buffer.incrementIndent();
                if (field.defaultString().equals("null")) {
                    this.generateTargetToJson(target.nonNullableCopy(), presentAndTaggedVersions);
                } else {
                    this.generateTargetToJson(target, presentAndTaggedVersions);
                }
                this.buffer.decrementIndent();
                this.buffer.printf("}%n", new Object[0]);
            }).ifNotMember(presentAndNotTaggedVersions -> this.generateTargetToJson(target, presentAndNotTaggedVersions)).generate(this.buffer));
            if (!field.ignorable()) {
                cond.ifNotMember(__ -> field.generateNonIgnorableFieldCheck(this.headerGenerator, this.structRegistry, "_object.", this.buffer));
            }
            cond.generate(this.buffer);
        }
        this.buffer.printf("return _node;%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    private void generateTargetToJson(Target target, Versions versions) {
        if (target.field().type() instanceof FieldType.BoolFieldType) {
            this.headerGenerator.addImport("com.fasterxml.jackson.databind.node.BooleanNode");
            this.buffer.printf("%s;%n", target.assignmentStatement(String.format("BooleanNode.valueOf(%s)", target.sourceVariable())));
        } else if (target.field().type() instanceof FieldType.Int8FieldType || target.field().type() instanceof FieldType.Int16FieldType) {
            this.headerGenerator.addImport("com.fasterxml.jackson.databind.node.ShortNode");
            this.buffer.printf("%s;%n", target.assignmentStatement(String.format("new ShortNode(%s)", target.sourceVariable())));
        } else if (target.field().type() instanceof FieldType.Int32FieldType || target.field().type() instanceof FieldType.Uint16FieldType) {
            this.headerGenerator.addImport("com.fasterxml.jackson.databind.node.IntNode");
            this.buffer.printf("%s;%n", target.assignmentStatement(String.format("new IntNode(%s)", target.sourceVariable())));
        } else if (target.field().type() instanceof FieldType.Int64FieldType || target.field().type() instanceof FieldType.Uint32FieldType) {
            this.headerGenerator.addImport("com.fasterxml.jackson.databind.node.LongNode");
            this.buffer.printf("%s;%n", target.assignmentStatement(String.format("new LongNode(%s)", target.sourceVariable())));
        } else if (target.field().type() instanceof FieldType.UUIDFieldType) {
            this.headerGenerator.addImport("com.fasterxml.jackson.databind.node.TextNode");
            this.buffer.printf("%s;%n", target.assignmentStatement(String.format("new TextNode(%s.toString())", target.sourceVariable())));
        } else if (target.field().type() instanceof FieldType.Float64FieldType) {
            this.headerGenerator.addImport("com.fasterxml.jackson.databind.node.DoubleNode");
            this.buffer.printf("%s;%n", target.assignmentStatement(String.format("new DoubleNode(%s)", target.sourceVariable())));
        } else {
            IsNullConditional.forName(target.sourceVariable()).nullableVersions(target.field().nullableVersions()).possibleVersions(versions).conditionalGenerator((name, negated) -> String.format("%s %s= null", name, negated ? "!" : "=")).ifNull(() -> {
                this.headerGenerator.addImport("com.fasterxml.jackson.databind.node.NullNode");
                this.buffer.printf("%s;%n", target.assignmentStatement("NullNode.instance"));
            }).ifShouldNotBeNull(() -> this.generateVariableLengthTargetToJson(target, versions)).generate(this.buffer);
        }
    }

    private void generateVariableLengthTargetToJson(Target target, Versions versions) {
        if (target.field().type().isString()) {
            this.headerGenerator.addImport("com.fasterxml.jackson.databind.node.TextNode");
            this.buffer.printf("%s;%n", target.assignmentStatement(String.format("new TextNode(%s)", target.sourceVariable())));
        } else if (target.field().type().isBytes()) {
            this.headerGenerator.addImport("com.fasterxml.jackson.databind.node.BinaryNode");
            if (target.field().zeroCopy()) {
                this.headerGenerator.addImport("org.apache.kafka.common.protocol.MessageUtil");
                this.buffer.printf("%s;%n", target.assignmentStatement(String.format("new BinaryNode(MessageUtil.byteBufferToArray(%s))", target.sourceVariable())));
            } else {
                this.headerGenerator.addImport("java.util.Arrays");
                this.buffer.printf("%s;%n", target.assignmentStatement(String.format("new BinaryNode(Arrays.copyOf(%s, %s.length))", target.sourceVariable(), target.sourceVariable())));
            }
        } else if (target.field().type().isRecords()) {
            this.headerGenerator.addImport("com.fasterxml.jackson.databind.node.BinaryNode");
            this.headerGenerator.addImport("com.fasterxml.jackson.databind.node.IntNode");
            this.buffer.printf("if (_serializeRecords) {%n", new Object[0]);
            this.buffer.incrementIndent();
            this.buffer.printf("%s;%n", target.assignmentStatement("new BinaryNode(new byte[]{})"));
            this.buffer.decrementIndent();
            this.buffer.printf("} else {%n", new Object[0]);
            this.buffer.incrementIndent();
            this.buffer.printf("_node.set(\"%sSizeInBytes\", new IntNode(%s.sizeInBytes()));%n", target.field().camelCaseName(), target.sourceVariable());
            this.buffer.decrementIndent();
            this.buffer.printf("}%n", new Object[0]);
        } else if (target.field().type().isArray()) {
            this.headerGenerator.addImport("com.fasterxml.jackson.databind.node.ArrayNode");
            this.headerGenerator.addImport("com.fasterxml.jackson.databind.node.JsonNodeFactory");
            FieldType.ArrayType arrayType = (FieldType.ArrayType)target.field().type();
            FieldType elementType = arrayType.elementType();
            String arrayInstanceName = String.format("_%sArray", target.field().camelCaseName());
            this.buffer.printf("ArrayNode %s = new ArrayNode(JsonNodeFactory.instance);%n", arrayInstanceName);
            this.buffer.printf("for (%s _element : %s) {%n", elementType.getBoxedJavaType(this.headerGenerator), target.sourceVariable());
            this.buffer.incrementIndent();
            this.generateTargetToJson(target.arrayElementTarget(input -> String.format("%s.add(%s)", arrayInstanceName, input)), versions);
            this.buffer.decrementIndent();
            this.buffer.printf("}%n", new Object[0]);
            this.buffer.printf("%s;%n", target.assignmentStatement(arrayInstanceName));
        } else if (target.field().type().isStruct()) {
            this.buffer.printf("%s;%n", target.assignmentStatement(String.format("%sJsonConverter.write(%s, _version, _serializeRecords)", target.field().type().toString(), target.sourceVariable())));
        } else {
            throw new RuntimeException("unknown type " + target.field().type());
        }
    }
}

