/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.message;

import org.apache.kafka.message.Versions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=120L)
public class VersionsTest {
    private static Versions newVersions(int lower, int higher) {
        if (lower < Short.MIN_VALUE || lower > Short.MAX_VALUE) {
            throw new RuntimeException("lower bound out of range.");
        }
        if (higher < Short.MIN_VALUE || higher > Short.MAX_VALUE) {
            throw new RuntimeException("higher bound out of range.");
        }
        return new Versions((short)lower, (short)higher);
    }

    @Test
    public void testVersionsParse() {
        Assertions.assertEquals((Object)Versions.NONE, (Object)Versions.parse(null, (Versions)Versions.NONE));
        Assertions.assertEquals((Object)Versions.ALL, (Object)Versions.parse((String)" ", (Versions)Versions.ALL));
        Assertions.assertEquals((Object)Versions.ALL, (Object)Versions.parse((String)"", (Versions)Versions.ALL));
        Assertions.assertEquals((Object)VersionsTest.newVersions(4, 5), (Object)Versions.parse((String)" 4-5 ", null));
    }

    @Test
    public void testRoundTrips() {
        this.testRoundTrip(Versions.ALL, "0+");
        this.testRoundTrip(VersionsTest.newVersions(1, 3), "1-3");
        this.testRoundTrip(VersionsTest.newVersions(2, 2), "2");
        this.testRoundTrip(VersionsTest.newVersions(3, Short.MAX_VALUE), "3+");
        this.testRoundTrip(Versions.NONE, "none");
    }

    private void testRoundTrip(Versions versions, String string) {
        Assertions.assertEquals((Object)string, (Object)versions.toString());
        Assertions.assertEquals((Object)versions, (Object)Versions.parse((String)versions.toString(), null));
    }

    @Test
    public void testIntersections() {
        Assertions.assertEquals((Object)VersionsTest.newVersions(2, 3), (Object)VersionsTest.newVersions(1, 3).intersect(VersionsTest.newVersions(2, 4)));
        Assertions.assertEquals((Object)VersionsTest.newVersions(3, 3), (Object)VersionsTest.newVersions(0, Short.MAX_VALUE).intersect(VersionsTest.newVersions(3, 3)));
        Assertions.assertEquals((Object)Versions.NONE, (Object)VersionsTest.newVersions(9, Short.MAX_VALUE).intersect(VersionsTest.newVersions(2, 8)));
        Assertions.assertEquals((Object)Versions.NONE, (Object)Versions.NONE.intersect(Versions.NONE));
    }

    @Test
    public void testContains() {
        Assertions.assertTrue((boolean)VersionsTest.newVersions(2, 3).contains((short)3));
        Assertions.assertTrue((boolean)VersionsTest.newVersions(2, 3).contains((short)2));
        Assertions.assertFalse((boolean)VersionsTest.newVersions(0, 1).contains((short)2));
        Assertions.assertTrue((boolean)VersionsTest.newVersions(0, Short.MAX_VALUE).contains((short)100));
        Assertions.assertFalse((boolean)VersionsTest.newVersions(2, Short.MAX_VALUE).contains((short)0));
        Assertions.assertTrue((boolean)VersionsTest.newVersions(2, 3).contains(VersionsTest.newVersions(2, 3)));
        Assertions.assertTrue((boolean)VersionsTest.newVersions(2, 3).contains(VersionsTest.newVersions(2, 2)));
        Assertions.assertFalse((boolean)VersionsTest.newVersions(2, 3).contains(VersionsTest.newVersions(2, 4)));
        Assertions.assertTrue((boolean)VersionsTest.newVersions(2, 3).contains(Versions.NONE));
        Assertions.assertTrue((boolean)Versions.ALL.contains(VersionsTest.newVersions(1, 2)));
    }

    @Test
    public void testSubtract() {
        Assertions.assertEquals((Object)Versions.NONE, (Object)Versions.NONE.subtract(Versions.NONE));
        Assertions.assertEquals((Object)VersionsTest.newVersions(0, 0), (Object)VersionsTest.newVersions(0, 0).subtract(Versions.NONE));
        Assertions.assertEquals((Object)VersionsTest.newVersions(1, 1), (Object)VersionsTest.newVersions(1, 2).subtract(VersionsTest.newVersions(2, 2)));
        Assertions.assertEquals((Object)VersionsTest.newVersions(2, 2), (Object)VersionsTest.newVersions(1, 2).subtract(VersionsTest.newVersions(1, 1)));
        Assertions.assertNull((Object)VersionsTest.newVersions(0, Short.MAX_VALUE).subtract(VersionsTest.newVersions(1, 100)));
        Assertions.assertEquals((Object)VersionsTest.newVersions(10, 10), (Object)VersionsTest.newVersions(1, 10).subtract(VersionsTest.newVersions(1, 9)));
        Assertions.assertEquals((Object)VersionsTest.newVersions(1, 1), (Object)VersionsTest.newVersions(1, 10).subtract(VersionsTest.newVersions(2, 10)));
        Assertions.assertEquals((Object)VersionsTest.newVersions(2, 4), (Object)VersionsTest.newVersions(2, Short.MAX_VALUE).subtract(VersionsTest.newVersions(5, Short.MAX_VALUE)));
        Assertions.assertEquals((Object)VersionsTest.newVersions(5, Short.MAX_VALUE), (Object)VersionsTest.newVersions(0, Short.MAX_VALUE).subtract(VersionsTest.newVersions(0, 4)));
    }
}

