/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.message;

import java.util.Arrays;
import java.util.Collections;
import org.apache.kafka.message.FieldSpec;
import org.apache.kafka.message.MessageGenerator;
import org.apache.kafka.message.MessageSpec;
import org.apache.kafka.message.StructRegistry;
import org.apache.kafka.message.StructSpec;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=120L)
public class StructRegistryTest {
    @Test
    public void testCommonStructs() throws Exception {
        MessageSpec testMessageSpec = (MessageSpec)MessageGenerator.JSON_SERDE.readValue(String.join((CharSequence)"", Arrays.asList("{", "  \"type\": \"request\",", "  \"name\": \"LeaderAndIsrRequest\",", "  \"validVersions\": \"0-2\",", "  \"flexibleVersions\": \"0+\",", "  \"fields\": [", "    { \"name\": \"field1\", \"type\": \"int32\", \"versions\": \"0+\" },", "    { \"name\": \"field2\", \"type\": \"[]TestCommonStruct\", \"versions\": \"1+\" },", "    { \"name\": \"field3\", \"type\": \"[]TestInlineStruct\", \"versions\": \"0+\", ", "    \"fields\": [", "      { \"name\": \"inlineField1\", \"type\": \"int64\", \"versions\": \"0+\" }", "    ]}", "  ],", "  \"commonStructs\": [", "    { \"name\": \"TestCommonStruct\", \"versions\": \"0+\", \"fields\": [", "      { \"name\": \"commonField1\", \"type\": \"int64\", \"versions\": \"0+\" }", "    ]}", "  ]", "}")), MessageSpec.class);
        StructRegistry structRegistry = new StructRegistry();
        structRegistry.register(testMessageSpec);
        Assertions.assertEquals((Object)structRegistry.commonStructNames(), Collections.singleton("TestCommonStruct"));
        Assertions.assertFalse((boolean)structRegistry.isStructArrayWithKeys((FieldSpec)testMessageSpec.fields().get(1)));
        Assertions.assertFalse((boolean)structRegistry.isStructArrayWithKeys((FieldSpec)testMessageSpec.fields().get(2)));
        Assertions.assertTrue((boolean)structRegistry.commonStructs().hasNext());
        Assertions.assertEquals((Object)((StructSpec)structRegistry.commonStructs().next()).name(), (Object)"TestCommonStruct");
    }

    @Test
    public void testReSpecifiedCommonStructError() throws Exception {
        MessageSpec testMessageSpec = (MessageSpec)MessageGenerator.JSON_SERDE.readValue(String.join((CharSequence)"", Arrays.asList("{", "  \"type\": \"request\",", "  \"name\": \"LeaderAndIsrRequest\",", "  \"validVersions\": \"0-2\",", "  \"flexibleVersions\": \"0+\",", "  \"fields\": [", "    { \"name\": \"field1\", \"type\": \"int32\", \"versions\": \"0+\" },", "    { \"name\": \"field2\", \"type\": \"[]TestCommonStruct\", \"versions\": \"0+\", ", "    \"fields\": [", "      { \"name\": \"inlineField1\", \"type\": \"int64\", \"versions\": \"0+\" }", "    ]}", "  ],", "  \"commonStructs\": [", "    { \"name\": \"TestCommonStruct\", \"versions\": \"0+\", \"fields\": [", "      { \"name\": \"commonField1\", \"type\": \"int64\", \"versions\": \"0+\" }", "    ]}", "  ]", "}")), MessageSpec.class);
        StructRegistry structRegistry = new StructRegistry();
        try {
            structRegistry.register(testMessageSpec);
            Assertions.fail((String)"Expected StructRegistry#registry to fail");
        }
        catch (RuntimeException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("Can't re-specify the common struct TestCommonStruct as an inline struct."));
        }
    }

    @Test
    public void testDuplicateCommonStructError() throws Exception {
        MessageSpec testMessageSpec = (MessageSpec)MessageGenerator.JSON_SERDE.readValue(String.join((CharSequence)"", Arrays.asList("{", "  \"type\": \"request\",", "  \"name\": \"LeaderAndIsrRequest\",", "  \"validVersions\": \"0-2\",", "  \"flexibleVersions\": \"0+\",", "  \"fields\": [", "    { \"name\": \"field1\", \"type\": \"int32\", \"versions\": \"0+\" }", "  ],", "  \"commonStructs\": [", "    { \"name\": \"TestCommonStruct\", \"versions\": \"0+\", \"fields\": [", "      { \"name\": \"commonField1\", \"type\": \"int64\", \"versions\": \"0+\" }", "    ]},", "    { \"name\": \"TestCommonStruct\", \"versions\": \"0+\", \"fields\": [", "      { \"name\": \"commonField1\", \"type\": \"int64\", \"versions\": \"0+\" }", "    ]}", "  ]", "}")), MessageSpec.class);
        StructRegistry structRegistry = new StructRegistry();
        try {
            structRegistry.register(testMessageSpec);
            Assertions.fail((String)"Expected StructRegistry#registry to fail");
        }
        catch (RuntimeException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("Common struct TestCommonStruct was specified twice."));
        }
    }

    @Test
    public void testSingleStruct() throws Exception {
        MessageSpec testMessageSpec = (MessageSpec)MessageGenerator.JSON_SERDE.readValue(String.join((CharSequence)"", Arrays.asList("{", "  \"type\": \"request\",", "  \"name\": \"LeaderAndIsrRequest\",", "  \"validVersions\": \"0-2\",", "  \"flexibleVersions\": \"0+\",", "  \"fields\": [", "    { \"name\": \"field1\", \"type\": \"int32\", \"versions\": \"0+\" },", "    { \"name\": \"field2\", \"type\": \"TestInlineStruct\", \"versions\": \"0+\", ", "    \"fields\": [", "      { \"name\": \"inlineField1\", \"type\": \"int64\", \"versions\": \"0+\" }", "    ]}", "  ]", "}")), MessageSpec.class);
        StructRegistry structRegistry = new StructRegistry();
        structRegistry.register(testMessageSpec);
        FieldSpec field2 = (FieldSpec)testMessageSpec.fields().get(1);
        Assertions.assertTrue((boolean)field2.type().isStruct());
        Assertions.assertEquals((Object)field2.type().toString(), (Object)"TestInlineStruct");
        Assertions.assertEquals((Object)field2.name(), (Object)"field2");
        Assertions.assertEquals((Object)structRegistry.findStruct(field2).name(), (Object)"TestInlineStruct");
        Assertions.assertFalse((boolean)structRegistry.isStructArrayWithKeys(field2));
    }
}

