/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.message;

import java.util.Arrays;
import org.apache.kafka.message.MessageDataGenerator;
import org.apache.kafka.message.MessageGenerator;
import org.apache.kafka.message.MessageSpec;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=120L)
public class MessageDataGeneratorTest {
    @Test
    public void testNullDefaults() throws Exception {
        MessageSpec testMessageSpec = (MessageSpec)MessageGenerator.JSON_SERDE.readValue(String.join((CharSequence)"", Arrays.asList("{", "  \"type\": \"request\",", "  \"name\": \"FooBar\",", "  \"validVersions\": \"0-2\",", "  \"flexibleVersions\": \"none\",", "  \"fields\": [", "    { \"name\": \"field1\", \"type\": \"int32\", \"versions\": \"0+\" },", "    { \"name\": \"field2\", \"type\": \"[]TestStruct\", \"versions\": \"1+\", ", "    \"nullableVersions\": \"1+\", \"default\": \"null\", \"fields\": [", "      { \"name\": \"field1\", \"type\": \"int32\", \"versions\": \"0+\" }", "    ]},", "    { \"name\": \"field3\", \"type\": \"bytes\", \"versions\": \"2+\", ", "      \"nullableVersions\": \"2+\", \"default\": \"null\" }", "  ]", "}")), MessageSpec.class);
        new MessageDataGenerator("org.apache.kafka.common.message").generate(testMessageSpec);
    }

    private void assertStringContains(String substring, String value) {
        Assertions.assertTrue((boolean)value.contains(substring), (String)("Expected string to contain '" + substring + "', but it was " + value));
    }

    @Test
    public void testInvalidNullDefaultForInt() throws Exception {
        MessageSpec testMessageSpec = (MessageSpec)MessageGenerator.JSON_SERDE.readValue(String.join((CharSequence)"", Arrays.asList("{", "  \"type\": \"request\",", "  \"name\": \"FooBar\",", "  \"validVersions\": \"0-2\",", "  \"flexibleVersions\": \"none\",", "  \"fields\": [", "    { \"name\": \"field1\", \"type\": \"int32\", \"versions\": \"0+\", \"default\": \"null\" }", "  ]", "}")), MessageSpec.class);
        this.assertStringContains("Invalid default for int32", ((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> new MessageDataGenerator("org.apache.kafka.common.message").generate(testMessageSpec))).getMessage());
    }

    @Test
    public void testInvalidNullDefaultForPotentiallyNonNullableArray() throws Exception {
        MessageSpec testMessageSpec = (MessageSpec)MessageGenerator.JSON_SERDE.readValue(String.join((CharSequence)"", Arrays.asList("{", "  \"type\": \"request\",", "  \"name\": \"FooBar\",", "  \"validVersions\": \"0-2\",", "  \"flexibleVersions\": \"none\",", "  \"fields\": [", "    { \"name\": \"field1\", \"type\": \"[]int32\", \"versions\": \"0+\", \"nullableVersions\": \"1+\", ", "    \"default\": \"null\" }", "  ]", "}")), MessageSpec.class);
        this.assertStringContains("not all versions of this field are nullable", ((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> new MessageDataGenerator("org.apache.kafka.common.message").generate(testMessageSpec))).getMessage());
    }

    @Test
    public void testInvalidFieldName() {
        this.assertStringContains("Invalid field name", Assertions.assertThrows(Throwable.class, () -> MessageGenerator.JSON_SERDE.readValue(String.join((CharSequence)"", Arrays.asList("{", "  \"type\": \"request\",", "  \"name\": \"FooBar\",", "  \"validVersions\": \"0-2\",", "  \"flexibleVersions\": \"0+\",", "  \"fields\": [", "    { \"name\": \"_badName\", \"type\": \"[]int32\", \"versions\": \"0+\" }", "  ]", "}")), MessageSpec.class)).getMessage());
    }

    @Test
    public void testInvalidTagWithoutTaggedVersions() {
        this.assertStringContains("If a tag is specified, taggedVersions must be specified as well.", Assertions.assertThrows(Throwable.class, () -> {
            MessageGenerator.JSON_SERDE.readValue(String.join((CharSequence)"", Arrays.asList("{", "  \"type\": \"request\",", "  \"name\": \"FooBar\",", "  \"validVersions\": \"0-2\",", "  \"flexibleVersions\": \"0+\",", "  \"fields\": [", "    { \"name\": \"field1\", \"type\": \"int32\", \"versions\": \"0+\", \"tag\": 0 }", "  ]", "}")), MessageSpec.class);
            Assertions.fail((String)"Expected the MessageSpec constructor to fail");
        }).getMessage());
    }

    @Test
    public void testInvalidNegativeTag() {
        this.assertStringContains("Tags cannot be negative", Assertions.assertThrows(Throwable.class, () -> MessageGenerator.JSON_SERDE.readValue(String.join((CharSequence)"", Arrays.asList("{", "  \"type\": \"request\",", "  \"name\": \"FooBar\",", "  \"validVersions\": \"0-2\",", "  \"flexibleVersions\": \"0+\",", "  \"fields\": [", "    { \"name\": \"field1\", \"type\": \"int32\", \"versions\": \"0+\", ", "        \"tag\": -1, \"taggedVersions\": \"0+\" }", "  ]", "}")), MessageSpec.class)).getMessage());
    }

    @Test
    public void testInvalidFlexibleVersionsRange() {
        this.assertStringContains("flexibleVersions must be either none, or an open-ended range", Assertions.assertThrows(Throwable.class, () -> MessageGenerator.JSON_SERDE.readValue(String.join((CharSequence)"", Arrays.asList("{", "  \"type\": \"request\",", "  \"name\": \"FooBar\",", "  \"validVersions\": \"0-2\",", "  \"flexibleVersions\": \"0-2\",", "  \"fields\": [", "    { \"name\": \"field1\", \"type\": \"int32\", \"versions\": \"0+\" }", "  ]", "}")), MessageSpec.class)).getMessage());
    }

    @Test
    public void testInvalidSometimesNullableTaggedField() {
        this.assertStringContains("Either all tagged versions must be nullable, or none must be", Assertions.assertThrows(Throwable.class, () -> MessageGenerator.JSON_SERDE.readValue(String.join((CharSequence)"", Arrays.asList("{", "  \"type\": \"request\",", "  \"name\": \"FooBar\",", "  \"validVersions\": \"0-2\",", "  \"flexibleVersions\": \"0+\",", "  \"fields\": [", "    { \"name\": \"field1\", \"type\": \"string\", \"versions\": \"0+\", ", "        \"tag\": 0, \"taggedVersions\": \"0+\", \"nullableVersions\": \"1+\" }", "  ]", "}")), MessageSpec.class)).getMessage());
    }

    @Test
    public void testInvalidTaggedVersionsNotASubetOfVersions() {
        this.assertStringContains("taggedVersions must be a subset of versions", Assertions.assertThrows(Throwable.class, () -> MessageGenerator.JSON_SERDE.readValue(String.join((CharSequence)"", Arrays.asList("{", "  \"type\": \"request\",", "  \"name\": \"FooBar\",", "  \"validVersions\": \"0-2\",", "  \"flexibleVersions\": \"0+\",", "  \"fields\": [", "    { \"name\": \"field1\", \"type\": \"string\", \"versions\": \"0-2\", ", "        \"tag\": 0, \"taggedVersions\": \"1+\" }", "  ]", "}")), MessageSpec.class)).getMessage());
    }

    @Test
    public void testInvalidTaggedVersionsWithoutTag() {
        this.assertStringContains("Please specify a tag, or remove the taggedVersions", Assertions.assertThrows(Throwable.class, () -> MessageGenerator.JSON_SERDE.readValue(String.join((CharSequence)"", Arrays.asList("{", "  \"type\": \"request\",", "  \"name\": \"FooBar\",", "  \"validVersions\": \"0-2\",", "  \"flexibleVersions\": \"0+\",", "  \"fields\": [", "    { \"name\": \"field1\", \"type\": \"string\", \"versions\": \"0+\", ", "        \"taggedVersions\": \"1+\" }", "  ]", "}")), MessageSpec.class)).getMessage());
    }

    @Test
    public void testInvalidTaggedVersionsRange() {
        this.assertStringContains("taggedVersions must be either none, or an open-ended range", Assertions.assertThrows(Throwable.class, () -> MessageGenerator.JSON_SERDE.readValue(String.join((CharSequence)"", Arrays.asList("{", "  \"type\": \"request\",", "  \"name\": \"FooBar\",", "  \"validVersions\": \"0-2\",", "  \"flexibleVersions\": \"0+\",", "  \"fields\": [", "    { \"name\": \"field1\", \"type\": \"string\", \"versions\": \"0+\", ", "        \"tag\": 0, \"taggedVersions\": \"1-2\" }", "  ]", "}")), MessageSpec.class)).getMessage());
    }

    @Test
    public void testDuplicateTags() {
        this.assertStringContains("duplicate tag", Assertions.assertThrows(Throwable.class, () -> MessageGenerator.JSON_SERDE.readValue(String.join((CharSequence)"", Arrays.asList("{", "  \"type\": \"request\",", "  \"name\": \"FooBar\",", "  \"validVersions\": \"0-2\",", "  \"flexibleVersions\": \"0+\",", "  \"fields\": [", "    { \"name\": \"field1\", \"type\": \"string\", \"versions\": \"0+\", ", "        \"tag\": 0, \"taggedVersions\": \"0+\" },", "    { \"name\": \"field2\", \"type\": \"int64\", \"versions\": \"0+\", ", "        \"tag\": 0, \"taggedVersions\": \"0+\" }", "  ]", "}")), MessageSpec.class)).getMessage());
    }

    @Test
    public void testInvalidNullDefaultForNullableStruct() throws Exception {
        MessageSpec testMessageSpec = (MessageSpec)MessageGenerator.JSON_SERDE.readValue(String.join((CharSequence)"", Arrays.asList("{", "  \"type\": \"request\",", "  \"name\": \"FooBar\",", "  \"validVersions\": \"0\",", "  \"flexibleVersions\": \"none\",", "  \"fields\": [", "    { \"name\": \"struct1\", \"type\": \"MyStruct\", \"versions\": \"0+\", \"nullableVersions\": \"0+\", ", "      \"default\": \"not-null\", \"fields\": [", "        { \"name\": \"field1\", \"type\": \"string\", \"versions\": \"0+\" }", "      ]", "    }", "  ]", "}")), MessageSpec.class);
        this.assertStringContains("Invalid default for struct field struct1.  The only valid default for a struct field is the empty struct or null", ((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> new MessageDataGenerator("org.apache.kafka.common.message").generate(testMessageSpec))).getMessage());
    }

    @Test
    public void testInvalidNullDefaultForPotentiallyNonNullableStruct() throws Exception {
        MessageSpec testMessageSpec = (MessageSpec)MessageGenerator.JSON_SERDE.readValue(String.join((CharSequence)"", Arrays.asList("{", "  \"type\": \"request\",", "  \"name\": \"FooBar\",", "  \"validVersions\": \"0-1\",", "  \"flexibleVersions\": \"none\",", "  \"fields\": [", "    { \"name\": \"struct1\", \"type\": \"MyStruct\", \"versions\": \"0+\", \"nullableVersions\": \"1+\", ", "      \"default\": \"null\", \"fields\": [", "        { \"name\": \"field1\", \"type\": \"string\", \"versions\": \"0+\" }", "      ]", "    }", "  ]", "}")), MessageSpec.class);
        this.assertStringContains("not all versions of this field are nullable", ((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> new MessageDataGenerator("org.apache.kafka.common.message").generate(testMessageSpec))).getMessage());
    }
}

