/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.transforms;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.header.ConnectHeaders;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.transforms.DropHeaders;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DropHeadersTest {
    private final DropHeaders<SourceRecord> xform = new DropHeaders();

    private Map<String, ?> config(String ... headers) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        result.put("headers", Arrays.asList(headers));
        return result;
    }

    @Test
    public void dropExistingHeader() {
        this.xform.configure(this.config("to-drop"));
        ConnectHeaders expected = new ConnectHeaders();
        expected.addString("existing", "existing-value");
        ConnectHeaders headers = expected.duplicate();
        headers.addString("to-drop", "existing-value");
        SourceRecord original = this.sourceRecord(headers);
        SourceRecord xformed = (SourceRecord)this.xform.apply((ConnectRecord)original);
        this.assertNonHeaders(original, xformed);
        Assertions.assertEquals((Object)expected, (Object)xformed.headers());
    }

    @Test
    public void dropExistingHeaderWithMultipleValues() {
        this.xform.configure(this.config("to-drop"));
        ConnectHeaders expected = new ConnectHeaders();
        expected.addString("existing", "existing-value");
        ConnectHeaders headers = expected.duplicate();
        headers.addString("to-drop", "existing-value");
        headers.addString("to-drop", "existing-other-value");
        SourceRecord original = this.sourceRecord(headers);
        SourceRecord xformed = (SourceRecord)this.xform.apply((ConnectRecord)original);
        this.assertNonHeaders(original, xformed);
        Assertions.assertEquals((Object)expected, (Object)xformed.headers());
    }

    @Test
    public void dropNonExistingHeader() {
        this.xform.configure(this.config("to-drop"));
        ConnectHeaders expected = new ConnectHeaders();
        expected.addString("existing", "existing-value");
        ConnectHeaders headers = expected.duplicate();
        SourceRecord original = this.sourceRecord(headers);
        SourceRecord xformed = (SourceRecord)this.xform.apply((ConnectRecord)original);
        this.assertNonHeaders(original, xformed);
        Assertions.assertEquals((Object)expected, (Object)xformed.headers());
    }

    @Test
    public void configRejectsEmptyList() {
        Assertions.assertThrows(ConfigException.class, () -> this.xform.configure(this.config(new String[0])));
    }

    @Test
    public void testDropHeadersVersionRetrievedFromAppInfoParser() {
        Assertions.assertEquals((Object)AppInfoParser.getVersion(), (Object)this.xform.version());
    }

    private void assertNonHeaders(SourceRecord original, SourceRecord xformed) {
        Assertions.assertEquals((Object)original.sourcePartition(), (Object)xformed.sourcePartition());
        Assertions.assertEquals((Object)original.sourceOffset(), (Object)xformed.sourceOffset());
        Assertions.assertEquals((Object)original.topic(), (Object)xformed.topic());
        Assertions.assertEquals((Integer)original.kafkaPartition(), (Integer)xformed.kafkaPartition());
        Assertions.assertEquals((Object)original.keySchema(), (Object)xformed.keySchema());
        Assertions.assertEquals((Object)original.key(), (Object)xformed.key());
        Assertions.assertEquals((Object)original.valueSchema(), (Object)xformed.valueSchema());
        Assertions.assertEquals((Object)original.value(), (Object)xformed.value());
        Assertions.assertEquals((Long)original.timestamp(), (Long)xformed.timestamp());
    }

    private SourceRecord sourceRecord(ConnectHeaders headers) {
        Map<String, String> sourcePartition = Collections.singletonMap("foo", "bar");
        Map<String, String> sourceOffset = Collections.singletonMap("baz", "quxx");
        String topic = "topic";
        Integer partition = 0;
        Schema keySchema = null;
        String key = "key";
        Schema valueSchema = null;
        String value = "value";
        Long timestamp = 0L;
        return new SourceRecord(sourcePartition, sourceOffset, topic, partition, keySchema, (Object)key, valueSchema, (Object)value, timestamp, (Iterable)headers);
    }
}

