/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.util;

import java.security.PrivilegedExceptionAction;
import java.util.Map;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.connect.runtime.WorkerConfig;

public class ImpersonationUtil {
    public static <T> T maybeRunImpersonated(WorkerConfig workerConfig, Map<String, String> taskProps, PrivilegedExceptionAction<T> action) {
        try {
            if (!workerConfig.getBoolean("impersonation.enable").booleanValue()) {
                return action.run();
            }
            String user = taskProps.get("task.user");
            if (user == null || user.isEmpty()) {
                user = UserGroupInformation.getCurrentUser().getShortUserName();
            }
            UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)user, (UserGroupInformation)UserGroupInformation.getCurrentUser());
            return (T)ugi.doAs(action);
        }
        catch (Exception e) {
            throw new KafkaException((Throwable)e);
        }
    }
}

