/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.storage;

import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.util.Callback;
import org.apache.kafka.connect.util.KafkaBasedLog;
import org.apache.kafka.connect.util.TopicAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KafkaTopicBasedBackingStore {
    private static final Logger log = LoggerFactory.getLogger(KafkaTopicBasedBackingStore.class);

    Consumer<TopicAdmin> topicInitializer(String topic, NewTopic topicDescription, WorkerConfig config, Time time) {
        return admin -> {
            log.debug("Creating Connect internal topic for {}", (Object)this.getTopicPurpose());
            Set<String> newTopics = this.createTopics(topicDescription, (TopicAdmin)admin, config, time);
        };
    }

    private Set<String> createTopics(NewTopic topicDescription, TopicAdmin admin, WorkerConfig config, Time time) {
        AdminClientConfig adminClientConfig = new AdminClientConfig(config.originals());
        long timeoutMs = adminClientConfig.getInt("default.api.timeout.ms").intValue();
        long backOffMs = adminClientConfig.getLong("retry.backoff.ms");
        return admin.createTopicsWithRetry(topicDescription, timeoutMs, backOffMs, time);
    }

    <K> KafkaBasedLog<K, byte[]> createKafkaBasedLog(String topic, Map<String, Object> producerProps, Map<String, Object> consumerProps, Callback<ConsumerRecord<K, byte[]>> consumedCallback, NewTopic topicDescription, Supplier<TopicAdmin> adminSupplier, WorkerConfig config, Time time) {
        Consumer<TopicAdmin> createTopics = this.topicInitializer(topic, topicDescription, config, time);
        return new KafkaBasedLog(topic, producerProps, consumerProps, adminSupplier, consumedCallback, time, createTopics);
    }

    protected abstract String getTopicConfig();

    protected abstract String getTopicPurpose();
}

