/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.junit.jupiter.api.Assertions;

public class TestUtils {
    static Map<String, String> makeProps(String ... keyValues) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("name", "ConnectorName");
        props.put("connector.class", "ConnectorClass");
        props.put("source.cluster.alias", "source1");
        props.put("target.cluster.alias", "target2");
        for (int i = 0; i < keyValues.length; i += 2) {
            props.put(keyValues[i], keyValues[i + 1]);
        }
        return props;
    }

    public static List<ProducerRecord<byte[], byte[]>> generateRecords(String topicName, int numRecords) {
        ArrayList<ProducerRecord<byte[], byte[]>> records = new ArrayList<ProducerRecord<byte[], byte[]>>();
        for (int i = 0; i < numRecords; ++i) {
            String key = "key-" + i;
            String value = "message-" + i;
            records.add((ProducerRecord<byte[], byte[]>)new ProducerRecord(topicName, null, (Object)key.getBytes(), (Object)value.getBytes()));
        }
        return records;
    }

    public static List<ProducerRecord<byte[], byte[]>> generateRecords(String topicName, int numRecords, int numPartitions) {
        ArrayList<ProducerRecord<byte[], byte[]>> records = new ArrayList<ProducerRecord<byte[], byte[]>>();
        int cnt = 0;
        for (int r = 0; r < numRecords; ++r) {
            for (int p = 0; p < numPartitions; ++p) {
                String value = "value-" + cnt;
                String key = "key-" + cnt;
                ++cnt;
                records.add((ProducerRecord<byte[], byte[]>)new ProducerRecord(topicName, Integer.valueOf(p), (Object)key.getBytes(), (Object)value.getBytes()));
            }
        }
        return records;
    }

    public static void assertEqualsExceptClientId(Map<String, Object> expected, Map<String, Object> actual) {
        HashMap<String, Object> expectedWithoutClientId = new HashMap<String, Object>(expected);
        expectedWithoutClientId.remove("client.id");
        HashMap<String, Object> actualWithoutClientId = new HashMap<String, Object>(actual);
        actualWithoutClientId.remove("client.id");
        Assertions.assertEquals(expectedWithoutClientId, actualWithoutClientId);
    }
}

