/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.data;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.errors.DataException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TimeTest {
    private static final GregorianCalendar EPOCH = new GregorianCalendar(1970, 0, 1, 0, 0, 0);
    private static final GregorianCalendar EPOCH_PLUS_DATE_COMPONENT;
    private static final GregorianCalendar EPOCH_PLUS_TEN_THOUSAND_MILLIS;

    @Test
    public void testBuilder() {
        Schema plain = Time.SCHEMA;
        Assertions.assertEquals((Object)"org.apache.kafka.connect.data.Time", (Object)plain.name());
        Assertions.assertEquals((Object)1, (Object)plain.version());
    }

    @Test
    public void testFromLogical() {
        Assertions.assertEquals((int)0, (int)Time.fromLogical((Schema)Time.SCHEMA, (Date)EPOCH.getTime()));
        Assertions.assertEquals((int)10000, (int)Time.fromLogical((Schema)Time.SCHEMA, (Date)EPOCH_PLUS_TEN_THOUSAND_MILLIS.getTime()));
    }

    @Test
    public void testFromLogicalInvalidSchema() {
        Assertions.assertThrows(DataException.class, () -> Time.fromLogical((Schema)Time.builder().name("invalid").build(), (Date)EPOCH.getTime()));
    }

    @Test
    public void testFromLogicalInvalidHasDateComponents() {
        Assertions.assertThrows(DataException.class, () -> Time.fromLogical((Schema)Time.SCHEMA, (Date)EPOCH_PLUS_DATE_COMPONENT.getTime()));
    }

    @Test
    public void testToLogical() {
        Assertions.assertEquals((Object)EPOCH.getTime(), (Object)Time.toLogical((Schema)Time.SCHEMA, (int)0));
        Assertions.assertEquals((Object)EPOCH_PLUS_TEN_THOUSAND_MILLIS.getTime(), (Object)Time.toLogical((Schema)Time.SCHEMA, (int)10000));
    }

    @Test
    public void testToLogicalInvalidSchema() {
        Assertions.assertThrows(DataException.class, () -> Time.toLogical((Schema)Time.builder().name("invalid").build(), (int)0));
    }

    static {
        EPOCH.setTimeZone(TimeZone.getTimeZone("UTC"));
        EPOCH_PLUS_TEN_THOUSAND_MILLIS = new GregorianCalendar(1970, 0, 1, 0, 0, 0);
        EPOCH_PLUS_TEN_THOUSAND_MILLIS.setTimeZone(TimeZone.getTimeZone("UTC"));
        EPOCH_PLUS_TEN_THOUSAND_MILLIS.add(14, 10000);
        EPOCH_PLUS_DATE_COMPONENT = new GregorianCalendar(1970, 0, 1, 0, 0, 0);
        EPOCH_PLUS_DATE_COMPONENT.setTimeZone(TimeZone.getTimeZone("UTC"));
        EPOCH_PLUS_DATE_COMPONENT.add(5, 10000);
    }
}

