/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.connector;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.Connector;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.errors.ConnectException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConnectorReconfigurationTest {
    @Test
    public void testDefaultReconfigure() {
        TestConnector conn = new TestConnector(false);
        conn.reconfigure(Collections.emptyMap());
        Assertions.assertEquals((int)conn.stopOrder, (int)0);
        Assertions.assertEquals((int)conn.configureOrder, (int)1);
    }

    @Test
    public void testReconfigureStopException() {
        TestConnector conn = new TestConnector(true);
        Assertions.assertThrows(ConnectException.class, () -> conn.reconfigure(Collections.emptyMap()));
    }

    private static class TestConnector
    extends Connector {
        private boolean stopException;
        private int order = 0;
        public int stopOrder = -1;
        public int configureOrder = -1;

        public TestConnector(boolean stopException) {
            this.stopException = stopException;
        }

        public String version() {
            return "1.0";
        }

        public void start(Map<String, String> props) {
            this.configureOrder = this.order++;
        }

        public Class<? extends Task> taskClass() {
            return null;
        }

        public List<Map<String, String>> taskConfigs(int count) {
            return null;
        }

        public void stop() {
            this.stopOrder = this.order++;
            if (this.stopException) {
                throw new ConnectException("error");
            }
        }

        public ConfigDef config() {
            return new ConfigDef();
        }
    }
}

