/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.connector;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.connector.Connector;
import org.apache.kafka.connect.connector.ConnectorContext;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class ConnectorTest {
    protected ConnectorContext context;
    protected Connector connector;
    protected AssertableConnector assertableConnector;

    @BeforeEach
    public void beforeEach() {
        this.connector = this.createConnector();
        this.context = this.createContext();
        this.assertableConnector = (AssertableConnector)this.connector;
    }

    @Test
    public void shouldInitializeContext() {
        this.connector.initialize(this.context);
        this.assertableConnector.assertInitialized();
        this.assertableConnector.assertContext(this.context);
        this.assertableConnector.assertTaskConfigs(null);
    }

    @Test
    public void shouldInitializeContextWithTaskConfigs() {
        ArrayList<Map<String, String>> taskConfigs = new ArrayList<Map<String, String>>();
        this.connector.initialize(this.context, taskConfigs);
        this.assertableConnector.assertInitialized();
        this.assertableConnector.assertContext(this.context);
        this.assertableConnector.assertTaskConfigs(taskConfigs);
    }

    @Test
    public void shouldStopAndStartWhenReconfigure() {
        HashMap<String, String> props = new HashMap<String, String>();
        this.connector.initialize(this.context);
        this.assertableConnector.assertContext(this.context);
        this.assertableConnector.assertStarted(false);
        this.assertableConnector.assertStopped(false);
        this.connector.reconfigure(props);
        this.assertableConnector.assertStarted(true);
        this.assertableConnector.assertStopped(true);
        this.assertableConnector.assertProperties(props);
    }

    protected abstract ConnectorContext createContext();

    protected abstract Connector createConnector();

    public static interface AssertableConnector {
        public void assertContext(ConnectorContext var1);

        public void assertInitialized();

        public void assertTaskConfigs(List<Map<String, String>> var1);

        public void assertStarted(boolean var1);

        public void assertStopped(boolean var1);

        public void assertProperties(Map<String, String> var1);
    }
}

