/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.shims;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.DefaultFileAccess;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.ProxyFileSystem;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.fs.TrashPolicy;
import org.apache.hadoop.fs.permission.AccessControlException;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.HadoopShimsSecure;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.hive.shims.ZeroCopyShims;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.WebHCatJTShim23;
import org.apache.hadoop.mapred.lib.TotalOrderPartitioner;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.hadoop.util.Progressable;
import org.apache.tez.test.MiniTezCluster;

public class Hadoop23Shims
extends HadoopShimsSecure {
    HadoopShims.MiniDFSShim cluster = null;
    final boolean zeroCopy;
    private volatile HadoopShims.HCatHadoopShims hcatShimInstance;
    protected static final Method accessMethod;
    protected static final Method getPasswordMethod;

    public Hadoop23Shims() {
        boolean zcr = false;
        try {
            Class.forName("org.apache.hadoop.fs.CacheFlag", false, ShimLoader.class.getClassLoader());
            zcr = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.zeroCopy = zcr;
    }

    public String getTaskAttemptLogUrl(JobConf conf, String taskTrackerHttpAddress, String taskAttemptId) throws MalformedURLException {
        if (conf.get("mapreduce.framework.name") != null && conf.get("mapreduce.framework.name").equals("yarn")) {
            LOG.warn((Object)"Can't fetch tasklog: TaskLogServlet is not supported in MR2 mode.");
            return null;
        }
        LOG.warn((Object)"Can't fetch tasklog: TaskLogServlet is not supported in MR1 mode.");
        return null;
    }

    public HadoopShims.JobTrackerState getJobTrackerState(ClusterStatus clusterStatus) throws Exception {
        switch (clusterStatus.getJobTrackerStatus()) {
            case INITIALIZING: {
                return HadoopShims.JobTrackerState.INITIALIZING;
            }
            case RUNNING: {
                return HadoopShims.JobTrackerState.RUNNING;
            }
        }
        String errorMsg = "Unrecognized JobTracker state: " + clusterStatus.getJobTrackerStatus();
        throw new Exception(errorMsg);
    }

    public TaskAttemptContext newTaskAttemptContext(Configuration conf, final Progressable progressable) {
        TaskAttemptID taskAttemptId = TaskAttemptID.forName((String)conf.get("mapreduce.task.attempt.id"));
        if (taskAttemptId == null) {
            taskAttemptId = new TaskAttemptID();
        }
        return new TaskAttemptContextImpl(conf, taskAttemptId){

            public void progress() {
                progressable.progress();
            }
        };
    }

    public TaskAttemptID newTaskAttemptID(JobID jobId, boolean isMap, int taskId, int id) {
        return new TaskAttemptID(jobId.getJtIdentifier(), jobId.getId(), isMap ? TaskType.MAP : TaskType.REDUCE, taskId, id);
    }

    public org.apache.hadoop.mapreduce.JobContext newJobContext(Job job) {
        return new JobContextImpl(job.getConfiguration(), job.getJobID());
    }

    public String getKerberosShortName(String kerberosLongName) throws IOException {
        KerberosName kerberosName = new KerberosName(kerberosLongName);
        return kerberosName.getShortName();
    }

    public boolean isLocalMode(Configuration conf) {
        return "local".equals(conf.get("mapreduce.framework.name"));
    }

    public String getJobLauncherRpcAddress(Configuration conf) {
        return conf.get("yarn.resourcemanager.address");
    }

    public void setJobLauncherRpcAddress(Configuration conf, String val) {
        if (val.equals("local")) {
            conf.set("mapreduce.framework.name", val);
            conf.set("mapreduce.jobtracker.address", val);
        } else {
            conf.set("mapreduce.framework.name", "yarn");
            conf.set("yarn.resourcemanager.address", val);
        }
    }

    public String getJobLauncherHttpAddress(Configuration conf) {
        return conf.get("yarn.resourcemanager.webapp.address");
    }

    protected boolean isExtendedAclEnabled(Configuration conf) {
        return Objects.equal((Object)conf.get("dfs.namenode.acls.enabled"), (Object)"true");
    }

    public long getDefaultBlockSize(FileSystem fs, Path path) {
        return fs.getDefaultBlockSize(path);
    }

    public short getDefaultReplication(FileSystem fs, Path path) {
        return fs.getDefaultReplication(path);
    }

    public boolean moveToAppropriateTrash(FileSystem fs, Path path, Configuration conf) throws IOException {
        return Trash.moveToAppropriateTrash((FileSystem)fs, (Path)path, (Configuration)conf);
    }

    public void setTotalOrderPartitionFile(JobConf jobConf, Path partitionFile) {
        TotalOrderPartitioner.setPartitionFile((JobConf)jobConf, (Path)partitionFile);
    }

    public Comparator<LongWritable> getLongComparator() {
        return new Comparator<LongWritable>(){

            @Override
            public int compare(LongWritable o1, LongWritable o2) {
                return o1.compareTo(o2);
            }
        };
    }

    public MiniMrShim getMiniMrCluster(Configuration conf, int numberOfTaskTrackers, String nameNode, int numDir) throws IOException {
        return new MiniMrShim(conf, numberOfTaskTrackers, nameNode, numDir);
    }

    public MiniMrShim getMiniTezCluster(Configuration conf, int numberOfTaskTrackers, String nameNode, int numDir) throws IOException {
        return new MiniTezShim(conf, numberOfTaskTrackers, nameNode, numDir);
    }

    public HadoopShims.MiniDFSShim getMiniDfs(Configuration conf, int numDataNodes, boolean format, String[] racks) throws IOException {
        this.cluster = new MiniDFSShim(new MiniDFSCluster(conf, numDataNodes, format, racks));
        return this.cluster;
    }

    public HadoopShims.HCatHadoopShims getHCatShim() {
        if (this.hcatShimInstance == null) {
            this.hcatShimInstance = new HCatHadoopShims23();
        }
        return this.hcatShimInstance;
    }

    public HadoopShims.WebHCatJTShim getWebHCatShim(Configuration conf, UserGroupInformation ugi) throws IOException {
        return new WebHCatJTShim23(conf, ugi);
    }

    public List<FileStatus> listLocatedStatus(FileSystem fs, Path path, PathFilter filter) throws IOException {
        RemoteIterator itr = fs.listLocatedStatus(path);
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        while (itr.hasNext()) {
            FileStatus stat = (FileStatus)itr.next();
            if (filter != null && !filter.accept(stat.getPath())) continue;
            result.add(stat);
        }
        return result;
    }

    public BlockLocation[] getLocations(FileSystem fs, FileStatus status) throws IOException {
        if (status instanceof LocatedFileStatus) {
            return ((LocatedFileStatus)status).getBlockLocations();
        }
        return fs.getFileBlockLocations(status, 0L, status.getLen());
    }

    public TreeMap<Long, BlockLocation> getLocationsWithOffset(FileSystem fs, FileStatus status) throws IOException {
        BlockLocation[] locations;
        TreeMap<Long, BlockLocation> offsetBlockMap = new TreeMap<Long, BlockLocation>();
        for (BlockLocation location : locations = this.getLocations(fs, status)) {
            offsetBlockMap.put(location.getOffset(), location);
        }
        return offsetBlockMap;
    }

    public void hflush(FSDataOutputStream stream) throws IOException {
        stream.hflush();
    }

    public HadoopShims.HdfsFileStatus getFullFileStatus(Configuration conf, FileSystem fs, Path file) throws IOException {
        FileStatus fileStatus = fs.getFileStatus(file);
        AclStatus aclStatus = null;
        if (this.isExtendedAclEnabled(conf)) {
            aclStatus = fs.getAclStatus(file);
        }
        return new Hadoop23FileStatus(fileStatus, aclStatus);
    }

    public void setFullFileStatus(Configuration conf, HadoopShims.HdfsFileStatus sourceStatus, FileSystem fs, Path target) throws IOException {
        String group = sourceStatus.getFileStatus().getGroup();
        try {
            FsShell fsShell = new FsShell();
            fsShell.setConf(conf);
            this.run(fsShell, new String[]{"-chgrp", "-R", group, target.toString()});
            if (this.isExtendedAclEnabled(conf)) {
                AclStatus aclStatus = ((Hadoop23FileStatus)sourceStatus).getAclStatus();
                List aclEntries = aclStatus.getEntries();
                this.removeBaseAclEntries(aclEntries);
                FsPermission sourcePerm = sourceStatus.getFileStatus().getPermission();
                aclEntries.add(this.newAclEntry(AclEntryScope.ACCESS, AclEntryType.USER, sourcePerm.getUserAction()));
                aclEntries.add(this.newAclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, sourcePerm.getGroupAction()));
                aclEntries.add(this.newAclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, sourcePerm.getOtherAction()));
                String aclEntry = Joiner.on((String)",").join((Iterable)aclStatus.getEntries());
                this.run(fsShell, new String[]{"-setfacl", "-R", "--set", aclEntry, target.toString()});
            } else {
                String permission = Integer.toString(sourceStatus.getFileStatus().getPermission().toShort(), 8);
                this.run(fsShell, new String[]{"-chmod", "-R", permission, target.toString()});
            }
        }
        catch (Exception e) {
            throw new IOException("Unable to set permissions of " + target, e);
        }
        try {
            if (LOG.isDebugEnabled()) {
                this.getFullFileStatus(conf, fs, target).debugLog();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private AclEntry newAclEntry(AclEntryScope scope, AclEntryType type, FsAction permission) {
        return new AclEntry.Builder().setScope(scope).setType(type).setPermission(permission).build();
    }

    private void removeBaseAclEntries(List<AclEntry> entries) {
        Iterables.removeIf(entries, (Predicate)new Predicate<AclEntry>(){

            public boolean apply(AclEntry input) {
                return input.getName() == null;
            }
        });
    }

    public FileSystem createProxyFileSystem(FileSystem fs, URI uri) {
        return new ProxyFileSystem23(fs, uri);
    }

    public Map<String, String> getHadoopConfNames() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("HADOOPFS", "fs.defaultFS");
        ret.put("HADOOPMAPFILENAME", "mapreduce.map.input.file");
        ret.put("HADOOPMAPREDINPUTDIR", "mapreduce.input.fileinputformat.inputdir");
        ret.put("HADOOPMAPREDINPUTDIRRECURSIVE", "mapreduce.input.fileinputformat.input.dir.recursive");
        ret.put("MAPREDMAXSPLITSIZE", "mapreduce.input.fileinputformat.split.maxsize");
        ret.put("MAPREDMINSPLITSIZE", "mapreduce.input.fileinputformat.split.minsize");
        ret.put("MAPREDMINSPLITSIZEPERNODE", "mapreduce.input.fileinputformat.split.minsize.per.node");
        ret.put("MAPREDMINSPLITSIZEPERRACK", "mapreduce.input.fileinputformat.split.minsize.per.rack");
        ret.put("HADOOPNUMREDUCERS", "mapreduce.job.reduces");
        ret.put("HADOOPJOBNAME", "mapreduce.job.name");
        ret.put("HADOOPSPECULATIVEEXECREDUCERS", "mapreduce.reduce.speculative");
        ret.put("MAPREDSETUPCLEANUPNEEDED", "mapreduce.job.committer.setup.cleanup.needed");
        ret.put("MAPREDTASKCLEANUPNEEDED", "mapreduce.job.committer.task.cleanup.needed");
        return ret;
    }

    public HadoopShims.ZeroCopyReaderShim getZeroCopyReader(FSDataInputStream in, HadoopShims.ByteBufferPoolShim pool) throws IOException {
        if (this.zeroCopy) {
            return ZeroCopyShims.getZeroCopyReader(in, pool);
        }
        return null;
    }

    public HadoopShims.DirectDecompressorShim getDirectDecompressor(HadoopShims.DirectCompressionType codec) {
        if (this.zeroCopy) {
            return ZeroCopyShims.getDirectDecompressor(codec);
        }
        return null;
    }

    public Configuration getConfiguration(org.apache.hadoop.mapreduce.JobContext context) {
        return context.getConfiguration();
    }

    public FileSystem getNonCachedFileSystem(URI uri, Configuration conf) throws IOException {
        return FileSystem.newInstance((URI)uri, (Configuration)conf);
    }

    public void getMergedCredentials(JobConf jobConf) throws IOException {
        jobConf.getCredentials().mergeAll(UserGroupInformation.getCurrentUser().getCredentials());
    }

    public void mergeCredentials(JobConf dest, JobConf src) throws IOException {
        dest.getCredentials().mergeAll(src.getCredentials());
    }

    public void checkFileAccess(FileSystem fs, FileStatus stat, FsAction action) throws IOException, java.security.AccessControlException, Exception {
        try {
            if (accessMethod == null) {
                DefaultFileAccess.checkFileAccess((FileSystem)fs, (FileStatus)stat, (FsAction)action);
            } else {
                accessMethod.invoke((Object)fs, stat.getPath(), action);
            }
        }
        catch (Exception err) {
            throw Hadoop23Shims.wrapAccessException(err);
        }
    }

    private static Exception wrapAccessException(Exception err) {
        int maxDepth = 20;
        Throwable curErr = err;
        for (int idx = 0; curErr != null && idx < 20; curErr = curErr.getCause(), ++idx) {
            if (!(curErr instanceof org.apache.hadoop.security.AccessControlException) && !(curErr instanceof AccessControlException)) continue;
            java.security.AccessControlException newErr = new java.security.AccessControlException(curErr.getMessage());
            newErr.initCause(err);
            return newErr;
        }
        return err;
    }

    public String getPassword(Configuration conf, String name) throws IOException {
        if (getPasswordMethod == null) {
            return conf.get(name);
        }
        try {
            char[] pw = (char[])getPasswordMethod.invoke((Object)conf, name);
            if (pw == null) {
                return null;
            }
            return new String(pw);
        }
        catch (Exception err) {
            throw new IOException(err.getMessage(), err);
        }
    }

    public boolean supportStickyBit() {
        return true;
    }

    public boolean hasStickyBit(FsPermission permission) {
        return permission.getStickyBit();
    }

    public boolean supportTrashFeature() {
        return true;
    }

    public Path getCurrentTrashPath(Configuration conf, FileSystem fs) {
        TrashPolicy tp = TrashPolicy.getInstance((Configuration)conf, (FileSystem)fs, (Path)fs.getHomeDirectory());
        return tp.getCurrentTrashDir();
    }

    public KerberosNameShim getKerberosNameShim(String name) throws IOException {
        return new KerberosNameShim(name);
    }

    static {
        Method m = null;
        try {
            m = FileSystem.class.getMethod("access", Path.class, FsAction.class);
        }
        catch (NoSuchMethodException err) {
            // empty catch block
        }
        accessMethod = m;
        try {
            m = Configuration.class.getMethod("getPassword", String.class);
        }
        catch (NoSuchMethodException err) {
            m = null;
        }
        getPasswordMethod = m;
    }

    public class KerberosNameShim
    implements HadoopShims.KerberosNameShim {
        private KerberosName kerberosName;

        public KerberosNameShim(String name) {
            this.kerberosName = new KerberosName(name);
        }

        public String getDefaultRealm() {
            return this.kerberosName.getDefaultRealm();
        }

        public String getServiceName() {
            return this.kerberosName.getServiceName();
        }

        public String getHostName() {
            return this.kerberosName.getHostName();
        }

        public String getRealm() {
            return this.kerberosName.getRealm();
        }

        public String getShortName() throws IOException {
            return this.kerberosName.getShortName();
        }
    }

    class ProxyFileSystem23
    extends ProxyFileSystem {
        public ProxyFileSystem23(FileSystem fs) {
            super(fs);
        }

        public ProxyFileSystem23(FileSystem fs, URI uri) {
            super(fs, uri);
        }

        public RemoteIterator<LocatedFileStatus> listLocatedStatus(final Path f) throws FileNotFoundException, IOException {
            return new RemoteIterator<LocatedFileStatus>(){
                private RemoteIterator<LocatedFileStatus> stats;
                {
                    this.stats = ProxyFileSystem23.super.listLocatedStatus(ProxyFileSystem23.super.swizzleParamPath(f));
                }

                public boolean hasNext() throws IOException {
                    return this.stats.hasNext();
                }

                public LocatedFileStatus next() throws IOException {
                    LocatedFileStatus result = (LocatedFileStatus)this.stats.next();
                    return new LocatedFileStatus(ProxyFileSystem23.super.swizzleFileStatus((FileStatus)result, false), result.getBlockLocations());
                }
            };
        }

        public void access(Path path, FsAction action) throws java.security.AccessControlException, FileNotFoundException, IOException {
            Path underlyingFsPath = this.swizzleParamPath(path);
            FileStatus underlyingFsStatus = this.fs.getFileStatus(underlyingFsPath);
            try {
                if (accessMethod != null) {
                    accessMethod.invoke((Object)this.fs, underlyingFsPath, action);
                } else {
                    UserGroupInformation ugi = Hadoop23Shims.this.getUGIForConf(this.getConf());
                    DefaultFileAccess.checkFileAccess((FileSystem)this.fs, (FileStatus)underlyingFsStatus, (FsAction)action);
                }
            }
            catch (java.security.AccessControlException err) {
                throw err;
            }
            catch (FileNotFoundException err) {
                throw err;
            }
            catch (IOException err) {
                throw err;
            }
            catch (Exception err) {
                throw new RuntimeException(err.getMessage(), err);
            }
        }
    }

    public class Hadoop23FileStatus
    implements HadoopShims.HdfsFileStatus {
        private FileStatus fileStatus;
        private AclStatus aclStatus;

        public Hadoop23FileStatus(FileStatus fileStatus, AclStatus aclStatus) {
            this.fileStatus = fileStatus;
            this.aclStatus = aclStatus;
        }

        public FileStatus getFileStatus() {
            return this.fileStatus;
        }

        public AclStatus getAclStatus() {
            return this.aclStatus;
        }

        public void debugLog() {
            if (this.fileStatus != null) {
                HadoopShimsSecure.LOG.debug((Object)this.fileStatus.toString());
            }
            if (this.aclStatus != null) {
                HadoopShimsSecure.LOG.debug((Object)this.aclStatus.toString());
            }
        }
    }

    public static class HCatHadoopShims23
    implements HadoopShims.HCatHadoopShims {
        public TaskID createTaskID() {
            return new TaskID("", 0, TaskType.MAP, 0);
        }

        public TaskAttemptID createTaskAttemptID() {
            return new TaskAttemptID("", 0, TaskType.MAP, 0, 0);
        }

        public TaskAttemptContext createTaskAttemptContext(Configuration conf, TaskAttemptID taskId) {
            return new TaskAttemptContextImpl((Configuration)(conf instanceof JobConf ? new JobConf(conf) : conf), taskId);
        }

        public org.apache.hadoop.mapred.TaskAttemptContext createTaskAttemptContext(JobConf conf, org.apache.hadoop.mapred.TaskAttemptID taskId, Progressable progressable) {
            org.apache.hadoop.mapred.TaskAttemptContext newContext = null;
            try {
                Constructor construct = org.apache.hadoop.mapred.TaskAttemptContextImpl.class.getDeclaredConstructor(JobConf.class, org.apache.hadoop.mapred.TaskAttemptID.class, Reporter.class);
                construct.setAccessible(true);
                newContext = (org.apache.hadoop.mapred.TaskAttemptContext)construct.newInstance(new JobConf((Configuration)conf), taskId, (Reporter)progressable);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return newContext;
        }

        public org.apache.hadoop.mapreduce.JobContext createJobContext(Configuration conf, JobID jobId) {
            JobContext jobContext = null;
            try {
                Constructor construct = org.apache.hadoop.mapred.JobContextImpl.class.getDeclaredConstructor(JobConf.class, JobID.class);
                construct.setAccessible(true);
                jobContext = (JobContext)construct.newInstance(new JobConf(conf), jobId);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return jobContext;
        }

        public JobContext createJobContext(JobConf conf, JobID jobId, Progressable progressable) {
            JobContext jobContext = null;
            try {
                Constructor construct = org.apache.hadoop.mapred.JobContextImpl.class.getDeclaredConstructor(JobConf.class, JobID.class, Progressable.class);
                construct.setAccessible(true);
                jobContext = (JobContext)construct.newInstance(new JobConf((Configuration)conf), jobId, (Reporter)progressable);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return jobContext;
        }

        public void commitJob(OutputFormat outputFormat, Job job) throws IOException {
        }

        public void abortJob(OutputFormat outputFormat, Job job) throws IOException {
        }

        public InetSocketAddress getResourceManagerAddress(Configuration conf) {
            String addr = conf.get("yarn.resourcemanager.address", "localhost:8032");
            return NetUtils.createSocketAddr((String)addr);
        }

        public String getPropertyName(HadoopShims.HCatHadoopShims.PropertyName name) {
            switch (name) {
                case CACHE_ARCHIVES: {
                    return "mapreduce.job.cache.archives";
                }
                case CACHE_FILES: {
                    return "mapreduce.job.cache.files";
                }
                case CACHE_SYMLINK: {
                    return "mapreduce.job.cache.symlink.create";
                }
                case CLASSPATH_ARCHIVES: {
                    return "mapreduce.job.classpath.archives";
                }
                case CLASSPATH_FILES: {
                    return "mapreduce.job.classpath.files";
                }
            }
            return "";
        }

        public boolean isFileInHDFS(FileSystem fs, Path path) throws IOException {
            return "hdfs".equals(fs.resolvePath(path).toUri().getScheme());
        }
    }

    public class MiniDFSShim
    implements HadoopShims.MiniDFSShim {
        private final MiniDFSCluster cluster;

        public MiniDFSShim(MiniDFSCluster cluster) {
            this.cluster = cluster;
        }

        public FileSystem getFileSystem() throws IOException {
            return this.cluster.getFileSystem();
        }

        public void shutdown() {
            this.cluster.shutdown();
        }
    }

    public class MiniTezShim
    extends MiniMrShim {
        private final MiniTezCluster mr;
        private final Configuration conf;

        public MiniTezShim(Configuration conf, int numberOfTaskTrackers, String nameNode, int numDir) throws IOException {
            this.mr = new MiniTezCluster("hive", numberOfTaskTrackers);
            conf.set("fs.defaultFS", nameNode);
            conf.set("tez.am.log.level", "DEBUG");
            conf.set("yarn.app.mapreduce.am.staging-dir", "/apps_staging_dir");
            this.mr.init(conf);
            this.mr.start();
            this.conf = this.mr.getConfig();
        }

        @Override
        public int getJobTrackerPort() throws UnsupportedOperationException {
            String address = this.conf.get("yarn.resourcemanager.address");
            if (StringUtils.isBlank((String)(address = StringUtils.substringAfterLast((String)address, (String)":")))) {
                throw new IllegalArgumentException("Invalid YARN resource manager port.");
            }
            return Integer.parseInt(address);
        }

        @Override
        public void shutdown() throws IOException {
            this.mr.stop();
        }

        @Override
        public void setupConfiguration(Configuration conf) {
            Configuration config = this.mr.getConfig();
            for (Map.Entry pair : config) {
                conf.set((String)pair.getKey(), (String)pair.getValue());
            }
            Path jarPath = new Path("hdfs:///user/hive");
            Path hdfsPath = new Path("hdfs:///user/");
            try {
                FileSystem fs = Hadoop23Shims.this.cluster.getFileSystem();
                jarPath = fs.makeQualified(jarPath);
                conf.set("hive.jar.directory", jarPath.toString());
                fs.mkdirs(jarPath);
                hdfsPath = fs.makeQualified(hdfsPath);
                conf.set("hive.user.install.directory", hdfsPath.toString());
                fs.mkdirs(hdfsPath);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public class MiniMrShim
    implements HadoopShims.MiniMrShim {
        private final MiniMRCluster mr;
        private final Configuration conf;

        public MiniMrShim() {
            this.mr = null;
            this.conf = null;
        }

        public MiniMrShim(Configuration conf, int numberOfTaskTrackers, String nameNode, int numDir) throws IOException {
            this.conf = conf;
            JobConf jConf = new JobConf(conf);
            jConf.set("yarn.scheduler.capacity.root.queues", "default");
            jConf.set("yarn.scheduler.capacity.root.default.capacity", "100");
            this.mr = new MiniMRCluster(numberOfTaskTrackers, nameNode, numDir, null, null, jConf);
        }

        public int getJobTrackerPort() throws UnsupportedOperationException {
            String address = this.conf.get("yarn.resourcemanager.address");
            if (StringUtils.isBlank((String)(address = StringUtils.substringAfterLast((String)address, (String)":")))) {
                throw new IllegalArgumentException("Invalid YARN resource manager port.");
            }
            return Integer.parseInt(address);
        }

        public void shutdown() throws IOException {
            this.mr.shutdown();
        }

        public void setupConfiguration(Configuration conf) {
            JobConf jConf = this.mr.createJobConf();
            for (Map.Entry pair : jConf) {
                conf.set((String)pair.getKey(), (String)pair.getValue());
            }
        }
    }
}

